/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import java.util.ArrayList;
import java.util.Map;

public class SettingFlags {
    private static final String COUNTER_FLAG_FILE = "75F0ED65DF2431A0DA6BB3D164054C01";
    private static volatile SharedPreferences sSharedPreferences;
    private static volatile boolean mHasInited;
    private static final ArrayList<String> whiteList;

    public static boolean hasInited() {
        return mHasInited && sSharedPreferences != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context ctx) {
        if (null == ctx || mHasInited) {
            return;
        }
        Class<SettingFlags> clazz = SettingFlags.class;
        synchronized (SettingFlags.class) {
            if (mHasInited) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            sSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences(ctx, COUNTER_FLAG_FILE, 4);
            mHasInited = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void ensureInit() {
        if (!mHasInited && RuntimeContext.sApplicationContext != null) {
            SettingFlags.init(RuntimeContext.sApplicationContext);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static int increase(String key) {
        if (null == key || "".equals(key)) {
            return 0;
        }
        SettingFlags.ensureInit();
        int counter = sSharedPreferences.getInt(key, 0);
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putInt(key, ++counter);
        SettingFlags.applySharedPreference(editor);
        editor = null;
        return counter;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static int decrease(String key) {
        if (null == key || "".equals(key)) {
            return 0;
        }
        SettingFlags.ensureInit();
        int counter = sSharedPreferences.getInt(key, 0);
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putInt(key, --counter);
        SettingFlags.applySharedPreference(editor);
        editor = null;
        return counter;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void setLongValue(String key, long value) {
        if (null == key || "".equals(key)) {
            return;
        }
        if (SettingFlags.getLongValue(key, value - 1L) == value) {
            return;
        }
        SettingFlags.ensureInit();
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putLong(key, value);
        SettingFlags.applySharedPreference(editor);
        editor = null;
    }

    public static void setLongValueSync(String key, long value) {
        if (null == key || "".equals(key)) {
            return;
        }
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putLong(key, value);
        editor.commit();
    }

    public static void setIntValue(String key, int value) {
        if (null == key || "".equals(key)) {
            return;
        }
        if (SettingFlags.getIntValue(key, value - 1) == value) {
            return;
        }
        SettingFlags.ensureInit();
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putInt(key, value);
        SettingFlags.applySharedPreference(editor);
        editor = null;
    }

    public static int getIntValue(String key) {
        if (null == key || "".equals(key)) {
            return 0;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getInt(key, 0);
    }

    public static int getIntValue(String key, int value) {
        if (null == key || "".equals(key)) {
            return value;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getInt(key, value);
    }

    public static long getLongValue(String key) {
        if (null == key || "".equals(key)) {
            return 0L;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getLong(key, -1L);
    }

    public static long getLongValue(String key, long value) {
        if (null == key || "".equals(key)) {
            return 0L;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getLong(key, value);
    }

    public static void setFloatValue(String key, float value) {
        if (null == key || "".equals(key)) {
            return;
        }
        if (SettingFlags.getFloatValue(key, value - 1.0f) == value) {
            return;
        }
        SettingFlags.ensureInit();
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putFloat(key, value);
        SettingFlags.applySharedPreference(editor);
        editor = null;
    }

    public static float getFloatValue(String key) {
        if (null == key || "".equals(key)) {
            return 0.0f;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getFloat(key, -1.0f);
    }

    public static float getFloatValue(String key, float value) {
        if (null == key || "".equals(key)) {
            return 0.0f;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getFloat(key, value);
    }

    public static void setBoolean(String key, boolean value) {
        if (null == key || "".equals(key)) {
            return;
        }
        if (SettingFlags.getBoolean(key, !value) == value) {
            return;
        }
        SettingFlags.ensureInit();
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putBoolean(key, value);
        SettingFlags.applySharedPreference(editor);
        editor = null;
    }

    public static void commit() {
        if (sSharedPreferences != null) {
            sSharedPreferences.edit().commit();
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        if (null == key || "".equals(key)) {
            return defaultValue;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getBoolean(key, defaultValue);
    }

    public static void setStringValue(String key, String value) {
        if (null == key || "".equals(key)) {
            return;
        }
        if (StringUtils.equal(SettingFlags.getStringValue(key, value == null ? "" : null), value)) {
            return;
        }
        SettingFlags.ensureInit();
        SettingFlags.checkStringValueInvalid(key, value);
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putString(key, value);
        SettingFlags.applySharedPreference(editor);
        editor = null;
    }

    private static void checkStringValueInvalid(String key, String value) {
        if (null == value || "".equals(value)) {
            return;
        }
        if (RuntimeContext.sIsDebuggable && !whiteList.contains(key) && (key.length() > 150 || value.length() > 150)) {
            MLog.error((Object)"SettingFlags", "\u5b58\u5165SP\u7684String\u8d85\u8fc7150\u4e2a\u5b57\u7b26 %s", key);
            throw new RuntimeException("\u5b58\u5165SP\u7684String\u8d85\u8fc7150\u4e2a\u5b57\u7b26: " + key + ":" + value);
        }
    }

    public static boolean containKey(String key) {
        SettingFlags.ensureInit();
        return sSharedPreferences.contains(key);
    }

    public static void removeKey(String key) {
        SettingFlags.ensureInit();
        if (!SettingFlags.containKey(key)) {
            return;
        }
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.remove(key);
        SettingFlags.applySharedPreference(editor);
    }

    public static String getStringValue(String key) {
        if (null == key || "".equals(key)) {
            return "";
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getString(key, "");
    }

    public static String getStringValue(String key, String defaultValue) {
        if (null == key || "".equals(key)) {
            return defaultValue;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getString(key, defaultValue);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void setCounterValue(String key, int value) {
        if (null == key || "".equals(key)) {
            return;
        }
        if (SettingFlags.getCounter(key) == value) {
            return;
        }
        SettingFlags.ensureInit();
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putInt(key, value);
        SettingFlags.applySharedPreference(editor);
        editor = null;
    }

    public static int getCounter(String key) {
        if (null == key || "".equals(key)) {
            return -1;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getInt(key, -1);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void resetCounter(String key) {
        if (null == key || 0 == key.length()) {
            return;
        }
        SettingFlags.ensureInit();
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putInt(key, 0);
        SettingFlags.applySharedPreference(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void resetCounter(String[] keys) {
        if (null == keys || 0 == keys.length) {
            return;
        }
        SettingFlags.ensureInit();
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        boolean hashChange = false;
        for (String key : keys) {
            if (null == key || "".equals(key)) continue;
            editor.putInt(key, 0);
            hashChange = true;
        }
        if (hashChange) {
            SettingFlags.applySharedPreference(editor);
        }
        editor = null;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void resetCounter(Map<String, Integer> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        SettingFlags.ensureInit();
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        boolean hashChange = false;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            Integer val = entry.getValue();
            if (null == key || "".equals(key)) continue;
            editor.putInt(key, val == null ? 0 : FP.orInt(val));
            hashChange = true;
        }
        if (hashChange) {
            SettingFlags.applySharedPreference(editor);
        }
        editor = null;
    }

    public static Map<String, ?> getCopyAll() {
        if (!SettingFlags.hasInited()) {
            return null;
        }
        SettingFlags.ensureInit();
        return sSharedPreferences.getAll();
    }

    private static void applySharedPreference(SharedPreferences.Editor editor) {
        if (editor == null) {
            return;
        }
        editor.apply();
    }

    static {
        whiteList = new ArrayList();
        whiteList.add("f809867cfc1983b3a1c87a84e66ed953");
        whiteList.add("lastf809867cfc1983b3a1c87a84e66ed953");
        whiteList.add("d30d8488bd6d8411f7f55cda6f24cb52");
        whiteList.add("key_dp_report");
        whiteList.add("key_deep_link");
    }
}

