/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowManager;
import androidx.annotation.Size;
import com.yy.base.bridge.IStatusBarBridge;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.SystemUtils;
import java.lang.reflect.Method;
import java.util.List;

public final class ScreenUtils {
    public static final int DENSITY_DEFAULT = 160;
    public static final int SCREEN_SIZE_Y_LARGE = 640;
    public static final int SCREEN_SIZE_LARGE = 0;
    public static final int SCREEN_SIZE_SMALL = 1;
    private static final int SYSTEM_UI_FLAG_HIDE_NAVIGATION = 2;
    private static ScreenUtils mInstance = null;
    private DisplayMetrics mDM;
    private float mDensity = 0.0f;
    private int mWidthPixels = 0;
    private int mHeightPixels = 0;
    private Point mScreenRealSize = new Point();
    IStatusBarBridge mIStatusBarBridge;
    public static final int Rotate_LandScape = 0;
    public static final int Rotate_ReversePortrait = 1;
    public static final int Rotate_ReverseLandScape = 2;
    public static final int Rotate_Portrait = 3;

    private ScreenUtils() {
    }

    public static boolean lockScreen(Activity activity, int lockRotation, boolean islock) {
        try {
            if (!islock) {
                activity.setRequestedOrientation(-1);
            } else {
                switch (lockRotation) {
                    case 0: {
                        activity.setRequestedOrientation(0);
                        break;
                    }
                    case 1: {
                        activity.setRequestedOrientation(9);
                        break;
                    }
                    case 2: {
                        activity.setRequestedOrientation(8);
                        break;
                    }
                    case 3: {
                        activity.setRequestedOrientation(1);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            MLog.error("lockScreen", e);
            return false;
        }
        return true;
    }

    public static int getScreenOrientation() {
        Configuration config = RuntimeContext.sApplicationContext.getResources().getConfiguration();
        return config.orientation;
    }

    public static int getTransformScreenOrientation(Activity context) {
        int orientation = context.getRequestedOrientation();
        switch (orientation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 3;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 1;
            }
        }
        return orientation;
    }

    public static ScreenUtils getInstance() {
        if (mInstance == null) {
            mInstance = new ScreenUtils();
            mInstance.init(RuntimeContext.sApplicationContext);
        }
        return mInstance;
    }

    public static boolean hideNavigationBar(View view) {
        try {
            Method setSystemUiVisibilityMethod = View.class.getMethod("setSystemUiVisibility", Integer.TYPE);
            setSystemUiVisibilityMethod.invoke((Object)view, 2);
            return true;
        }
        catch (Exception e) {
            MLog.processSilentException(e);
            return false;
        }
    }

    public void init(Context activity) {
        if (activity == null) {
            return;
        }
        this.mDM = activity.getResources().getDisplayMetrics();
        this.mDensity = this.mDM.density;
        this.mWidthPixels = Math.min(this.mDM.widthPixels, this.mDM.heightPixels);
        this.mHeightPixels = Math.max(this.mDM.widthPixels, this.mDM.heightPixels);
        Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
        display.getRealSize(this.mScreenRealSize);
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mDM;
    }

    public int getScreenRealHeight() {
        return this.mScreenRealSize.y;
    }

    public int getScreenRealWidth() {
        return this.mScreenRealSize.x;
    }

    public float getDensity() {
        return this.mDensity;
    }

    public int getWidthPixels() {
        return this.mWidthPixels;
    }

    public int getHeightPixels() {
        return this.mHeightPixels;
    }

    public int dip2px(int dip) {
        return (int)(0.5f + this.mDensity * (float)dip);
    }

    public int px2dip(int px) {
        return (int)(0.5f + (float)px / this.mDensity);
    }

    public int dip2px(float dip) {
        return (int)(0.5f + this.mDensity * dip);
    }

    public int px2dip(float px) {
        return (int)(0.5f + px / this.mDensity);
    }

    public int percentHeight(float percent) {
        return (int)(percent * (float)this.getHeightPixels());
    }

    public int percentWidth(float percent) {
        return (int)(percent * (float)this.getWidthPixels());
    }

    public boolean hasNotch(Activity context) {
        if (Build.VERSION.SDK_INT >= 28 && this.haveNotchAbove28(context)) {
            return true;
        }
        if (this.mIStatusBarBridge != null && this.mIStatusBarBridge.isNotchEnable()) {
            return this.hasNotchInHuawei((Context)context) || this.hasNotchInOppo((Context)context) || this.hasNotchInVivo((Context)context);
        }
        return false;
    }

    @TargetApi(value=28)
    public boolean haveNotchAbove28(Activity context) {
        DisplayCutout displayCutout;
        if (context == null || context.getWindow() == null || context.getWindow().getDecorView() == null) {
            return false;
        }
        View decorView = context.getWindow().getDecorView();
        WindowInsets windowInsets = decorView.getRootWindowInsets();
        if (windowInsets != null && (displayCutout = windowInsets.getDisplayCutout()) != null) {
            List rects = displayCutout.getBoundingRects();
            return rects != null && rects.size() != 0;
        }
        return false;
    }

    public boolean hasNotchInOppo(Context context) {
        try {
            if (!HardwareUtils.isOppo()) {
                return false;
            }
            return context.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
        }
        catch (Exception e) {
            MLog.error("hasNotchInOppo", e);
            return false;
        }
    }

    public boolean hasNotchInVivo(Context context) {
        boolean hasNotch = false;
        try {
            if (!HardwareUtils.isVivo()) {
                return false;
            }
            ClassLoader cl = context.getClassLoader();
            Class<?> mFtFeature = cl.loadClass("android.util.FtFeature");
            Method get = mFtFeature.getMethod("isFeatureSupport", Integer.TYPE);
            hasNotch = (Boolean)get.invoke(mFtFeature, 32);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasNotch;
    }

    public boolean hasNotchInHuawei(Context context) {
        boolean hasNotch = false;
        try {
            if (!HardwareUtils.isHuaWei()) {
                return false;
            }
            ClassLoader cl = context.getClassLoader();
            Class<?> mHwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = mHwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            hasNotch = (Boolean)get.invoke(mHwNotchSizeUtil, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasNotch;
    }

    public void paraseLocationInWindow(int[] location) {
        if (location != null && location.length == 2) {
            location[1] = location[1] == 0 ? 0 : location[1] - SystemUtils.getStatusBarHeight(RuntimeContext.sApplicationContext);
        }
    }

    public int getScreeSizeType() {
        int screenWidth = ResolutionUtils.getScreenWidth(RuntimeContext.sApplicationContext);
        if (screenWidth > 640) {
            return 0;
        }
        return 1;
    }

    public void getViewPoint(View view, boolean isAbsolute, @Size(value=2L) int[] outLocation) {
        if (outLocation == null || outLocation.length < 2) {
            throw new IllegalArgumentException("outLocation must be an array of two integers");
        }
        outLocation[0] = 0;
        outLocation[1] = 0;
        if (view != null) {
            view.getLocationInWindow(outLocation);
            int width = view.getWidth();
            int hight = view.getHeight();
            ScreenUtils.getInstance().paraseLocationInWindow(outLocation);
            outLocation[0] = LanguageUtils.isRtl() && !isAbsolute ? -(ScreenUtils.getInstance().getWidthPixels() - outLocation[0]) + width / 2 : outLocation[0] + width / 2;
            outLocation[1] = outLocation[1] + hight / 2;
        }
    }

    public static String timeParse(long duration) {
        String time = "";
        long minute = duration / 60000L;
        long seconds = duration % 60000L;
        long second = Math.round((float)seconds / 1000.0f);
        if (minute < 10L) {
            time = time + "0";
        }
        time = time + minute + ":";
        if (second < 10L) {
            time = time + "0";
        }
        time = time + second;
        return time;
    }

    public IStatusBarBridge getIStatusBarBridge() {
        return this.mIStatusBarBridge;
    }

    public void setIStatusBarBridge(IStatusBarBridge IStatusBarBridge2) {
        this.mIStatusBarBridge = IStatusBarBridge2;
    }
}

