/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.animation.AnimatorInflater;
import android.animation.StateListAnimator;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.ColorRes;
import androidx.annotation.RequiresApi;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.startup.ActivityStackManager;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.lang.ref.WeakReference;

public class ResourceUtils {
    private static final String TAG = "ResourceUtils";
    private static WeakReference<Context> sContextWeakReference;
    private static Context sNewContext;
    private static IAAB mAAB;
    private static IActivityTask mActivityTask;

    private static Resources getResources() {
        return ResourceUtils.getContext().getResources();
    }

    public static void setNewContext(Context newContext) {
        sNewContext = newContext;
    }

    private static Resources getNewResources() throws PackageManager.NameNotFoundException {
        if (sNewContext == null) {
            sNewContext = RuntimeContext.sApplicationContext.createPackageContext(RuntimeContext.sApplicationContext.getPackageName(), 0);
        }
        MLog.debug(TAG, "getNewResources from createPackageContext", new Object[0]);
        return sNewContext.getResources();
    }

    private static Resources getActivityResources() {
        Context activity;
        if (mActivityTask != null && (activity = mActivityTask.getCurActivity()) != null) {
            MLog.debug(TAG, "getActivityResources from currentActivity", new Object[0]);
            mAAB.splitCompatInstallActivit(activity);
            mAAB.splitCompatInstall(activity);
            return activity.getResources();
        }
        MLog.debug(TAG, "getActivityResources from mainActivity", new Object[0]);
        if (ActivityStackManager.getInstance().getMainActivity() != null) {
            mAAB.splitCompatInstallActivit((Context)ActivityStackManager.getInstance().getMainActivity());
            mAAB.splitCompatInstall((Context)ActivityStackManager.getInstance().getMainActivity());
            return ActivityStackManager.getInstance().getMainActivity().getResources();
        }
        return ResourceUtils.getResources();
    }

    public static void setContext(Context context) {
        if (context == null) {
            return;
        }
        sContextWeakReference = new WeakReference<Context>(context);
    }

    public static Context getContext() {
        Context context = null;
        if (sContextWeakReference != null && sContextWeakReference.get() != null) {
            context = (Context)sContextWeakReference.get();
        }
        return context != null ? context : RuntimeContext.sApplicationContext;
    }

    public static int getColor(@ColorRes int colorId) {
        try {
            return ResourceUtils.getResources().getColor(colorId);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getColor(colorId);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getColor(colorId);
            }
        }
    }

    public static ColorStateList getColorStateList(@ColorRes int colorId) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                return ResourceUtils.getResources().getColorStateList(colorId, ResourceUtils.getContext().getTheme());
            }
            return ResourceUtils.getResources().getColorStateList(colorId);
        }
        catch (Resources.NotFoundException e) {
            try {
                if (Build.VERSION.SDK_INT >= 23) {
                    return ResourceUtils.getNewResources().getColorStateList(colorId, ResourceUtils.getContext().getTheme());
                }
                return ResourceUtils.getNewResources().getColorStateList(colorId);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                if (Build.VERSION.SDK_INT >= 23) {
                    return ResourceUtils.getActivityResources().getColorStateList(colorId, ResourceUtils.getContext().getTheme());
                }
                return ResourceUtils.getActivityResources().getColorStateList(colorId);
            }
        }
    }

    public static int getDimen(int dimen) {
        try {
            return ResourceUtils.getResources().getDimensionPixelSize(dimen);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getDimensionPixelSize(dimen);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getDimensionPixelSize(dimen);
            }
        }
    }

    public static void setImageRes(int resId, ImageView imageView) {
        if (imageView != null) {
            imageView.setImageResource(resId);
        }
    }

    public static void setBackground(int resId, View view) {
        if (view != null) {
            view.setBackgroundResource(resId);
        }
    }

    public static String getString(int stringId) {
        try {
            return ResourceUtils.getResources().getString(stringId);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getString(stringId);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getString(stringId);
            }
        }
    }

    public static String getString(int stringId, Object ... formatArgs) {
        try {
            return ResourceUtils.getResources().getString(stringId, formatArgs);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getString(stringId, formatArgs);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getString(stringId, formatArgs);
            }
        }
        catch (Throwable e) {
            if (RuntimeContext.isInGray()) {
                throw new RuntimeException(e);
            }
            MLog.error(TAG, e);
            return "";
        }
    }

    public static String getQuantityString(int stringId, int count) {
        try {
            return ResourceUtils.getResources().getQuantityString(stringId, count);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getQuantityString(stringId, count);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getQuantityString(stringId, count);
            }
        }
    }

    public static int[] getIntArray(int intArrayId) {
        try {
            return ResourceUtils.getResources().getIntArray(intArrayId);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getIntArray(intArrayId);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getIntArray(intArrayId);
            }
        }
    }

    public static String[] getStringArray(int intArrayId) {
        try {
            return ResourceUtils.getResources().getStringArray(intArrayId);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getStringArray(intArrayId);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getStringArray(intArrayId);
            }
        }
    }

    public static Drawable getDrawable(int drawableId) {
        try {
            return ResourceUtils.getResources().getDrawable(drawableId);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getDrawable(drawableId);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getDrawable(drawableId);
            }
        }
    }

    public static int[] getDrawableSize(int aResID) {
        Drawable d = ResourceUtils.getDrawable(aResID);
        int[] ret = null == d ? new int[]{0, 0} : new int[]{d.getIntrinsicWidth(), d.getIntrinsicHeight()};
        return ret;
    }

    @RequiresApi(api=21)
    public static StateListAnimator getStateListAnimator(int animId) {
        return AnimatorInflater.loadStateListAnimator((Context)ResourceUtils.getContext(), (int)animId);
    }

    public static void asynLoadDrawable(final int resId, final View view) {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final Drawable drawable = ResourceUtils.getDrawable(resId);
                final WeakReference<View> weakReference = new WeakReference<View>(view);
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        View v = (View)weakReference.get();
                        if (v != null) {
                            if (v instanceof ImageView) {
                                ((ImageView)v).setImageDrawable(drawable);
                            } else {
                                v.setBackgroundDrawable(drawable);
                            }
                        }
                    }
                });
            }
        });
    }

    public static int getIdentifier(String name, String defType, String defPackage) {
        try {
            return ResourceUtils.getResources().getIdentifier(name, defType, defPackage);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getIdentifier(name, defType, defPackage);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getIdentifier(name, defType, defPackage);
            }
        }
    }

    public static String getName(int id2) {
        try {
            return ResourceUtils.getResources().getResourceName(id2);
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getResourceName(id2);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getResourceName(id2);
            }
        }
    }

    public static <T> int getIdentifier(String name, String defType, Class<T> tClass) {
        try {
            return ResourceUtils.getResources().getIdentifier(name, defType, tClass.getPackage().getName());
        }
        catch (Resources.NotFoundException e) {
            try {
                return ResourceUtils.getNewResources().getIdentifier(name, defType, tClass.getPackage().getName());
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException ex) {
                return ResourceUtils.getActivityResources().getIdentifier(name, defType, tClass.getPackage().getName());
            }
        }
    }

    public static void setAAB(IAAB mAAB) {
        ResourceUtils.mAAB = mAAB;
    }

    public static void setActivityTask(IActivityTask mActivityTask) {
        ResourceUtils.mActivityTask = mActivityTask;
    }

    public static interface IActivityTask {
        public Context getCurActivity();
    }

    public static interface IAAB {
        public void splitCompatInstallActivit(Context var1);

        public void splitCompatInstall(Context var1);
    }
}

