/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import java.util.HashMap;
import java.util.Map;

public class PackageUtils {
    private static final String TAG = "PackageUtils";
    public static final String FACEBOOK_PACKAGE_NAME = "com.facebook.katana";
    public static final String FACEBOOK_LITE_PACKAGE_NAME = "com.facebook.lite";
    public static final String GOOGLE_GMS = "com.google.android.gms";
    public static final String GOOGLE_PLAY = "com.android.vending";
    private static final Map<String, String> mVersionCache = new HashMap<String, String>();
    private static String sPackageName = "";
    private static String sAppName = "";
    private static String sAppId = "";

    public static boolean isAppInstalled(Context context, String packageName) {
        return SystemUtils.isAppInstalled(packageName);
    }

    public static String getAppName(Context context) {
        if (StringUtils.isNotEmpty(sAppName)) {
            return sAppName;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            sAppName = ResourceUtils.getString(labelRes);
            return sAppName;
        }
        catch (Exception e) {
            MLog.error(TAG, e);
            return "Hago";
        }
    }

    public static String getApplicationId(Context context) {
        if (StringUtils.isNotEmpty(sAppId)) {
            return sAppId;
        }
        try {
            sAppId = context.getApplicationInfo().packageName;
            return sAppId;
        }
        catch (Exception e) {
            MLog.error(TAG, e);
            return "";
        }
    }

    public static boolean isInstallOnSDCard(String packageName) {
        PackageManager pm = RuntimeContext.sApplicationContext.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 0);
            if ((appInfo.flags & 0x40000) == 262144) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            MLog.error(TAG, e);
        }
        return false;
    }

    public static void getPackageVersion(final String packageName, final PackageVersionCallback callback) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            if (callback != null) {
                callback.onGetVersion("");
            }
            return;
        }
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String versionName = "";
                try {
                    PackageInfo info = RuntimeContext.sApplicationContext.getPackageManager().getPackageInfo(packageName, 0);
                    versionName = info.versionName;
                    mVersionCache.put(packageName, versionName);
                }
                catch (PackageManager.NameNotFoundException e) {
                    MLog.error((Object)PackageUtils.TAG, "[getPackageVersion]", e, new Object[0]);
                }
                if (callback != null) {
                    callback.onGetVersion(versionName);
                }
            }
        });
    }

    public static String getPackageVersion(String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return "";
        }
        if (!mVersionCache.containsKey(packageName)) {
            PackageUtils.getPackageVersion(packageName, null);
            return "";
        }
        return mVersionCache.get(packageName);
    }

    public static void goAppSystemSetting(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)RuntimeContext.sPackageName, null);
        intent.setData(uri);
        context.startActivity(intent);
    }

    public static interface PackageVersionCallback {
        public void onGetVersion(String var1);
    }
}

