/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.annotation.SuppressLint;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.core.app.NotificationManagerCompat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SystemServiceUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NotificationsUtils {
    public static final int MODE_FORBID = 0;
    public static final int MODE_ALLOWED = 1;
    public static final int MODE_NO_PERMISSION = 2;
    private static final String CHECK_OP_NO_THROW = "checkOpNoThrow";
    private static final String OP_POST_NOTIFICATION = "OP_POST_NOTIFICATION";
    private static volatile boolean sHasTest = false;
    private static volatile boolean sSsNotificationEnabled = false;

    @SuppressLint(value={"NewApi"})
    public static synchronized boolean isNotificationEnabled(Context context) {
        if (Build.VERSION.SDK_INT < 19) {
            return true;
        }
        if (sHasTest) {
            return sSsNotificationEnabled;
        }
        sHasTest = true;
        MLog.info("NotificationsUtils", "start!", new Object[0]);
        if (Build.VERSION.SDK_INT >= 24) {
            NotificationManagerCompat manager = NotificationManagerCompat.from((Context)context);
            sSsNotificationEnabled = manager.areNotificationsEnabled();
            MLog.info("NotificationsUtils", "end!", new Object[0]);
            return sSsNotificationEnabled;
        }
        try {
            ApplicationInfo appInfo = context.getApplicationInfo();
            String pkg = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid;
            Class<?> appOpsClass = null;
            appOpsClass = Class.forName(AppOpsManager.class.getName());
            Method checkOpNoThrowMethod = appOpsClass.getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE, String.class);
            Field opPostNotificationValue = appOpsClass.getDeclaredField(OP_POST_NOTIFICATION);
            int value = (Integer)opPostNotificationValue.get(Integer.class);
            MLog.info("NotificationsUtils", "end!", new Object[0]);
            sSsNotificationEnabled = (Integer)checkOpNoThrowMethod.invoke((Object)SystemServiceUtils.getAppOpsManager(context), value, uid, pkg) == 0;
            return sSsNotificationEnabled;
        }
        catch (Exception e) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.error("NotificationsUtils", e);
            }
            MLog.info("NotificationsUtils", "end!", new Object[0]);
            sSsNotificationEnabled = false;
            return sSsNotificationEnabled;
        }
    }

    public static synchronized void resetHasTestFlag() {
        sHasTest = false;
    }

    public static int getNotificationStatus(Context context) {
        try {
            ApplicationInfo appInfo = context.getApplicationInfo();
            String pkg = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid;
            Class<?> appOpsClass = null;
            appOpsClass = Class.forName(AppOpsManager.class.getName());
            Method checkOpNoThrowMethod = appOpsClass.getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE, String.class);
            Field opPostNotificationValue = appOpsClass.getDeclaredField(OP_POST_NOTIFICATION);
            int value = (Integer)opPostNotificationValue.get(Integer.class);
            if ((Integer)checkOpNoThrowMethod.invoke((Object)SystemServiceUtils.getAppOpsManager(context), value, uid, pkg) == 0) {
                return 1;
            }
            return 0;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)"NotificationsUtils", (String)"printStackTrace", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)"NotificationsUtils", (String)"printStackTrace", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            Log.e((String)"NotificationsUtils", (String)"printStackTrace", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)"NotificationsUtils", (String)"printStackTrace", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)"NotificationsUtils", (String)"printStackTrace", (Throwable)e);
        }
        catch (Throwable e) {
            Log.e((String)"NotificationsUtils", (String)"printStackTrace", (Throwable)e);
        }
        return 2;
    }

    public static void openNotificationSetting(Context context) {
        Intent appIntent = context.getPackageManager().getLaunchIntentForPackage("com.iqoo.secure");
        if (appIntent != null) {
            context.startActivity(appIntent);
            return;
        }
        appIntent = context.getPackageManager().getLaunchIntentForPackage("com.oppo.safe");
        if (appIntent != null) {
            context.startActivity(appIntent);
            return;
        }
        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT >= 26) {
            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        } else if (Build.VERSION.SDK_INT >= 21) {
            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
            intent.putExtra("app_package", context.getPackageName());
            intent.putExtra("app_uid", context.getApplicationInfo().uid);
        } else {
            intent.addFlags(0x10000000);
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        }
        context.startActivity(intent);
    }
}

