/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemServiceUtils;

public class ImeUtil {
    public static void hideIME(Activity activity) {
        View view = activity.getCurrentFocus();
        if (null != view) {
            ImeUtil.hideIME((Context)activity, view);
        }
    }

    public static void hideIME(Context context, View v) {
        if (context == null || v == null) {
            return;
        }
        SystemServiceUtils.getInputMethodManager(context).hideSoftInputFromWindow(v.getWindowToken(), 0);
    }

    public static void showIME(Activity activity, View view) {
        if (null == view && null == (view = activity.getCurrentFocus())) {
            return;
        }
        SystemServiceUtils.getInputMethodManager((Context)activity).showSoftInput(view, 2);
    }

    public static void showIME(Context context, View view) {
        if (null == view) {
            return;
        }
        SystemServiceUtils.getInputMethodManager(context).showSoftInput(view, 0);
    }

    public static void showIME(Activity activity, View view, int flag) {
        if (null == view && null == (view = activity.getCurrentFocus())) {
            return;
        }
        SystemServiceUtils.getInputMethodManager((Context)activity).showSoftInput(view, flag);
    }

    public static void showIMEDelay(final Activity activity, final View view, long time) {
        YYTaskExecutor.postToMainThread(new Runnable(){

            @Override
            public void run() {
                ImeUtil.showIME(activity, view);
            }
        }, time);
    }

    public static void showIMEDelay(Activity activity, View view) {
        ImeUtil.showIMEDelay(activity, view, 140L);
    }

    public static void showIMEDelay(final Context context, final View view, long time) {
        YYTaskExecutor.postToMainThread(new Runnable(){

            @Override
            public void run() {
                ImeUtil.showIME(context, view);
            }
        }, time);
    }

    public static void showIMEDelay(Context context, View view) {
        ImeUtil.showIMEDelay(context, view, 140L);
    }
}

