/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.View;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.IOUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public class HardwareUtils {
    public static final int LAYER_TYPE_NONE = 0;
    public static final int LAYER_TYPE_SOFTWARE = 1;
    public static final int LAYER_TYPE_HARDWARE = 2;
    private static final String TAG = "HardwareUtils";
    private static boolean sHasInitCpuCoreCount = false;
    private static int sCpuCoreCount = 1;
    private static boolean sHasInitCpuArch = false;
    private static String sCpuArch = "";
    private static volatile boolean sInitSimulator = false;
    private static boolean sIsSimulator = false;
    private static long sMaxCpuFreq = -1L;
    private static long sMinCpuFreq = -1L;
    private static String sPlatformName = null;

    public static int getCpuCoreCount() {
        if (sHasInitCpuCoreCount) {
            return sCpuCoreCount;
        }
        try {
            if (SettingFlags.hasInited()) {
                sCpuCoreCount = SettingFlags.getIntValue("CpuCoreCount", -1);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)"HardwareUtil", "Catch on getCpuCoreCount", e, new Object[0]);
        }
        if (sCpuCoreCount > 0) {
            sHasInitCpuCoreCount = true;
            return sCpuCoreCount;
        }
        try {
            sCpuCoreCount = Runtime.getRuntime().availableProcessors();
            if (sCpuCoreCount < 1) {
                sCpuCoreCount = 1;
            }
            if (SettingFlags.hasInited()) {
                SettingFlags.setIntValue("CpuCoreCount", sCpuCoreCount);
            }
        }
        catch (Throwable e) {
            MLog.error((Object)"HardwareUtil", "Empty Catch on getCpuCoreCount", e, new Object[0]);
        }
        sHasInitCpuCoreCount = true;
        return sCpuCoreCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCpuArch() {
        if (sHasInitCpuArch) {
            return sCpuArch;
        }
        try {
            if (SettingFlags.hasInited()) {
                sCpuArch = SettingFlags.getStringValue("CpuArch", "");
            }
            if (StringUtils.isNotEmpty(sCpuArch)) {
                return sCpuArch;
            }
        }
        catch (Throwable e) {
            MLog.error((Object)"HardwareUtil", "Catch on getCpuArch", e, new Object[0]);
        }
        int iceCreamSandwich = 14;
        int jellyBean = 16;
        if (Build.VERSION.SDK_INT < 14 || Build.VERSION.SDK_INT > 16) {
            BufferedReader input;
            block19: {
                input = null;
                try {
                    Process process = Runtime.getRuntime().exec("getprop ro.product.cpu.abi");
                    input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String strAbi = input.readLine();
                    if (strAbi != null && strAbi.contains("x86")) {
                        sCpuArch = "x86";
                        break block19;
                    }
                    if (strAbi == null || !strAbi.contains("armeabi-v7a")) break block19;
                    sCpuArch = "armv7";
                }
                catch (Throwable e) {
                    try {
                        MLog.error(TAG, e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.safeClose(input);
                    }
                }
            }
            IOUtils.safeClose(input);
        }
        if (TextUtils.isEmpty((CharSequence)sCpuArch)) {
            try {
                sCpuArch = System.getProperty("os.arch").toLowerCase();
                if (sCpuArch != null && sCpuArch.contains("i686")) {
                    sCpuArch = "x86";
                }
            }
            catch (Throwable e) {
                MLog.error(TAG, e);
            }
        }
        if (TextUtils.isEmpty((CharSequence)sCpuArch)) {
            sCpuArch = Build.VERSION.SDK_INT < 21 ? Build.CPU_ABI : Build.SUPPORTED_ABIS[0];
        }
        if (sCpuArch == null) {
            sCpuArch = "";
        }
        if (StringUtils.isNotEmpty(sCpuArch)) {
            SettingFlags.setStringValue("CpuArch", sCpuArch);
        }
        sHasInitCpuArch = true;
        MLog.error((Object)TAG, "getCpuArch: " + sCpuArch, new Object[0]);
        return sCpuArch;
    }

    public static String getOperator(Context c) {
        return NetworkUtils.getOperator(c);
    }

    public static String getMac(Context c) {
        return NetworkUtils.getMac(c);
    }

    public static void setLayerType(View v, int type) {
        try {
            Integer realType = -1;
            switch (type) {
                case 0: {
                    realType = 0;
                    break;
                }
                case 1: {
                    realType = 1;
                    break;
                }
                case 2: {
                    realType = 2;
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported layer type");
                }
            }
            if (-1 == realType) {
                return;
            }
            v.setLayerType(realType.intValue(), null);
        }
        catch (Exception ex) {
            MLog.error(TAG, ex);
        }
    }

    public static void buildLayer(View v) {
        try {
            Class<View> cls = View.class;
            Method method = cls.getMethod("buildLayer", new Class[0]);
            method.invoke((Object)v, new Object[0]);
        }
        catch (Exception ex) {
            MLog.error(TAG, ex);
        }
    }

    public static boolean isMi2Phone() {
        String model = Build.MODEL;
        if (model != null && model.length() > 0) {
            model = model.toLowerCase();
            return model.startsWith("mi 2");
        }
        return false;
    }

    public static boolean isOppoA1601() {
        String brand = Build.BRAND;
        String model = Build.MODEL;
        if (TextUtils.isEmpty((CharSequence)brand) || TextUtils.isEmpty((CharSequence)model)) {
            return false;
        }
        return "OPPO".equalsIgnoreCase(brand) && "A1601".equalsIgnoreCase(model);
    }

    public static boolean isNeteaseMuMu() {
        String model = Build.MODEL;
        if (TextUtils.isEmpty((CharSequence)model)) {
            return false;
        }
        return "MuMu".equalsIgnoreCase(model);
    }

    public static boolean isOppoR9sk() {
        String model = Build.MODEL;
        if (TextUtils.isEmpty((CharSequence)model)) {
            return false;
        }
        return "OPPO R9sk".equalsIgnoreCase(model) || "R9sk".equalsIgnoreCase(model);
    }

    public static boolean isOppo() {
        String model = Build.MODEL;
        if (TextUtils.isEmpty((CharSequence)model)) {
            return false;
        }
        return model.toLowerCase().contains("oppo");
    }

    public static boolean isVivo() {
        String model = Build.MODEL;
        if (TextUtils.isEmpty((CharSequence)model)) {
            return false;
        }
        return model.toLowerCase().contains("vivo");
    }

    public static boolean isHuaWei() {
        String model = Build.MODEL;
        if (TextUtils.isEmpty((CharSequence)model)) {
            return false;
        }
        return model.toLowerCase().contains("huawei") || model.toLowerCase().contains("hw");
    }

    public static boolean isSimulator() {
        if (sInitSimulator) {
            return sIsSimulator;
        }
        if (SettingFlags.containKey("issimulator")) {
            sIsSimulator = SettingFlags.getBoolean("issimulator", false);
            sInitSimulator = true;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean result;
                    String url = "tel:+8615012723333";
                    Intent intent = new Intent();
                    intent.setData(Uri.parse((String)url));
                    intent.setAction("android.intent.action.DIAL");
                    boolean canCallPhone = intent.resolveActivity(RuntimeContext.sApplicationContext.getPackageManager()) != null;
                    boolean bl = result = Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.toLowerCase().contains("vbox") || Build.FINGERPRINT.toLowerCase().contains("test-keys") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("MuMu") || Build.MODEL.contains("virtual") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT) || ((TelephonyManager)RuntimeContext.sApplicationContext.getSystemService("phone")).getNetworkOperatorName().toLowerCase().equals("android") || !canCallPhone;
                    if (sIsSimulator != result || !sInitSimulator) {
                        SettingFlags.setBoolean("issimulator", result);
                    }
                    sIsSimulator = result;
                    sInitSimulator = true;
                    MLog.info(HardwareUtils.TAG, "isSimulator:%s,model:%s", sIsSimulator ? "1" : "0", Build.MODEL);
                }
                catch (Throwable e) {
                    MLog.error(HardwareUtils.TAG, e);
                }
            }
        };
        if (sInitSimulator) {
            YYTaskExecutor.getDefaultIdleExecutor().execute(command, 20000L);
        } else {
            command.run();
        }
        return sIsSimulator;
    }

    public static String getSimpleFormatCpuArch() {
        String cpuArch = HardwareUtils.getCpuArch();
        if (cpuArch.contains("x86")) {
            if (cpuArch.contains("64")) {
                return "x86_64";
            }
            return "x86";
        }
        if (cpuArch.contains("arm")) {
            if (cpuArch.contains("v8")) {
                return "arm_64";
            }
            return "arm_32";
        }
        return cpuArch;
    }

    public static long getMaxCpuFreq() {
        long maxCpuFreq = SettingFlags.getLongValue("key_hardware_cpu_max_freq", 0L);
        if (maxCpuFreq > 0L) {
            return maxCpuFreq;
        }
        if (sMaxCpuFreq != -1L) {
            return sMaxCpuFreq;
        }
        try {
            int cpuCount = HardwareUtils.getCpuCoreCount();
            for (int i = 0; i < cpuCount; ++i) {
                long temp;
                String result = "";
                String fileName = StringUtils.format("/sys/devices/system/cpu/cpu%d/cpufreq/cpuinfo_max_freq", i);
                String[] args = new String[]{"/system/bin/cat", fileName};
                ProcessBuilder cmd = new ProcessBuilder(args);
                Process process = cmd.start();
                InputStream in = process.getInputStream();
                byte[] re = new byte[24];
                while (in.read(re) != -1) {
                    result = result + new String(re);
                }
                in.close();
                maxCpuFreq = maxCpuFreq != 0L ? ((temp = StringUtils.safeParseLong(result.trim())) > maxCpuFreq ? temp : maxCpuFreq) : StringUtils.safeParseLong(result.trim());
            }
            SettingFlags.setLongValue("key_hardware_cpu_max_freq", maxCpuFreq);
            return maxCpuFreq;
        }
        catch (IOException ex) {
            sMaxCpuFreq = 0L;
            ex.printStackTrace();
            return 0L;
        }
        catch (NumberFormatException ex) {
            sMaxCpuFreq = 0L;
            ex.printStackTrace();
            return 0L;
        }
    }

    public static long getMinCpuFreq() {
        long minCpuFreq = SettingFlags.getLongValue("key_hardware_cpu_min_freq", 0L);
        if (minCpuFreq > 0L) {
            return minCpuFreq;
        }
        if (sMinCpuFreq != -1L) {
            return sMinCpuFreq;
        }
        try {
            int cpuCount = HardwareUtils.getCpuCoreCount();
            for (int i = 0; i < cpuCount; ++i) {
                long temp;
                String result = "";
                String fileName = StringUtils.format("/sys/devices/system/cpu/cpu%d/cpufreq/cpuinfo_max_freq", i);
                String[] args = new String[]{"/system/bin/cat", fileName};
                ProcessBuilder cmd = new ProcessBuilder(args);
                Process process = cmd.start();
                InputStream in = process.getInputStream();
                byte[] re = new byte[24];
                while (in.read(re) != -1) {
                    result = result + new String(re);
                }
                in.close();
                minCpuFreq = minCpuFreq != 0L ? ((temp = StringUtils.safeParseLong(result.trim())) < minCpuFreq ? temp : minCpuFreq) : StringUtils.safeParseLong(result.trim());
            }
            SettingFlags.setLongValue("key_hardware_cpu_min_freq", minCpuFreq);
            return minCpuFreq;
        }
        catch (IOException ex) {
            sMinCpuFreq = 0L;
            ex.printStackTrace();
            return 0L;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            sMinCpuFreq = 0L;
            return 0L;
        }
        catch (Exception ex) {
            sMinCpuFreq = 0L;
            ex.printStackTrace();
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCpuRealName() {
        BufferedReader br;
        FileReader fr;
        block22: {
            String string2;
            block21: {
                String string3;
                block20: {
                    String string4;
                    block19: {
                        fr = null;
                        br = null;
                        try {
                            String[] array;
                            String line;
                            String cpuName = SettingFlags.getStringValue("key_hardware_cpu_name", null);
                            if (!TextUtils.isEmpty((CharSequence)cpuName) && HardwareUtils.matchCpuName(cpuName)) {
                                String string5 = cpuName;
                                return string5;
                            }
                            if (sPlatformName != null) {
                                String string6 = sPlatformName;
                                return string6;
                            }
                            String buildHardWare = Build.HARDWARE;
                            if (HardwareUtils.matchCpuName(buildHardWare)) {
                                SettingFlags.setStringValue("key_hardware_cpu_name", buildHardWare.toUpperCase());
                                string4 = buildHardWare.toUpperCase();
                                IOUtils.safeClose(fr);
                                break block19;
                            }
                            String cpuinfoHardWare = "";
                            fr = new FileReader("/proc/cpuinfo");
                            br = new BufferedReader(fr);
                            String text = "";
                            while ((line = br.readLine()) != null) {
                                text = line;
                            }
                            if (!TextUtils.isEmpty((CharSequence)text) && (array = text.split("\\s+")).length > 0 && HardwareUtils.matchCpuName(cpuinfoHardWare = array[array.length - 1])) {
                                SettingFlags.setStringValue("key_hardware_cpu_name", cpuinfoHardWare.toUpperCase());
                                string3 = cpuinfoHardWare.toUpperCase();
                                IOUtils.safeClose(fr);
                                break block20;
                            }
                            Process process = Runtime.getRuntime().exec("getprop ro.board.platform");
                            BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            String platformName = input.readLine();
                            if (HardwareUtils.matchCpuName(platformName)) {
                                SettingFlags.setStringValue("key_hardware_cpu_name", platformName.toUpperCase());
                                string2 = platformName.toUpperCase();
                                IOUtils.safeClose(fr);
                                break block21;
                            }
                            sPlatformName = platformName;
                            if (platformName == null) {
                                sPlatformName = "";
                            }
                            MLog.error((Object)TAG, "buildHardWare:" + buildHardWare + " cpuinfoHardWare:" + cpuinfoHardWare + " platformName:" + platformName, new Object[0]);
                            IOUtils.safeClose(fr);
                            break block22;
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            return "";
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return "";
                        }
                    }
                    IOUtils.safeClose(br);
                    return string4;
                }
                IOUtils.safeClose(br);
                return string3;
            }
            IOUtils.safeClose(br);
            return string2;
        }
        IOUtils.safeClose(br);
        return "";
        finally {
            IOUtils.safeClose(fr);
            IOUtils.safeClose(br);
        }
    }

    private static boolean matchCpuName(String cpuName) {
        return !TextUtils.isEmpty((CharSequence)cpuName) && (cpuName.toUpperCase().startsWith("MSM") || cpuName.toUpperCase().startsWith("APQ") || cpuName.toUpperCase().startsWith("EXYNOS") || cpuName.toUpperCase().startsWith("MT") || cpuName.toUpperCase().startsWith("SDM") || cpuName.toUpperCase().startsWith("KIRIN") || cpuName.toUpperCase().startsWith("SI") || cpuName.toUpperCase().startsWith("SC"));
    }

    public static class ChinaOperator {
        public static final String CMCC = "CMCC";
        public static final String CTL = "CTL";
        public static final String UNICOM = "UNICOM";
        public static final String UNKNOWN = "Unknown";
    }

    public static interface TelephonyApi {
        public String getImei(Context var1);
    }
}

