/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import com.yy.base.R;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.xml.CommonUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    private static final String TAG = "DateUtils";
    public static final String FORMAT_ONE = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static long TEN_MINUTES = 600000L;
    public static long ONE_DAY_MILLIS = 86400000L;
    public static final String FORMAT_DATE_SPLIT_SPACE = "yyyy - MM - dd";
    public static final String FORMAT_DATE_SPLIT = "yyyy-MM-dd";
    public static final String FORMAT_DATE = "yyyy-MM";

    public static Date stringtoDate(String dateStr, String format) {
        Date d = null;
        SimpleDateFormat formater = DateUtils.getSimpleDateFormat(format);
        try {
            formater.setLenient(false);
            d = formater.parse(dateStr);
        }
        catch (Exception e) {
            d = new Date(-1L);
        }
        return d;
    }

    public static String dateToString(Date date, String format) {
        String result = "";
        SimpleDateFormat formater = DateUtils.getSimpleDateFormat(format);
        try {
            result = formater.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static long timeSub(String firstTime, String secTime) {
        if (firstTime == null || firstTime.equals("")) {
            return 0L;
        }
        if (secTime == null || secTime.equals("")) {
            return 0L;
        }
        long first = DateUtils.stringtoDate(firstTime, FORMAT_ONE).getTime();
        long second = DateUtils.stringtoDate(secTime, FORMAT_ONE).getTime();
        return (first - second) / 1000L;
    }

    public static String getNow() {
        Calendar today = Calendar.getInstance();
        return DateUtils.dateToString(today.getTime(), FORMAT_ONE);
    }

    public static String getToday() {
        Calendar today = Calendar.getInstance();
        return DateUtils.dateToString(today.getTime(), FORMAT_DATE_SPLIT);
    }

    public static String getTimeFromMillisecond(Long millisecond, SimpleDateFormat simpleDateFormat) {
        Date date = new Date(millisecond);
        String timeStr = simpleDateFormat.format(date);
        return timeStr;
    }

    public static String getTimeFromSecond(Long second, String formatStr) {
        return DateUtils.getSimpleDateFormat(formatStr).format(new Date(second * 1000L));
    }

    public static boolean isTomorrow(Calendar cal, long preTime) {
        Calendar mintianday = Calendar.getInstance();
        mintianday.set(1, cal.get(1));
        mintianday.set(2, cal.get(2));
        mintianday.set(5, cal.get(5) + 1);
        Calendar pre = Calendar.getInstance();
        pre.setTime(new Date(preTime));
        if (pre.get(5) != mintianday.get(5)) {
            return false;
        }
        if (pre.get(2) != mintianday.get(2)) {
            return false;
        }
        return pre.get(1) == mintianday.get(1);
    }

    public static boolean isToday(Calendar cal, long preTime) {
        Calendar pre = Calendar.getInstance();
        pre.setTime(new Date(preTime));
        if (pre.get(5) != cal.get(5)) {
            return false;
        }
        if (pre.get(2) != cal.get(2)) {
            return false;
        }
        return pre.get(1) == cal.get(1);
    }

    public static boolean isThisYear(Calendar cal, long preTime) {
        Calendar pre = Calendar.getInstance();
        pre.setTime(new Date(preTime));
        return pre.get(1) == cal.get(1);
    }

    public static boolean isYesterday(Calendar cal, long timestamp) {
        Calendar compare = Calendar.getInstance();
        compare.set(1, cal.get(1));
        compare.set(2, cal.get(2));
        compare.set(5, cal.get(5) - 1);
        Calendar pre = Calendar.getInstance();
        pre.setTimeInMillis(timestamp);
        if (pre.get(5) != compare.get(5)) {
            return false;
        }
        if (pre.get(2) != compare.get(2)) {
            return false;
        }
        return pre.get(1) == compare.get(1);
    }

    public static SimpleDateFormat getSimpleDateFormat(String format) {
        return CommonUtils.getSimpleDateFormat(format);
    }

    public static boolean getIsMoreDayByTwoMillisecond(Long date1, Long date2) {
        long sum = 86400000L;
        return date2 - date1 > sum;
    }

    public static String getImMsgFormatTime(long msgTime) {
        Calendar c = Calendar.getInstance();
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        int y1 = c.get(1);
        Date today = c.getTime();
        long diff = today.getTime() - msgTime;
        if (diff < 0L) {
            diff = 0L;
        }
        long days = diff / 86400000L;
        c.clear();
        c.setTimeInMillis(msgTime);
        int y2 = c.get(1);
        SimpleDateFormat format = days == 0L ? CommonUtils.getSimpleDateFormat("HH:mm") : (y1 != y2 ? CommonUtils.getSimpleDateFormat("yyyy\u5e74M\u6708d\u65e5") : CommonUtils.getSimpleDateFormat("M\u6708d\u65e5"));
        return format.format(c.getTime());
    }

    public static String getGreetMsgFormatTime(long msgTime) {
        Calendar c = Calendar.getInstance();
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        int y1 = c.get(1);
        Date today = c.getTime();
        long diff = today.getTime() - msgTime;
        if (diff < 0L) {
            diff = 0L;
        }
        long days = diff / 86400000L;
        c.clear();
        c.setTimeInMillis(msgTime);
        int y2 = c.get(1);
        SimpleDateFormat format = days == 0L ? CommonUtils.getSimpleDateFormat("H:mm") : (y1 != y2 ? CommonUtils.getSimpleDateFormat("yyyy-M-dd") : CommonUtils.getSimpleDateFormat("M-dd"));
        return format.format(c.getTime());
    }

    public static long getTimestamp(String time, String type) {
        long times = 0L;
        try {
            Date date = DateUtils.getDateFromStr(time, type);
            times = date.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return times;
    }

    public static int getAge(String birthday) {
        if (FP.empty(birthday)) {
            return 0;
        }
        try {
            Date date = DateUtils.getDateFromStr(birthday, FORMAT_DATE_SPLIT);
            if (date == null) {
                date = DateUtils.getDateFromStr(birthday, FORMAT_DATE_SPLIT_SPACE);
            }
            int age = DateUtils.getAge(date);
            return age;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static Date getDateFromStr(String time, String format) {
        if (FP.empty(time)) {
            return null;
        }
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            date = formatter.parse(time);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return date;
    }

    public static String dateToString(long timestamp, String format) {
        try {
            Date date = new Date(timestamp);
            return DateUtils.dateToString(date, format);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static int getAge(Date birthday) {
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthday)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthday);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static boolean before(String formatTime) {
        long time = DateUtils.getTimestamp(formatTime, FORMAT_DATE_SPLIT);
        if (time == 0L) {
            time = DateUtils.getTimestamp(formatTime, FORMAT_DATE_SPLIT_SPACE);
        }
        return time > System.currentTimeMillis();
    }

    public static int getZodiac(String birday) {
        try {
            int[] mArr = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
            Date date = DateUtils.getDateFromStr(birday, FORMAT_DATE_SPLIT);
            if (date == null) {
                date = DateUtils.getDateFromStr(birday, FORMAT_DATE_SPLIT_SPACE);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int monthBirth = cal.get(2);
            int dayOfMonthBirth = cal.get(5);
            int index = monthBirth + 1;
            if (dayOfMonthBirth < mArr[monthBirth]) {
                --index;
            }
            return index;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static int getZodiacText(String birday) {
        int index = DateUtils.getZodiac(birday);
        if (index < 0 || index > 12) {
            return 0;
        }
        int[] mZodiacTexts = new int[]{R.string.capricorn, R.string.aquarius, R.string.pisces, R.string.aries, R.string.taurus, R.string.gemini, R.string.cancer, R.string.leo, R.string.virgo, R.string.libra, R.string.scorpio, R.string.sagittarius, R.string.capricorn};
        return mZodiacTexts[index];
    }

    public static boolean isOverZeroPoint(long preTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(preTime);
        cal.set(11, 24);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        Calendar calToday = Calendar.getInstance();
        return calToday.getTimeInMillis() > cal.getTimeInMillis();
    }

    public static String getBeforeDay() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_DATE_SPLIT);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return df.format(date);
    }

    public static boolean isCurrentMonth() {
        return DateUtils.isActionFirst("key_video_every_month", FORMAT_DATE);
    }

    public static boolean isTodayFirst() {
        return DateUtils.isActionFirst("key_video_every_day", FORMAT_DATE_SPLIT);
    }

    public static boolean isFollowFirst() {
        return !DateUtils.isActionFirst("previous_start_date", FORMAT_DATE_SPLIT);
    }

    public static boolean isActionFirst(String keys, String format) {
        String actionValue = SettingFlags.getStringValue(keys);
        String currentValue = DateUtils.dateToString(new Date(), format);
        if (!currentValue.equals(actionValue)) {
            SettingFlags.setStringValue(keys, currentValue);
            return false;
        }
        return true;
    }

    public static int getIntervalDays(String startDate) {
        SimpleDateFormat formatter = DateUtils.getSimpleDateFormat(FORMAT_DATE_SPLIT);
        try {
            Date startDay = formatter.parse(startDate);
            if (startDay == null) {
                return 0;
            }
            return DateUtils.getIntervalDays(startDay.getTime(), System.currentTimeMillis());
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "getIntervalDays = " + startDate + ", failed", e, new Object[0]);
            return 0;
        }
    }

    public static int getIntervalDays(long begin, long end) {
        try {
            Calendar beginCal = Calendar.getInstance();
            beginCal.setTimeInMillis(begin);
            Calendar endCal = Calendar.getInstance();
            endCal.setTimeInMillis(end);
            int between = (int)(end - begin) / 86400000;
            endCal.add(5, -between);
            endCal.add(5, -1);
            if (beginCal.get(5) == endCal.get(5)) {
                return between + 1;
            }
            return between;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "getIntervalDays begin: %d, end: %d, failed", e, begin, end);
            return 0;
        }
    }
}

