/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.mcxiaoke.packer.helper.PackerNg;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;

public class AppMetaDataUtil {
    public static final String HUAWEI_CHANNEL = "huawei";
    private static String sChannelId;
    private static boolean sGetMarketTaskIsExcuted;
    private static int sSvnBuildVersion;

    public static String getChannelID(Context context) {
        if (!StringUtils.isEmpty(sChannelId)) {
            return sChannelId;
        }
        if (AppMetaDataUtil.getFromSp()) {
            return sChannelId;
        }
        String channelID = AppMetaDataUtil.getMarket(context);
        channelID = channelID == null ? "official" : channelID;
        return channelID;
    }

    @Nullable
    private static String getMarket(Context context) {
        String channelID = null;
        try {
            if (context != null) {
                channelID = AppMetaDataUtil.getMetaChannel(context);
                if (TextUtils.isEmpty((CharSequence)channelID)) {
                    channelID = PackerNg.getChannel((Context)context);
                }
                sChannelId = channelID;
                AppMetaDataUtil.putToSp();
            }
            YYTaskExecutor.postToMainThread(new Runnable(){

                @Override
                public void run() {
                    MLog.info("AppMetaDataUtil", "getMarket=%s", sChannelId);
                }
            }, 8000L);
        }
        catch (Exception e) {
            Log.e((String)"", (String)e.toString());
        }
        return channelID;
    }

    private static synchronized boolean getFromSp() {
        if (!StringUtils.isEmpty(sChannelId)) {
            return true;
        }
        try {
            sChannelId = SettingFlags.getStringValue("key_channel_id");
            if (!sGetMarketTaskIsExcuted) {
                sGetMarketTaskIsExcuted = true;
                Runnable update = new Runnable(){

                    @Override
                    public void run() {
                        String channelID = AppMetaDataUtil.getMarket(RuntimeContext.sApplicationContext);
                        if (!StringUtils.isEmpty(channelID)) {
                            sChannelId = channelID;
                        }
                    }
                };
                YYTaskExecutor.getDefaultIdleExecutor().execute(update, 10000L);
            }
            return !StringUtils.isEmpty(sChannelId);
        }
        catch (Exception e) {
            YYTaskExecutor.postToMainThread(new Runnable(){

                @Override
                public void run() {
                    MLog.error((Object)"AppMetaDataUtil", "getFromSp", e, new Object[0]);
                }
            }, 8000L);
            return false;
        }
    }

    private static synchronized void putToSp() {
        try {
            SettingFlags.setStringValue("key_channel_id", sChannelId);
        }
        catch (Exception e) {
            YYTaskExecutor.postToMainThread(new Runnable(){

                @Override
                public void run() {
                    MLog.error((Object)"AppMetaDataUtil", "putToSp", e, new Object[0]);
                }
            }, 8000L);
        }
    }

    private static String getMetaChannel(Context context) {
        String channel = "";
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            channel = appInfo.metaData.getString("channel", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return channel;
    }

    public static int getSvnBuildVersion(Context context) {
        if (sSvnBuildVersion != -1) {
            return sSvnBuildVersion;
        }
        int svnBuildVer = 0;
        try {
            if (context != null) {
                String pkgName = context.getPackageName();
                ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(pkgName, 128);
                sSvnBuildVersion = svnBuildVer = appInfo.metaData.getInt("SvnBuildVersion");
            }
        }
        catch (Exception e) {
            Log.e((String)"", (String)e.toString());
        }
        return svnBuildVer;
    }

    static {
        sGetMarketTaskIsExcuted = false;
        sSvnBuildVersion = -1;
    }
}

