/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.thread;

import android.os.Looper;
import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.base.thread.HandlerThreadAsyncAdapter;
import com.yy.base.thread.ThreadAsyncAdapter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadBus {
    public static final int THREAD_BUS_PRIORITY_HIGH = -1;
    public static final int THREAD_BUS_PRIORITY_MIDDLE = 0;
    public static final int THREAD_BUS_PRIORITY_LOW = 10;
    private static ConcurrentHashMap<Integer, ThreadAsyncAdapter> bus = new ConcurrentHashMap();
    public static final int Sync = 0;
    public static final int Main = 1;
    public static final int Working = 2;
    public static final int Db = 3;
    public static final int Shit = 4;
    public static final int Inherent_Thread_Index = 5;
    private static AtomicInteger BusThreadBegin = new AtomicInteger(5);

    private static int gen() {
        return BusThreadBegin.incrementAndGet();
    }

    private static void init() {
        ThreadBus.addThread(1, new HandlerThreadAsyncAdapter(Looper.getMainLooper()));
        ThreadBus.addThread(2, new HandlerThreadAsyncAdapter("ThreadBus-Working", -1));
        ThreadBus.addThread(3, new HandlerThreadAsyncAdapter("ThreadBus-Db", 0));
        ThreadBus.addThread(4, new HandlerThreadAsyncAdapter("ThreadBus-Shit", 10));
    }

    public static int addThread(@NonNull ThreadAsyncAdapter threadAsyncAdapter) {
        return ThreadBus.addThread(ThreadBus.gen(), threadAsyncAdapter);
    }

    private static int addThread(int id2, @NonNull ThreadAsyncAdapter threadAsyncAdapter) {
        MLog.info("ThreadBus", "addThread id = " + id2, new Object[0]);
        bus.put(id2, threadAsyncAdapter);
        return id2;
    }

    public static ThreadAsyncAdapter threadAdapter(int idx) {
        return bus.get(idx);
    }

    public static boolean post(int idx, Runnable r) {
        return ThreadBus.threadAdapter(idx).post(r);
    }

    public static boolean postDelayed(int idx, Runnable r, long delayMillis) {
        return ThreadBus.threadAdapter(idx).postDelayed(r, delayMillis);
    }

    public static boolean postAtTime(int idx, Runnable r, long uptimeMillis) {
        return ThreadBus.threadAdapter(idx).postAtTime(r, uptimeMillis);
    }

    public static void removeCallbacks(int idx, Runnable r, Object token) {
        ThreadBus.threadAdapter(idx).removeCallbacks(r, token);
    }

    public static boolean callThreadSafe(int idx, Runnable r) {
        ThreadAsyncAdapter adapter = ThreadBus.threadAdapter(idx);
        if (adapter != null) {
            if (adapter.isCurrentThread()) {
                r.run();
            } else {
                adapter.post(r);
            }
            return true;
        }
        return false;
    }

    public static void quitAndRemove(int idx) {
        ThreadAsyncAdapter adapter = bus.remove(idx);
        if (adapter != null) {
            adapter.quit();
        }
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    static {
        ThreadBus.init();
    }
}

