/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.job;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.core.util.Consumer;
import com.yy.base.function.BiFunction;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.taskexecutor.job.FutureSingleResultCallback;
import com.yy.base.taskexecutor.job.SingleResultCallback;
import com.yy.base.taskexecutor.job.SingleSource;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Unit;

public abstract class Single<E>
implements SingleSource<E> {
    private static final String TAG = "AsyncJobStream";

    public static <T> Single<T> just(final @NonNull T param) {
        return new Single<T>(){

            @Override
            public void start(SingleResultCallback<T> callback) {
                callback.onResult(param);
            }
        };
    }

    public void start(final @Nullable Consumer<E> onResult, final @Nullable Consumer<Throwable> onError) {
        this.start(new SingleResultCallback<E>(){

            @Override
            public void onResult(@NonNull E result) {
                if (onResult != null) {
                    onResult.accept(result);
                }
            }

            @Override
            public void onError(@NonNull Throwable throwable) {
                if (onError != null) {
                    onError.accept((Object)throwable);
                }
            }
        });
    }

    public <R> Single<R> map(final @NonNull Function<E, R> fun) {
        return new Single<R>(){

            @Override
            public void start(final SingleResultCallback<R> callback) {
                Single.this.start(new SingleResultCallback<E>(){

                    @Override
                    public void onResult(@NonNull E input) {
                        try {
                            Object result = fun.apply(input);
                            callback.onResult(result);
                        }
                        catch (Throwable e) {
                            callback.onError(e);
                        }
                    }

                    @Override
                    public void onError(@NonNull Throwable throwable) {
                        callback.onError(throwable);
                    }
                });
            }
        };
    }

    public <R> Single<R> flatMap(final @NonNull Function<E, SingleSource<R>> fun) {
        return new Single<R>(){

            @Override
            public void start(final SingleResultCallback<R> callback) {
                Single.this.start(new SingleResultCallback<E>(){

                    @Override
                    public void onResult(@NonNull E input) {
                        try {
                            SingleSource resultJob = (SingleSource)fun.apply(input);
                            resultJob.start(new SingleResultCallback<R>(){

                                @Override
                                public void onResult(@NonNull R result) {
                                    callback.onResult(result);
                                }

                                @Override
                                public void onError(@NonNull Throwable throwable) {
                                    callback.onError(throwable);
                                }
                            });
                        }
                        catch (Throwable e) {
                            callback.onError(e);
                        }
                    }

                    @Override
                    public void onError(@NonNull Throwable throwable) {
                        callback.onError(throwable);
                    }
                });
            }
        };
    }

    public <T, R> Single<R> zip(final @NonNull SingleSource<T> other, final @NonNull BiFunction<E, T, R> transform) {
        final Single sourceJob = this;
        return new Single<R>(){

            @Override
            public void start(final SingleResultCallback<R> callback) {
                List<SingleSource> singleSourceStreams = Arrays.asList(sourceJob, other);
                final AtomicBoolean errorCall = new AtomicBoolean(false);
                final AtomicInteger resultCall = new AtomicInteger(singleSourceStreams.size());
                final Object[] results = new Object[singleSourceStreams.size()];
                Consumer<Throwable> onError = new Consumer<Throwable>(){

                    public void accept(Throwable throwable) {
                        if (!errorCall.getAndSet(true)) {
                            callback.onError(throwable);
                        } else {
                            Log.e((String)Single.TAG, (String)"onError: ", (Throwable)throwable);
                        }
                    }
                };
                Consumer<Unit> onResult = new Consumer<Unit>(){

                    public void accept(Unit unit) {
                        int remainCall = resultCall.decrementAndGet();
                        if (remainCall == 0) {
                            try {
                                callback.onResult(transform.apply(results[0], results[1]));
                            }
                            catch (Throwable e) {
                                callback.onError(e);
                            }
                        }
                    }
                };
                for (int i = 0; i < singleSourceStreams.size(); ++i) {
                    final int resultIndex = i;
                    singleSourceStreams.get(i).start(new SingleResultCallback((Consumer)onResult, (Consumer)onError){
                        final /* synthetic */ Consumer val$onResult;
                        final /* synthetic */ Consumer val$onError;
                        {
                            this.val$onResult = consumer;
                            this.val$onError = consumer2;
                        }

                        public void onResult(@NonNull Object result) {
                            results[resultIndex] = result;
                            this.val$onResult.accept((Object)Unit.INSTANCE);
                        }

                        @Override
                        public void onError(@NonNull Throwable throwable) {
                            this.val$onError.accept((Object)throwable);
                        }
                    });
                }
            }
        };
    }

    public Single<E> switchMainThread() {
        return new Single<E>(){

            @Override
            public void start(final SingleResultCallback<E> callback) {
                Single.this.start(new SingleResultCallback<E>(){

                    @Override
                    public void onResult(final @NonNull E result) {
                        YYTaskExecutor.postToMainThread(new Runnable(){

                            @Override
                            public void run() {
                                callback.onResult(result);
                            }
                        });
                    }

                    @Override
                    public void onError(final @NonNull Throwable throwable) {
                        YYTaskExecutor.postToMainThread(new Runnable(){

                            @Override
                            public void run() {
                                callback.onError(throwable);
                            }
                        });
                    }
                });
            }
        };
    }

    public Single<E> switchWorkerThread() {
        return new Single<E>(){

            @Override
            public void start(final SingleResultCallback<E> callback) {
                Single.this.start(new SingleResultCallback<E>(){

                    @Override
                    public void onResult(final @NonNull E result) {
                        YYTaskExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                callback.onResult(result);
                            }
                        });
                    }

                    @Override
                    public void onError(final @NonNull Throwable throwable) {
                        YYTaskExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                callback.onError(throwable);
                            }
                        });
                    }
                });
            }
        };
    }

    public Future<E> toFuture() {
        FutureSingleResultCallback callback = new FutureSingleResultCallback();
        this.start(callback);
        return callback;
    }
}

