/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.job;

import androidx.annotation.NonNull;
import com.yy.base.taskexecutor.job.SingleResultCallback;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureSingleResultCallback<T>
implements Future<T>,
SingleResultCallback<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile T result;
    private volatile Throwable throwable;
    private volatile boolean isCancel;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.isCancel = true;
        this.latch.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancel;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        if (this.latch.getCount() == 1L) {
            this.latch.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable error = this.throwable;
        if (error != null) {
            throw new ExecutionException(error);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.latch.getCount() == 1L && !this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable error = this.throwable;
        if (error != null) {
            throw new ExecutionException(error);
        }
        return this.result;
    }

    @Override
    public void onResult(@NonNull T result) {
        this.result = result;
        this.latch.countDown();
    }

    @Override
    public void onError(@NonNull Throwable throwable) {
        this.throwable = throwable;
        this.latch.countDown();
    }
}

