/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.instrument;

import com.yy.base.taskexecutor.YYProxyThreadPoolExecutor;
import com.yy.base.taskexecutor.instrument.NamedThreadFactory;
import com.yy.base.taskexecutor.instrument.ThreadHookHelper;
import com.yy.base.taskexecutor.single.YYProxySingleThreadPoolExecutor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class YYThreadPoolExecutor
extends ThreadPoolExecutor {
    private ThreadPoolExecutor proxyThreadPoolExecutor;
    private final String tag;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;
    private final TimeUnit unit;
    private final int corePoolSize;
    private final BlockingQueue<Runnable> workQueue;
    private final int maximumPoolSize;
    private final long keepAliveTime;
    private boolean shouldProxy = false;
    private volatile boolean callProxy = false;
    public static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();

    public YYThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String prefix, String tag) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler, prefix, tag);
    }

    public YYThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, String prefix, String tag) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler, prefix, tag);
    }

    public YYThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler, String prefix, String tag) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler, prefix, tag);
    }

    public YYThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String prefix, String tag) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new NamedThreadFactory(threadFactory, prefix), handler);
        this.tag = tag;
        this.maximumPoolSize = maximumPoolSize;
        this.corePoolSize = corePoolSize;
        this.workQueue = workQueue;
        this.unit = unit;
        this.threadFactory = threadFactory;
        this.handler = handler;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        if (!this.shouldProxy() && ThreadHookHelper.allowCoreThreadTimeOut()) {
            this.allowCoreThreadTimeOut(this.getKeepAliveTime(unit) > 0L);
        }
    }

    private synchronized boolean shouldProxy() {
        if (this.callProxy) {
            return this.shouldProxy;
        }
        this.callProxy = true;
        this.shouldProxy = ThreadHookHelper.shouldHookThreadPoolExecutor(this.tag);
        if (this.shouldProxy && this.proxyThreadPoolExecutor == null) {
            if (this.maximumPoolSize == 1) {
                this.proxyThreadPoolExecutor = new YYProxySingleThreadPoolExecutor(this.tag);
                if (ThreadHookHelper.needUseWorkPriorityPool(this.tag)) {
                    ((YYProxySingleThreadPoolExecutor)this.proxyThreadPoolExecutor).setUseWorkPriority(true);
                }
            } else {
                this.proxyThreadPoolExecutor = new YYProxyThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.unit, this.workQueue, this.threadFactory, this.handler, this.tag);
                if (ThreadHookHelper.needUseWorkPriorityPool(this.tag)) {
                    ((YYProxyThreadPoolExecutor)this.proxyThreadPoolExecutor).setUseWorkPriority(true);
                }
            }
        }
        return this.shouldProxy;
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.setThreadFactory(threadFactory);
        } else {
            super.setThreadFactory(threadFactory);
        }
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.setRejectedExecutionHandler(handler);
        } else {
            super.setRejectedExecutionHandler(handler);
        }
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.setCorePoolSize(corePoolSize);
        } else {
            super.setCorePoolSize(corePoolSize);
        }
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.allowCoreThreadTimeOut(value);
        } else {
            super.allowCoreThreadTimeOut(value);
        }
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.setMaximumPoolSize(maximumPoolSize);
        } else {
            super.setMaximumPoolSize(maximumPoolSize);
        }
    }

    @Override
    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.setKeepAliveTime(time, unit);
        } else {
            super.setKeepAliveTime(time, unit);
        }
    }

    @Override
    public void purge() {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.purge();
        } else {
            super.purge();
        }
    }

    @Override
    public boolean prestartCoreThread() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.prestartCoreThread();
        }
        return super.prestartCoreThread();
    }

    @Override
    public int prestartAllCoreThreads() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.prestartAllCoreThreads();
        }
        return super.prestartAllCoreThreads();
    }

    @Override
    public boolean allowsCoreThreadTimeOut() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.allowsCoreThreadTimeOut();
        }
        return super.allowsCoreThreadTimeOut();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.getQueue();
        }
        return super.getQueue();
    }

    @Override
    public boolean remove(Runnable task) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.remove(task);
        }
        return super.remove(task);
    }

    @Override
    public void shutdown() {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.shutdown();
        } else {
            super.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.shutdownNow();
        }
        return super.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.isShutdown();
        }
        return super.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.isTerminated();
        }
        return super.isTerminated();
    }

    @Override
    public boolean isTerminating() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.isTerminating();
        }
        return super.isTerminating();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.awaitTermination(timeout, unit);
        }
        return super.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.execute(command);
        } else {
            super.execute(command);
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.submit(task);
        }
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.submit(task);
        }
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.submit(task, result);
        }
        return super.submit(task, result);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.invokeAll(tasks);
        }
        return super.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.invokeAll(tasks, timeout, unit);
        }
        return super.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.invokeAny(tasks);
        }
        return super.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.invokeAny(tasks, timeout, unit);
        }
        return super.invokeAny(tasks, timeout, unit);
    }
}

