/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.instrument;

import android.annotation.SuppressLint;
import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.taskexecutor.instrument.ThreadHookHelper;
import com.yy.base.utils.SystemUtils;
import com.yy.hago.xlog.KLogUtils;

@SuppressLint(value={"ThreadUsage"})
public class YYThread
extends Thread {
    private Runnable target;
    private String tag;
    private IQueueTaskExecutor mExecutor;
    private static int sIndex = 0;
    static final String MARK = "\u200b";

    public static Thread setThreadName(Thread t, String prefix) {
        t.setName(YYThread.makeThreadName(t.getName(), prefix));
        return t;
    }

    public static String makeThreadName(String name) {
        return name == null ? "" : (name.startsWith(MARK) ? name : MARK + name);
    }

    public static String makeThreadName(String name, String prefix) {
        return name == null ? prefix : (name.startsWith(MARK) ? name : prefix + "#" + name);
    }

    public YYThread() {
        ++sIndex;
    }

    public YYThread(Runnable target) {
        super(target);
        this.target = target;
        ++sIndex;
    }

    public YYThread(ThreadGroup group, Runnable target) {
        super(group, target);
        this.target = target;
        ++sIndex;
    }

    public YYThread(String prefix, String tag) {
        super(YYThread.makeThreadName(prefix));
        this.tag = tag;
        ++sIndex;
    }

    public YYThread(ThreadGroup group, String prefix, String tag) {
        super(group, YYThread.makeThreadName(prefix));
        this.tag = tag;
        ++sIndex;
    }

    public YYThread(Runnable target, String prefix, String tag) {
        super(target, YYThread.makeThreadName(prefix));
        this.target = target;
        this.tag = tag;
        ++sIndex;
    }

    public YYThread(ThreadGroup group, Runnable target, String prefix, String tag) {
        super(group, target, YYThread.makeThreadName(prefix));
        this.target = target;
        this.tag = tag;
        ++sIndex;
    }

    public YYThread(String name, String prefix, String tag) {
        super(YYThread.makeThreadName(name, prefix));
        this.tag = tag;
        ++sIndex;
    }

    public YYThread(ThreadGroup group, String name, String prefix, String tag) {
        super(group, YYThread.makeThreadName(name, prefix));
        this.tag = tag;
        ++sIndex;
    }

    public YYThread(Runnable target, String name, String prefix, String tag) {
        super(target, YYThread.makeThreadName(name, prefix));
        this.target = target;
        this.tag = tag;
        ++sIndex;
    }

    public YYThread(ThreadGroup group, Runnable target, String name, String prefix, String tag) {
        super(group, target, YYThread.makeThreadName(name, prefix));
        this.target = target;
        this.tag = tag;
        ++sIndex;
    }

    public YYThread(ThreadGroup group, Runnable target, String name, long stackSize, String prefix, String tag) {
        super(group, target, YYThread.makeThreadName(name, prefix), stackSize);
        this.target = target;
        this.tag = tag;
        ++sIndex;
    }

    @Override
    public synchronized void start() {
        if (!this.useProxy()) {
            super.start();
            if (SystemUtils.isShowEnvSetting()) {
                PerfActionLog.add("ThreadCreate_YYThread" + sIndex, new Object[0]);
            }
            return;
        }
        if (this.mExecutor == null) {
            this.mExecutor = YYTaskExecutor.createAQueueExcuter(this.shouldUseHighPriority());
        }
        if (RuntimeContext.isInGray()) {
            if (KLogUtils.isInitialized()) {
                MLog.info("YYThead", "start,%s", this.tag != null ? this.tag : "");
            } else if (RuntimeContext.isLocalBuild()) {
                Log.i((String)"YYThead", (String)("start," + (this.tag != null ? this.tag : "")));
            }
        }
        if (this.target != null) {
            this.mExecutor.execute(this.target, 0L);
        } else {
            this.mExecutor.execute(this, 0L);
            if (SystemUtils.isShowEnvSetting()) {
                PerfActionLog.add("ThreadCreate_YYThread" + sIndex, new Object[0]);
            }
        }
    }

    @Override
    public void run() {
        if (!this.useProxy()) {
            super.run();
            return;
        }
        if (this.target != null) {
            this.target.run();
        }
    }

    private boolean useProxy() {
        return ThreadHookHelper.shouldHookOneThread(this.tag);
    }

    private boolean shouldUseHighPriority() {
        return ThreadHookHelper.shouldOneThreadUseHighPriority(this.tag);
    }
}

