/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.instrument;

import com.yy.base.taskexecutor.YYProxyScheduledThreadPoolExecutor;
import com.yy.base.taskexecutor.instrument.ThreadHookHelper;
import com.yy.base.taskexecutor.instrument.YYThreadPoolExecutor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class YYScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private ScheduledThreadPoolExecutor proxyThreadPoolExecutor;
    private final String tag;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;
    private final int corePoolSize;
    private boolean shouldProxy = false;
    private volatile boolean callProxy = false;

    public YYScheduledThreadPoolExecutor(int corePoolSize, String prefix, String tag) {
        this(corePoolSize, Executors.defaultThreadFactory(), YYThreadPoolExecutor.defaultHandler, prefix, tag);
    }

    public YYScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, String prefix, String tag) {
        this(corePoolSize, threadFactory, YYThreadPoolExecutor.defaultHandler, prefix, tag);
    }

    public YYScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler, String prefix, String tag) {
        this(corePoolSize, Executors.defaultThreadFactory(), handler, prefix, tag);
    }

    public YYScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler, String prefix, String tag) {
        super(corePoolSize, threadFactory, handler);
        this.tag = tag;
        this.corePoolSize = corePoolSize;
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    private boolean shouldProxy() {
        if (this.callProxy) {
            return this.shouldProxy;
        }
        this.callProxy = true;
        this.shouldProxy = ThreadHookHelper.shouldHookThreadPoolExecutor(this.tag);
        if (this.shouldProxy && this.proxyThreadPoolExecutor == null) {
            this.proxyThreadPoolExecutor = new YYProxyScheduledThreadPoolExecutor(this.corePoolSize, this.threadFactory, this.handler, this.tag);
        }
        return this.shouldProxy;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
        }
        return super.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.schedule(command, delay, unit);
        }
        return super.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.schedule(callable, delay, unit);
        }
        return super.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
        return super.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.execute(command);
        } else {
            super.execute(command);
        }
    }

    @Override
    public void shutdown() {
        if (this.shouldProxy()) {
            this.proxyThreadPoolExecutor.shutdown();
        } else {
            super.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.shutdownNow();
        }
        return super.shutdownNow();
    }

    @Override
    public boolean allowsCoreThreadTimeOut() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.allowsCoreThreadTimeOut();
        }
        return super.allowsCoreThreadTimeOut();
    }

    @Override
    public boolean isShutdown() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.isShutdown();
        }
        return super.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.isTerminated();
        }
        return super.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.awaitTermination(timeout, unit);
        }
        return super.awaitTermination(timeout, unit);
    }

    public Future<?> submit(Callable task) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.submit(task);
        }
        return super.submit(task);
    }

    public Future<?> submit(Runnable task, Object result) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.submit(task, result);
        }
        return super.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.submit(task);
        }
        return super.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.invokeAll(tasks);
        }
        return super.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.invokeAll(tasks, timeout, unit);
        }
        return super.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.invokeAny(tasks);
        }
        return super.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.shouldProxy()) {
            return this.proxyThreadPoolExecutor.invokeAny(tasks, timeout, unit);
        }
        return super.invokeAny(tasks, timeout, unit);
    }
}

