/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.instrument;

import androidx.annotation.RequiresApi;
import com.yy.base.taskexecutor.instrument.NamedForkJoinWorkerThreadFactory;
import com.yy.base.taskexecutor.instrument.NamedThreadFactory;
import com.yy.base.taskexecutor.instrument.ThreadHookHelper;
import com.yy.base.utils.HardwareUtils;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class YYExecutors {
    private static final long DEFAULT_KEEP_ALIVE = 30000L;
    private static final int NCPU = HardwareUtils.getCpuCoreCount();
    private static final int MAX_POOL_SIZE = (NCPU << 1) + 1;

    public static ThreadFactory defaultThreadFactory(String name) {
        return new NamedThreadFactory(name);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String name, String tag) {
        return YYExecutors.newFixedThreadPool(nThreads, null, name, tag);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory factory, String name, String tag) {
        ExecutorService hookExecutorService = ThreadHookHelper.newFixedThreadPool(nThreads, factory, tag);
        if (hookExecutorService != null) {
            return hookExecutorService;
        }
        return Executors.newFixedThreadPool(nThreads, new NamedThreadFactory(factory, name));
    }

    public static ExecutorService newSingleThreadExecutor(String name, String tag) {
        return YYExecutors.newSingleThreadExecutor(null, name, tag);
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory factory, String name, String tag) {
        ExecutorService hookExecutorService = ThreadHookHelper.newSingleThreadExecutor(factory, tag);
        if (hookExecutorService != null) {
            return hookExecutorService;
        }
        return Executors.newSingleThreadExecutor(new NamedThreadFactory(factory, name));
    }

    public static ExecutorService newCachedThreadPool(String name, String tag) {
        return YYExecutors.newCachedThreadPool(null, name, tag);
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory factory, String name, String tag) {
        ExecutorService hookExecutorService = ThreadHookHelper.newCachedThreadPool(factory, tag);
        if (hookExecutorService != null) {
            return hookExecutorService;
        }
        return Executors.newCachedThreadPool(new NamedThreadFactory(factory, name));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String name, String tag) {
        return YYExecutors.newSingleThreadScheduledExecutor(null, name, tag);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory factory, String name, String tag) {
        ScheduledExecutorService hookExecutorService = ThreadHookHelper.newSingleThreadScheduledExecutor(factory, tag);
        if (hookExecutorService != null) {
            return hookExecutorService;
        }
        if (ThreadHookHelper.allowCoreThreadTimeOut()) {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory(factory, name));
            executor.setKeepAliveTime(30000L, TimeUnit.MILLISECONDS);
            executor.allowCoreThreadTimeOut(true);
            return executor;
        }
        return Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(factory, name));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String name, String tag) {
        return YYExecutors.newScheduledThreadPool(corePoolSize, null, name, tag);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory factory, String name, String tag) {
        ScheduledExecutorService hookExecutorService = ThreadHookHelper.newScheduledThreadPool(corePoolSize, factory, tag);
        if (hookExecutorService != null) {
            return hookExecutorService;
        }
        if (ThreadHookHelper.allowCoreThreadTimeOut()) {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Math.min(Math.max(1, corePoolSize), MAX_POOL_SIZE), new NamedThreadFactory(factory, name));
            executor.setKeepAliveTime(30000L, TimeUnit.MILLISECONDS);
            executor.allowCoreThreadTimeOut(true);
            return executor;
        }
        return Executors.newScheduledThreadPool(corePoolSize, new NamedThreadFactory(factory, name));
    }

    @RequiresApi(api=21)
    public static ExecutorService newWorkStealingPool(String name, String tag) {
        return new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new NamedForkJoinWorkerThreadFactory(name), null, true);
    }

    @RequiresApi(api=21)
    public static ExecutorService newWorkStealingPool(int parallelism, String name, String tag) {
        return new ForkJoinPool(parallelism, new NamedForkJoinWorkerThreadFactory(name), null, true);
    }

    private static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService executor;

        DelegatedExecutorService(ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(command);
        }

        @Override
        public void shutdown() {
            this.executor.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.executor.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.awaitTermination(timeout, unit);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.executor.submit(task);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.executor.submit(task, result);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.executor.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.executor.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.executor.invokeAny(tasks, timeout, unit);
        }
    }

    private static final class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService executor) {
            super(executor);
        }

        protected void finalize() {
            super.shutdown();
        }
    }
}

