/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.instrument;

import android.util.Log;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadHookHelper {
    public static final String TAG = "ThreadHookHelper";
    private static IThreadHookSwitcher sThreadHookSwticher;

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory, String tag) {
        Log.d((String)TAG, (String)String.format("new SingleThreadExecutor tag:%s, Factory:%s!", tag, threadFactory));
        ExecutorService executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newSingleThreadExecutor(threadFactory, tag);
        }
        return executorService;
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory, String tag) {
        Log.d((String)TAG, (String)String.format("new SingleThreadExecutor tag:%s, threadNum:%d, Factory:%s!", tag, nThreads, threadFactory));
        ExecutorService executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newFixedThreadPool(nThreads, threadFactory, tag);
        }
        return executorService;
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory, String tag) {
        Log.d((String)TAG, (String)String.format("new CachedThreadPool tag:%s, threadFactory:%s!", tag, threadFactory));
        ExecutorService executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newCachedThreadPool(threadFactory, tag);
        }
        return executorService;
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory, String tag) {
        Log.d((String)TAG, (String)String.format("new SingleThreadScheduledExecutor tag:%s, threadFactory:%s!", tag, threadFactory));
        ScheduledExecutorService executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newSingleThreadScheduledExecutor(threadFactory, tag);
        }
        return executorService;
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, String tag) {
        Log.d((String)TAG, (String)String.format("new ScheduledThreadPool tag:%s, corePoolSize:%d, threadFactory:%s!", tag, corePoolSize, threadFactory));
        ScheduledThreadPoolExecutor executorService = null;
        if (sThreadHookSwticher != null) {
            executorService = sThreadHookSwticher.newScheduledThreadPoolExecutor(corePoolSize, threadFactory, null, tag);
        }
        return executorService;
    }

    public static void setThreadHookSwticher(IThreadHookSwitcher threadHookSwticher) {
        sThreadHookSwticher = threadHookSwticher;
    }

    public static boolean shouldHookOneThread(String tag) {
        if (sThreadHookSwticher != null) {
            return sThreadHookSwticher.shouldHookOneThread(tag);
        }
        return false;
    }

    public static boolean shouldHookThreadPoolExecutor(String tag) {
        if (sThreadHookSwticher != null) {
            return sThreadHookSwticher.shouldHookThreadPoolExecutor(tag);
        }
        return false;
    }

    public static boolean shouldHookScheduledThreadPoolExecutor(String tag) {
        if (sThreadHookSwticher != null) {
            return sThreadHookSwticher.shouldHookScheduledThreadPoolExecutor(tag);
        }
        return false;
    }

    public static boolean needUseWorkPriorityPool(String tag) {
        if (sThreadHookSwticher != null) {
            return sThreadHookSwticher.needUseWorkPriorityPool(tag);
        }
        return false;
    }

    public static boolean shouldOneThreadUseHighPriority(String tag) {
        if (sThreadHookSwticher != null) {
            return sThreadHookSwticher.shouldOneThreadUseHighPriority(tag);
        }
        return false;
    }

    public static boolean allowCoreThreadTimeOut() {
        if (sThreadHookSwticher != null) {
            return sThreadHookSwticher.allowCoreThreadTimeOut();
        }
        return false;
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static interface IThreadHookSwitcher {
        public boolean shouldHookOneThread(String var1);

        public boolean allowCoreThreadTimeOut();

        public boolean needUseWorkPriorityPool(String var1);

        public boolean shouldHookThreadPoolExecutor(String var1);

        public boolean shouldHookScheduledThreadPoolExecutor(String var1);

        public boolean shouldOneThreadUseHighPriority(String var1);

        public ExecutorService newSingleThreadExecutor(ThreadFactory var1, String var2);

        public ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory var1, String var2);

        public ScheduledThreadPoolExecutor newScheduledThreadPoolExecutor(int var1, ThreadFactory var2, RejectedExecutionHandler var3, String var4);

        public ExecutorService newFixedThreadPool(int var1, ThreadFactory var2, String var3);

        public ExecutorService newCachedThreadPool(ThreadFactory var1, String var2);
    }
}

