/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.instrument;

import android.os.Process;
import android.util.Log;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.instrument.YYThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String name;
    private final int priority;
    private final ThreadFactory factory;
    private final ThreadGroup group;

    public static ThreadFactory newInstance(String prefix) {
        return new NamedThreadFactory(prefix);
    }

    public static ThreadFactory newInstance(ThreadFactory factory, String prefix) {
        return new NamedThreadFactory(factory, prefix);
    }

    public NamedThreadFactory(String name) {
        this(null, name, 10);
    }

    public NamedThreadFactory(String name, int priority) {
        this(null, name, priority);
    }

    public NamedThreadFactory(ThreadFactory factory, String name) {
        this(factory, name, 10);
    }

    public NamedThreadFactory(ThreadFactory factory, String name, int priority) {
        this.factory = factory;
        this.name = name;
        this.priority = priority;
        this.group = Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable r) {
        if (null == this.factory) {
            Runnable wrapperRunnable = () -> {
                try {
                    Process.setThreadPriority((int)this.priority);
                }
                catch (Throwable t) {
                    Log.e((String)"NamedThreadFactory", (String)"setThreadPriority threw caught throwable", (Throwable)t);
                }
                r.run();
            };
            String index = this.name + "#" + this.threadNumber.getAndIncrement();
            Thread thread = new Thread(this.group, wrapperRunnable, index, 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            PerfActionLog.add("ThreadCreate_" + index, new Object[0]);
            return thread;
        }
        return YYThread.setThreadName(this.factory.newThread(r), this.name);
    }
}

