/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.DefaultThreadFactory;
import com.yy.base.taskexecutor.Prioritized;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class YYTaskFifoPriorityThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final int THREAD_PRIORITY_BACKGROUND = 10;
    private static final String TAG = "YYThreadPoolExecutor";
    private final AtomicInteger ordering = new AtomicInteger();
    private final UncaughtThrowableStrategy uncaughtThrowableStrategy;
    private static final String THREAD_PREFIX = "YYTask";

    public YYTaskFifoPriorityThreadPoolExecutor(int poolSize) {
        this(poolSize, UncaughtThrowableStrategy.LOG);
    }

    public YYTaskFifoPriorityThreadPoolExecutor(int poolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        this(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new DefaultThreadFactory(THREAD_PREFIX), uncaughtThrowableStrategy);
    }

    public YYTaskFifoPriorityThreadPoolExecutor(int poolSize, int maxPoolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        this(poolSize, maxPoolSize, 30L, TimeUnit.SECONDS, new DefaultThreadFactory(THREAD_PREFIX), uncaughtThrowableStrategy);
    }

    public YYTaskFifoPriorityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        super(corePoolSize, maximumPoolSize, keepAlive, timeUnit, new MyPriorityBlockingQueue(corePoolSize, maximumPoolSize > 1 ? maximumPoolSize + 1 : maximumPoolSize), threadFactory, YYTaskFifoPriorityThreadPoolExecutor.getHandler(corePoolSize, maximumPoolSize));
        if (SettingFlags.hasInited() && SettingFlags.getBoolean("thread_blockingqueueopt", true)) {
            ((MyPriorityBlockingQueue)this.getQueue()).mPool = this;
        }
        this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
    }

    private static RejectedExecutionHandler getHandler(int corePoolSize, int maximumPoolSize) {
        RejectedExecutionHandler handler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(final Runnable task, final ThreadPoolExecutor executor) {
                YYTaskExecutor.onTaskRejectedExecution(task, executor);
                if (SystemUtils.isShowEnvSetting()) {
                    throw new RuntimeException("task is rejected by:" + executor.toString() + "!");
                }
                MLog.error((Object)YYTaskFifoPriorityThreadPoolExecutor.TAG, "task is rejected by:" + executor.toString() + "!", new Object[0]);
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            executor.execute(task);
                        }
                        catch (Throwable e) {
                            MLog.error((Object)YYTaskFifoPriorityThreadPoolExecutor.TAG, "task is rejected retry error:%s" + e.toString() + "!", new Object[0]);
                        }
                    }
                }, 200L);
            }
        };
        return handler;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new LoadTask<T>(runnable, value, this.ordering.getAndIncrement());
    }

    @Override
    public void execute(Runnable command) {
        if (!(command instanceof YYTaskExecutor.ExecutorRunnable)) {
            YYTaskExecutor.execute(command);
            return;
        }
        super.execute(command);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return null;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Future future;
        super.afterExecute(r, t);
        if (t == null && r instanceof Future && (future = (Future)((Object)r)).isDone() && !future.isCancelled()) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
            catch (ExecutionException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
        }
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
        super.allowCoreThreadTimeOut(false);
    }

    private static class MyPriorityBlockingQueue
    extends PriorityBlockingQueue<Runnable> {
        private int poolSize;
        private int maxPoolSize;
        volatile ThreadPoolExecutor mPool;
        private int minSize;

        public MyPriorityBlockingQueue(int minSize, int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            this.minSize = minSize;
        }

        @Override
        public boolean offer(@NonNull Runnable runnable) {
            if (this.isEmpty()) {
                return super.offer(runnable);
            }
            this.poolSize = this.mPool.getPoolSize();
            if (SystemUtils.isShowEnvSetting()) {
                if (this.mPool != null && this.mPool.getActiveCount() < this.poolSize - 2) {
                    return super.offer(runnable);
                }
                if (this.mPool != null && this.poolSize < this.mPool.getMaximumPoolSize() - 2) {
                    return false;
                }
            } else {
                if (this.mPool != null && this.mPool.getActiveCount() < this.poolSize) {
                    return super.offer(runnable);
                }
                if (this.mPool != null && this.poolSize < this.mPool.getMaximumPoolSize() - 2) {
                    return false;
                }
            }
            return super.offer(runnable);
        }
    }

    static class LoadTask<T>
    extends FutureTask<T>
    implements Prioritized,
    Comparable<Prioritized> {
        private final int priority;
        private final int order;

        LoadTask(Runnable runnable, T result, int order) {
            super(runnable, result);
            this.priority = runnable instanceof Prioritized ? ((Prioritized)((Object)runnable)).getPriority() : 10;
            this.order = order;
        }

        public boolean equals(Object o) {
            if (o instanceof LoadTask) {
                LoadTask other = (LoadTask)o;
                return this.order == other.order && this.priority == other.priority;
            }
            return false;
        }

        public int hashCode() {
            int result = this.priority;
            result = 31 * result + this.order;
            return result;
        }

        @Override
        public int compareTo(Prioritized loadTask) {
            int result = loadTask.getPriority() - this.priority;
            if (result == 0 && loadTask instanceof LoadTask) {
                result = this.order - ((LoadTask)loadTask).order;
            }
            return result;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }

    public static enum UncaughtThrowableStrategy {
        IGNORE,
        LOG{

            @Override
            protected void handle(Throwable t) {
                MLog.error((Object)YYTaskFifoPriorityThreadPoolExecutor.TAG, "Request threw uncaught throwable", t, new Object[0]);
            }
        }
        ,
        THROW{

            @Override
            protected void handle(Throwable t) {
                super.handle(t);
                throw new RuntimeException(t);
            }
        };


        protected void handle(Throwable t) {
        }
    }
}

