/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.DefaultThreadFactory;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class YYNormalThreadPoolExecutor
extends ThreadPoolExecutor {
    static final int THREAD_PRIORITY_BACKGROUND = 10;
    static final int THREAD_WORK_PRIORITY = 5;
    private static final String TAG = "YYNormalThreadPoolExecutor";
    private final AtomicInteger ordering = new AtomicInteger();
    private final UncaughtThrowableStrategy uncaughtThrowableStrategy;
    private static final String THREAD_PREFIX = "YYTask";
    private final RejectedExecutionHandler mHandler = null;

    public YYNormalThreadPoolExecutor(int poolSize) {
        this(poolSize, UncaughtThrowableStrategy.LOG);
    }

    public YYNormalThreadPoolExecutor(int poolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        this(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new DefaultThreadFactory(THREAD_PREFIX), uncaughtThrowableStrategy);
    }

    public YYNormalThreadPoolExecutor(int poolSize, int maxPoolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy, String threadTag) {
        this(poolSize, maxPoolSize, 30L, TimeUnit.SECONDS, new DefaultThreadFactory(threadTag), uncaughtThrowableStrategy);
    }

    public YYNormalThreadPoolExecutor(int poolSize, int maxPoolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        this(poolSize, maxPoolSize, 30L, TimeUnit.SECONDS, new DefaultThreadFactory(THREAD_PREFIX), uncaughtThrowableStrategy);
    }

    public YYNormalThreadPoolExecutor(int poolSize, int maxPoolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy, DefaultThreadFactory factory) {
        this(poolSize, maxPoolSize, 30L, TimeUnit.SECONDS, factory, uncaughtThrowableStrategy);
    }

    public YYNormalThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        super(corePoolSize, maximumPoolSize > 1 ? maximumPoolSize + 2 : maximumPoolSize, keepAlive, timeUnit, (BlockingQueue<Runnable>)((Object)(SettingFlags.hasInited() && SettingFlags.getIntValue("threadpool_queue_opt", 1) != 1 ? new MyLinkedBlockingDeque(corePoolSize, maximumPoolSize > 1 ? maximumPoolSize + 2 : maximumPoolSize) : new MyLinkedBlockingQueque(corePoolSize, maximumPoolSize > 1 ? maximumPoolSize + 2 : maximumPoolSize))), threadFactory, YYNormalThreadPoolExecutor.getHandler(corePoolSize, maximumPoolSize));
        if (SettingFlags.hasInited() && SettingFlags.getIntValue("threadpool_queue_opt", 1) != 1) {
            ((MyLinkedBlockingDeque)this.getQueue()).mPool = this;
        } else {
            ((MyLinkedBlockingQueque)this.getQueue()).mPool = this;
        }
        this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
        MLog.warn(TAG, "init corePoolSize:%d, maximumPoolSize:%d", corePoolSize, maximumPoolSize > 1 ? maximumPoolSize + 2 : maximumPoolSize);
    }

    private static RejectedExecutionHandler getHandler(int corePoolSize, int maximumPoolSize) {
        RejectedExecutionHandler handler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(final Runnable task, final ThreadPoolExecutor executor) {
                if (SystemUtils.isShowEnvSetting()) {
                    throw new RuntimeException("task is rejected by:" + executor.toString() + "!");
                }
                MLog.error((Object)YYNormalThreadPoolExecutor.TAG, "task is rejected by:" + executor.toString() + "!", new Object[0]);
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            executor.execute(task);
                        }
                        catch (Throwable e) {
                            MLog.error((Object)YYNormalThreadPoolExecutor.TAG, "task is rejected retry error:%s" + e.toString() + "!", new Object[0]);
                        }
                    }
                }, 200L);
            }
        };
        return handler;
    }

    @Override
    public void execute(Runnable command) {
        super.execute(command);
    }

    @Override
    public void shutdown() {
        MLog.warn(TAG, "shutdown", new Object[0]);
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        MLog.warn(TAG, "shutdownNow", new Object[0]);
        return this.shutdownNow();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        block5: {
            Future future;
            super.afterExecute(r, t);
            if (t == null && r instanceof Future && (future = (Future)((Object)r)).isDone() && !future.isCancelled()) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    if (this.uncaughtThrowableStrategy != null) {
                        this.uncaughtThrowableStrategy.handle(e);
                    }
                }
                catch (ExecutionException e) {
                    if (this.uncaughtThrowableStrategy == null) break block5;
                    this.uncaughtThrowableStrategy.handle(e);
                }
            }
        }
    }

    @Override
    public String toString() {
        String str = super.toString();
        return str + "[maxPoolSize:" + this.getMaximumPoolSize() + ",isTerminating:" + this.isTerminating() + ",isShownDown:" + (this.isShutdown() || this.isTerminating()) + "]";
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
        super.allowCoreThreadTimeOut(value);
    }

    static class MyLinkedBlockingQueque
    extends LinkedBlockingQueue<Runnable> {
        private int poolSize;
        private int maxPoolSize;
        volatile ThreadPoolExecutor mPool;

        public MyLinkedBlockingQueque(int poolSize, int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            this.poolSize = poolSize;
        }

        @Override
        public synchronized boolean offer(@NonNull Runnable runnable) {
            if (this.isEmpty()) {
                return super.offer(runnable);
            }
            this.poolSize = this.mPool.getPoolSize();
            if (SystemUtils.isShowEnvSetting()) {
                if (this.mPool != null && this.mPool.getActiveCount() < this.poolSize - 2) {
                    return super.offer(runnable);
                }
                if (this.mPool != null && this.mPool.getPoolSize() < this.mPool.getMaximumPoolSize() - 2) {
                    return false;
                }
            } else {
                if (this.mPool != null && this.mPool.getActiveCount() < this.poolSize) {
                    return super.offer(runnable);
                }
                if (this.mPool != null && this.mPool.getPoolSize() < this.mPool.getMaximumPoolSize() - 2) {
                    return false;
                }
            }
            return super.offer(runnable);
        }
    }

    static class MyLinkedBlockingDeque
    extends LinkedBlockingDeque<Runnable> {
        private int poolSize;
        private int maxPoolSize;
        volatile ThreadPoolExecutor mPool;

        public MyLinkedBlockingDeque(int poolSize, int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            this.poolSize = poolSize;
        }

        @Override
        public synchronized boolean offer(@NonNull Runnable runnable) {
            if (this.isEmpty()) {
                return super.offer(runnable);
            }
            this.poolSize = this.mPool.getPoolSize();
            if (this.mPool != null && this.mPool.getActiveCount() < this.poolSize) {
                return super.offer(runnable);
            }
            if (this.mPool != null && this.mPool.getPoolSize() < this.mPool.getMaximumPoolSize() - 2) {
                return false;
            }
            return super.offer(runnable);
        }
    }

    public static enum UncaughtThrowableStrategy {
        IGNORE,
        LOG{

            @Override
            protected void handle(Throwable t) {
                MLog.error((Object)YYNormalThreadPoolExecutor.TAG, "Request threw uncaught throwable", t, new Object[0]);
            }
        }
        ,
        THROW{

            @Override
            protected void handle(Throwable t) {
                super.handle(t);
                throw new RuntimeException(t);
            }
        };


        protected void handle(Throwable t) {
        }
    }
}

