/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.DefaultThreadFactory;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class YYNormalScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final String TAG = "YYNormalScheduledPool";
    private final UncaughtThrowableStrategy uncaughtThrowableStrategy;

    public YYNormalScheduledThreadPoolExecutor(int poolSize) {
        this(poolSize, UncaughtThrowableStrategy.LOG, "YYNormalScheduled");
    }

    public YYNormalScheduledThreadPoolExecutor(int poolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy, String threadTag) {
        this(poolSize, 20L, TimeUnit.SECONDS, new DefaultThreadFactory(threadTag), uncaughtThrowableStrategy);
    }

    public YYNormalScheduledThreadPoolExecutor(int corePoolSize, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        super(corePoolSize, threadFactory, YYNormalScheduledThreadPoolExecutor.getHandler(corePoolSize));
        this.setKeepAliveTime(keepAlive, timeUnit);
        this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
    }

    private static RejectedExecutionHandler getHandler(int corePoolSize) {
        RejectedExecutionHandler handler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(final Runnable task, final ThreadPoolExecutor executor) {
                if (SystemUtils.isShowEnvSetting()) {
                    throw new RuntimeException("task is rejected by:" + executor.toString() + "!");
                }
                MLog.error((Object)YYNormalScheduledThreadPoolExecutor.TAG, "task is rejected by:" + executor.toString() + "!", new Object[0]);
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            executor.execute(task);
                        }
                        catch (Throwable e) {
                            MLog.error((Object)YYNormalScheduledThreadPoolExecutor.TAG, "task is rejected retry error:%s" + e.toString() + "!", new Object[0]);
                        }
                    }
                }, 200L);
            }
        };
        return handler;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return super.newTaskFor(runnable, value);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(command);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return new ArrayList<Runnable>();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Future future;
        super.afterExecute(r, t);
        if (t == null && r instanceof Future && (future = (Future)((Object)r)).isDone() && !future.isCancelled()) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
            catch (ExecutionException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
        }
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
        super.allowCoreThreadTimeOut(false);
    }

    public static enum UncaughtThrowableStrategy {
        IGNORE,
        LOG{

            @Override
            protected void handle(Throwable t) {
                MLog.error((Object)YYNormalScheduledThreadPoolExecutor.TAG, "Request threw uncaught throwable", t, new Object[0]);
            }
        }
        ,
        THROW{

            @Override
            protected void handle(Throwable t) {
                super.handle(t);
                throw new RuntimeException(t);
            }
        };


        protected void handle(Throwable t) {
        }
    }
}

