/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.taskexecutor.IPollExecutor;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import java.lang.ref.WeakReference;

public class PollExecutor
implements IPollExecutor,
IRecycleView.IRecycleViewCallback {
    private IPollExecutor.ICallback callback;
    private Runnable command;
    private int poolMillTime;
    private boolean runInMainThread;
    private int maxPoolTimes = Integer.MAX_VALUE;
    private boolean isStoped;
    private boolean isPaused;
    private boolean isExecuting;
    private int curPoolTimes = 0;
    private WeakReference<IRecycleView> bindView = null;
    private IQueueTaskExecutor queueTaskExecutor = null;
    private Runnable executeRunnalbe = null;
    private String logTag = null;
    private String tag = "";

    public PollExecutor(Runnable pollRunnable, int poolMillTime, boolean runInMainThread) {
        this.command = pollRunnable;
        this.poolMillTime = poolMillTime;
        this.runInMainThread = runInMainThread;
        this.watchOutPoolTime(poolMillTime);
    }

    @Override
    public synchronized void setCallback(IPollExecutor.ICallback callback) {
        this.callback = callback;
        this.log("setCallback:%s!", callback);
    }

    @Override
    public void setTag(String tag) {
        if (StringUtils.isNotEmpty(tag)) {
            this.tag = tag;
            this.logTag = "PollExecutor_" + tag;
        }
    }

    @Override
    public synchronized void bindLifecycle(IRecycleView withView) {
        IRecycleView lastView;
        this.log("bindLifecycle:%s!", withView);
        if (withView == null) {
            return;
        }
        IRecycleView iRecycleView = lastView = this.bindView != null ? (IRecycleView)this.bindView.get() : null;
        if (lastView != null) {
            lastView.removeListener(this);
        }
        this.bindView = new WeakReference<IRecycleView>(withView);
        withView.addListener(this);
    }

    @Override
    public synchronized void unbindLifecycle(IRecycleView withView) {
        if (this.bindView == null) {
            this.log("unbindLifecycle:%s, bindview:null!", withView);
            return;
        }
        IRecycleView lastView = (IRecycleView)this.bindView.get();
        this.log("unbindLifecycle:%s, bindview:%s!", withView, lastView != null ? lastView : "");
        if (lastView == withView) {
            lastView.removeListener(this);
            this.bindView = null;
            this.isPaused = false;
            if (this.isPaused) {
                this.isPaused = false;
                this.resume(false);
            }
        } else if (lastView != null) {
            this.log("bindview is %s, not %s", lastView, withView);
        }
    }

    @Override
    public synchronized void setMaxPollTimes(int times) {
        if (times <= 0 && SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException("why max pool times <= 0!");
        }
        this.maxPoolTimes = times;
        this.log("setMaxPollTimes:%d!", times);
    }

    @Override
    public synchronized void resetCurPollTimes() {
        this.curPoolTimes = 0;
        this.log("resetCurPollTimes!", new Object[0]);
        if (!(this.isStoped || this.isPaused || this.bindView != null && this.bindView.get() == null)) {
            this.resume(false);
        }
    }

    @Override
    public synchronized void updatePoolTime(int millTime) {
        this.watchOutPoolTime(millTime);
        this.poolMillTime = millTime;
        this.log("updatePoolTime poolMillTime:%d!", millTime);
    }

    @Override
    public synchronized void executeOnceNow() {
        this.log("executeOnceNow!", new Object[0]);
        this.executeOnce(0);
    }

    @Override
    public synchronized void start() {
        this.log("start poolMillTime:%d, runInMainThread:%b!", this.poolMillTime, this.runInMainThread);
        this.isStoped = false;
        this.resume(true);
    }

    @Override
    public synchronized void stop() {
        this.log("stop!", new Object[0]);
        this.isStoped = true;
        this.pause(true);
    }

    private synchronized void executeOnce(int delay) {
        if (this.isExecuting) {
            this.log("executeOnce return by isExecuting!", new Object[0]);
            return;
        }
        this.isExecuting = true;
        if (this.executeRunnalbe == null) {
            this.executeRunnalbe = new Runnable(){

                @Override
                public void run() {
                    PollExecutor.this.executeCommand();
                }
            };
        } else if (this.runInMainThread) {
            YYTaskExecutor.removeRunnableFromMainThread(this.executeRunnalbe);
        } else if (this.queueTaskExecutor != null) {
            this.queueTaskExecutor.removeTask(this.executeRunnalbe);
        }
        if (this.runInMainThread) {
            if (YYTaskExecutor.isMainThread() && delay == 0) {
                this.executeRunnalbe.run();
            } else {
                YYTaskExecutor.postToMainThread(this.executeRunnalbe, delay);
            }
        } else {
            if (this.queueTaskExecutor == null) {
                this.queueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
            }
            this.queueTaskExecutor.execute(this.executeRunnalbe, delay);
        }
    }

    private synchronized void executeCommand() {
        IRecycleView recycleView;
        this.isExecuting = false;
        if (this.isStoped || this.isPaused || this.bindView != null && this.bindView.get() == null) {
            this.log("executeCommand return, by isPaused:%b, isStoped:%b", this.isPaused, this.isStoped);
            return;
        }
        if (this.curPoolTimes >= this.maxPoolTimes) {
            this.log("executeCommand return, by curTimes:%d, maxTimes:%d!", this.curPoolTimes, this.maxPoolTimes);
            return;
        }
        if (this.bindView != null && (recycleView = (IRecycleView)this.bindView.get()) != null && (recycleView.isWindowInVisible() || !recycleView.isAttachToWindow())) {
            this.log("executeCommand return, by recycleView isAttachToWindow:%b", recycleView.isAttachToWindow());
            if (this.poolMillTime > 0 && this.curPoolTimes < this.maxPoolTimes) {
                this.executeOnce(this.poolMillTime);
            }
            return;
        }
        if (this.callback != null) {
            this.callback.beforeExecute();
        }
        this.command.run();
        ++this.curPoolTimes;
        this.log("executeCommand once, curTimes:%d!", this.curPoolTimes);
        if (this.callback != null) {
            this.callback.onExecute(this.curPoolTimes);
        }
        if (this.callback != null && this.curPoolTimes == this.maxPoolTimes) {
            this.callback.onEnd(this.curPoolTimes);
        }
        if (this.poolMillTime > 0 && this.curPoolTimes < this.maxPoolTimes) {
            this.executeOnce(this.poolMillTime);
        }
    }

    private synchronized void pause(boolean byStop) {
        this.log("pause byStop:%b, isPaused:%b, isStoped:%b", byStop, this.isPaused, this.isStoped);
        if (!byStop && (this.isPaused || this.isStoped)) {
            return;
        }
        this.log("paused!", new Object[0]);
        this.isExecuting = false;
        this.isPaused = !byStop;
        if (this.executeRunnalbe != null) {
            if (this.runInMainThread) {
                YYTaskExecutor.removeRunnableFromMainThread(this.executeRunnalbe);
            } else if (this.queueTaskExecutor != null) {
                this.queueTaskExecutor.removeTask(this.executeRunnalbe);
            }
        }
        if (this.isPaused && this.callback != null && this.executeRunnalbe != null) {
            if (this.runInMainThread) {
                if (YYTaskExecutor.isMainThread()) {
                    this.callback.onPause();
                } else {
                    YYTaskExecutor.postToMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (PollExecutor.this.isPaused && PollExecutor.this.callback != null) {
                                PollExecutor.this.callback.onPause();
                            }
                        }
                    });
                }
            } else {
                if (this.queueTaskExecutor == null) {
                    this.queueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
                }
                this.queueTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (PollExecutor.this.isPaused && PollExecutor.this.callback != null) {
                            PollExecutor.this.callback.onPause();
                        }
                    }
                }, 0L);
            }
        }
    }

    private synchronized void resume(boolean byStart) {
        this.log("resume byStart:%b, isPaused:%b, isStoped:%b", byStart, this.isPaused, this.isStoped);
        if (!(byStart || this.isPaused && !this.isStoped)) {
            return;
        }
        this.log("resumed!", new Object[0]);
        this.isPaused = false;
        if (this.poolMillTime > 0 && this.curPoolTimes < this.maxPoolTimes) {
            this.executeOnce(this.poolMillTime);
        }
        if (!this.isPaused && this.callback != null && this.executeRunnalbe != null) {
            if (this.runInMainThread) {
                if (YYTaskExecutor.isMainThread()) {
                    this.callback.onPause();
                } else {
                    YYTaskExecutor.postToMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!PollExecutor.this.isPaused && !PollExecutor.this.isStoped && PollExecutor.this.callback != null) {
                                PollExecutor.this.callback.onResume();
                            }
                        }
                    });
                }
            } else {
                if (this.queueTaskExecutor == null) {
                    this.queueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
                }
                this.queueTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!PollExecutor.this.isPaused && !PollExecutor.this.isStoped && PollExecutor.this.callback != null) {
                            PollExecutor.this.callback.onResume();
                        }
                    }
                }, 0L);
            }
        }
    }

    private void watchOutPoolTime(int millTime) {
        if (SystemUtils.isShowEnvSetting()) {
            if (millTime <= 0) {
                throw new RuntimeException("why pool millTime <= 0!");
            }
            if (millTime <= 100) {
                MLog.warn("Watch out: \u8bf7\u786e\u8ba4PoolTime \u4e3a" + millTime + " \u8fd9\u4e48\u5c0f\u662f\u5426\u5408\u7406\uff1f\n", new RuntimeException("").toString(), new Object[0]);
            }
        }
    }

    private void log(String format, Object ... args) {
        if (!SystemUtils.isShowEnvSetting()) {
            return;
        }
        if (this.logTag == null) {
            this.logTag = StringUtils.isEmpty(this.tag) ? "PollExecutor_" + this.command.toString() : "PollExecutor_" + this.tag;
        }
        MLog.info(this.logTag, format, args);
    }

    @Override
    public void onViewVisible(IRecycleView view) {
        this.resume(false);
    }

    @Override
    public void onViewInvisible(IRecycleView view) {
        this.pause(false);
    }
}

