/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.sword;

import android.content.Context;
import android.content.res.AssetManager;
import android.view.ViewGroup;
import com.duowan.sword.Sword;
import com.duowan.sword.plugin.Logger;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.sword.SwordHelper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DontProguardClass
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007J\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\fH\u0007J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0001H\u0007J*\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0007J\b\u0010 \u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/yy/base/sword/SwordHelper;", "", "()V", "APM_FILE_NAME", "", "FLAG_CLOUD_CONFIG_VALID", "GB_IN_BYTES", "", "KB_IN_BYTES", "MB_IN_BYTES", "TAG", "checkViewLevelAndOverDraw", "", "page", "Landroid/view/ViewGroup;", "pageName", "destroy", "detachViewLevelAndOverDraw", "extendLife", "filePath", "getCloudFileContent", "context", "Landroid/content/Context;", "getConfigFromAsset", "install", "leakWatch", "obj", "onFileOperate", "type", "", "size", "costTime", "setCloudConfig", "FileOptFlag", "framework-base_debug"})
public final class SwordHelper {
    private static final String TAG = "SwordHelper";
    @NotNull
    public static final String FLAG_CLOUD_CONFIG_VALID = "SwordConfigValid";
    @NotNull
    public static final String APM_FILE_NAME = "sword_apm_config.json";
    private static final long KB_IN_BYTES = 1024L;
    private static final long MB_IN_BYTES = 0x100000L;
    private static final long GB_IN_BYTES = 0x40000000L;
    public static final SwordHelper INSTANCE;

    @JvmStatic
    public static final void leakWatch(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        try {
            if (!RuntimeContext.sIsDebuggable) {
                return;
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "leakWatch error", e, new Object[0]);
        }
    }

    @JvmStatic
    public static final void install() {
        Sword.INSTANCE.setLog(new Logger(){

            public void v(@Nullable String tag, @Nullable String format, Object ... params) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                MLog.verbose(tag, format, Arrays.copyOf(params, params.length));
            }

            public void i(@Nullable String tag, @Nullable String format, Object ... params) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                MLog.info(tag, format, Arrays.copyOf(params, params.length));
            }

            public void w(@Nullable String tag, @Nullable String format, Object ... params) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                MLog.warn(tag, format, Arrays.copyOf(params, params.length));
            }

            public void d(@Nullable String tag, @Nullable String format, Object ... params) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                MLog.debug(tag, format, Arrays.copyOf(params, params.length));
            }

            public void e(@Nullable String tag, @Nullable String format, Object ... params) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                MLog.error((Object)tag, format, Arrays.copyOf(params, params.length));
            }

            public void printErrStackTrace(@Nullable String tag, @Nullable Throwable tr, @Nullable String format, Object ... params) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                MLog.error((Object)tag, format, tr, Arrays.copyOf(params, params.length));
            }
        });
        INSTANCE.setCloudConfig();
    }

    private final void setCloudConfig() {
        YYTaskExecutor.execute(setCloudConfig.1.INSTANCE);
    }

    @JvmStatic
    public static final void destroy() {
        try {
            Sword.INSTANCE.close();
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "destroy error", e, new Object[0]);
        }
    }

    private final String getCloudFileContent(Context context) {
        String config = null;
        if (RuntimeContext.isLocalBuild()) {
            MLog.info(TAG, "get config from asset!", new Object[0]);
            config = this.getConfigFromAsset(context);
        } else if (SettingFlags.getBoolean(FLAG_CLOUD_CONFIG_VALID, false)) {
            MLog.info(TAG, "get config from inner file!", new Object[0]);
            config = FileStorageUtils.getInstance().getStrFromFile(true, APM_FILE_NAME);
        }
        return config;
    }

    private final String getConfigFromAsset(Context context) {
        String config = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            AssetManager assetManager = context.getAssets();
            BufferedReader bf = new BufferedReader(new InputStreamReader(assetManager.open(APM_FILE_NAME)));
            Ref.ObjectRef line = new Ref.ObjectRef();
            while (true) {
                String string2 = bf.readLine();
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                line.element = it;
                if (string2 != null) {
                    stringBuilder.append((String)line.element);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"stringBuilder.toString()");
        config = string3;
        return config;
    }

    @JvmStatic
    public static final void onFileOperate(int type, @Nullable String filePath, long size, long costTime) {
    }

    public final void extendLife(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
    }

    @JvmStatic
    public static final void checkViewLevelAndOverDraw(@Nullable ViewGroup page, @Nullable String pageName) {
        if (!RuntimeContext.sIsDebuggable) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.yy.perfcat.view.ViewCanary");
            Method method = clazz.getMethod("inspectView", ViewGroup.class, String.class);
            method.invoke(null, page, pageName);
            MLog.debug(TAG, "checkViewLevelAndOverDraw", new Object[0]);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, e.getMessage(), new Object[0]);
        }
    }

    @JvmStatic
    public static final void detachViewLevelAndOverDraw(@Nullable ViewGroup page) {
        if (!RuntimeContext.sIsDebuggable) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.yy.perfcat.view.ViewCanary");
            Method method = clazz.getMethod("detachView", ViewGroup.class);
            method.invoke(null, page);
            MLog.debug(TAG, "detachViewLevelAndOverDraw", new Object[0]);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, e.getMessage(), new Object[0]);
        }
    }

    private SwordHelper() {
    }

    static {
        SwordHelper swordHelper;
        INSTANCE = swordHelper = new SwordHelper();
    }

    public static final /* synthetic */ String access$getCloudFileContent(SwordHelper $this, Context context) {
        return $this.getCloudFileContent(context);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/yy/base/sword/SwordHelper$FileOptFlag;", "", "()V", "FILE_COPY", "", "FILE_MD5", "FILE_READ", "FILE_UNZIP", "FILE_WRITE", "framework-base_debug"})
    public static final class FileOptFlag {
        public static final int FILE_COPY = 1;
        public static final int FILE_READ = 2;
        public static final int FILE_WRITE = 3;
        public static final int FILE_MD5 = 4;
        public static final int FILE_UNZIP = 5;
        public static final FileOptFlag INSTANCE;

        private FileOptFlag() {
        }

        static {
            FileOptFlag fileOptFlag;
            INSTANCE = fileOptFlag = new FileOptFlag();
        }
    }
}

