/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.websocket.ws;

import androidx.annotation.Nullable;
import com.yy.base.okhttp.websocket.ws.WsStat;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.Response;
import com.yy.grace.WebSocket;
import com.yy.grace.WebSocketListener;
import okio.ByteString;

class StatWebSocketListener
extends WebSocketListener {
    static String sErrorMsg = "";
    private WebSocketListener mWebSocketListener;
    private WebSocketRequestInfo mWebSocketRequestInfo;
    private boolean mOpen = false;
    private long mStartConnectionTime = System.currentTimeMillis();

    public StatWebSocketListener(WebSocketListener webSocketListener, WebSocketRequestInfo webSocketRequestInfo) {
        if (webSocketListener == null) {
            throw new RuntimeException("WebSocketListener is null");
        }
        if (webSocketRequestInfo == null) {
            throw new RuntimeException("webSocketRequestInfo is null");
        }
        this.mWebSocketListener = webSocketListener;
        this.mWebSocketRequestInfo = webSocketRequestInfo;
    }

    public void onOpen(WebSocket webSocket, Response response, String remoteIp) {
        long connectTimestampId = this.mWebSocketRequestInfo.connectTimestampId();
        int connectTimes = this.mWebSocketRequestInfo.connectTimes();
        this.mWebSocketRequestInfo.onOpen();
        this.mOpen = true;
        sErrorMsg = "";
        long useTime = System.currentTimeMillis() - this.mStartConnectionTime;
        this.mWebSocketListener.onOpen(webSocket, response, remoteIp);
        WsStat.statWsOpenSucess(connectTimes, useTime, 0, this.mWebSocketRequestInfo.isFirstConnect(), connectTimestampId);
    }

    public void onMessage(WebSocket webSocket, String text) {
        sErrorMsg = "";
        this.mWebSocketListener.onMessage(webSocket, text);
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        sErrorMsg = "";
        this.mWebSocketListener.onMessage(webSocket, bytes);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        sErrorMsg = "";
        long useTime = this.useTime();
        this.mWebSocketListener.onClosing(webSocket, code, reason);
        WsStat.statWsFail(this.mOpen, this.mWebSocketRequestInfo.isFirstConnect(), this.mWebSocketRequestInfo.connectTimes(), useTime, 0, "" + reason, code, this.mWebSocketRequestInfo.connectTimestampId());
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        sErrorMsg = "";
        this.mWebSocketListener.onClosed(webSocket, code, reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
        String errorMsg;
        sErrorMsg = errorMsg = t != null ? t.toString() : "";
        long useTime = this.useTime();
        this.mWebSocketListener.onFailure(webSocket, t, response);
        WsStat.statWsFail(this.mOpen, this.mWebSocketRequestInfo.isFirstConnect(), this.mWebSocketRequestInfo.connectTimes(), useTime, 0, errorMsg, NetworkUtils.getErrorCodeByExc(t), this.mWebSocketRequestInfo.connectTimestampId());
    }

    private long useTime() {
        return System.currentTimeMillis() - this.mStartConnectionTime;
    }

    public static interface WebSocketRequestInfo {
        public int connectTimes();

        public void onOpen();

        public boolean isFirstConnect();

        public long connectTimestampId();
    }
}

