/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.websocket.ws;

import com.yy.base.okhttp.GraceWrapper;
import com.yy.base.okhttp.websocket.ws.StatWebSocketListener;
import com.yy.grace.Grace;
import com.yy.grace.Request;
import com.yy.grace.WebSocket;
import com.yy.grace.WebSocketListener;
import com.yy.grace.networkinterceptor.BizScenc;
import java.util.concurrent.TimeUnit;

public class OkHttpWsClientWrap
implements WebSocket.Factory,
StatWebSocketListener.WebSocketRequestInfo {
    private volatile int mNewWebSocketTimes = 0;
    private volatile int mPreWebSocketTimes = 0;
    private volatile int mOpenTimes = 0;
    private volatile long mTimestamp = System.currentTimeMillis();
    private volatile boolean isUseCommonState = true;
    private final Grace mGrace;
    private int mMaxRequestsPerHost = 0;

    private OkHttpWsClientWrap(Builder build) {
        this.mGrace = GraceWrapper.getGrace().newBuilder().connectTimeout(build.connectTimeout, build.connectTimeoutTimeUnit).pingInterval(build.pingTimeUnit.toMillis(build.pingInterval)).connectionPool(1, 3600L, TimeUnit.SECONDS).build();
        this.mMaxRequestsPerHost = 1;
    }

    public OkHttpWsClientWrap(Grace grace) {
        this.mGrace = grace;
    }

    public WebSocket newWebSocket(Request request, WebSocketListener listener) {
        ++this.mNewWebSocketTimes;
        this.mPreWebSocketTimes = this.mNewWebSocketTimes;
        WebSocketListener webSocketListener = this.isUseCommonState ? new StatWebSocketListener(listener, this) : listener;
        Request.Builder newRequest = request.newBuilder().group((Request.Group)BizScenc.WEB_SOCKET);
        if (this.mMaxRequestsPerHost > 0) {
            newRequest.maxRequestPerHost(this.mMaxRequestsPerHost);
        }
        return this.mGrace.newWebSocket(newRequest.build(), webSocketListener);
    }

    @Override
    public int connectTimes() {
        return this.mPreWebSocketTimes;
    }

    @Override
    public void onOpen() {
        ++this.mOpenTimes;
        this.mNewWebSocketTimes = 0;
        this.mTimestamp = System.currentTimeMillis();
    }

    @Override
    public boolean isFirstConnect() {
        return this.mOpenTimes == 0 || this.mOpenTimes == 1;
    }

    @Override
    public long connectTimestampId() {
        return this.mTimestamp;
    }

    public void setUseCommonState(boolean useCommonState) {
        this.isUseCommonState = useCommonState;
    }

    public static class Builder {
        private long connectTimeout = 10000L;
        private TimeUnit connectTimeoutTimeUnit = TimeUnit.MILLISECONDS;
        private long pingInterval = 0L;
        private TimeUnit pingTimeUnit = TimeUnit.MILLISECONDS;

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = timeout;
            this.connectTimeoutTimeUnit = unit;
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = interval;
            this.pingTimeUnit = unit;
            return this;
        }

        public OkHttpWsClientWrap build() {
            return new OkHttpWsClientWrap(this);
        }
    }
}

