/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp;

import android.net.NetworkInfo;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.dynamicswitch.DynamicSwitchFactory;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.DefaultThreadFactory;
import com.yy.base.taskexecutor.YYNormalThreadPoolExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkChangeListener;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Converter;
import com.yy.grace.Dns;
import com.yy.grace.Grace;
import com.yy.grace.ILog;
import com.yy.grace.MediaType;
import com.yy.grace.MultipartBody;
import com.yy.grace.NetworkConverter;
import com.yy.grace.NetworkDispatcher;
import com.yy.grace.Request;
import com.yy.grace.RequestBody;
import com.yy.grace.RequestEventListener;
import com.yy.grace.RequestInterceptor;
import com.yy.grace.Response;
import com.yy.grace.ResponseBody;
import com.yy.grace.RetryEventListener;
import com.yy.grace.StatEventListener;
import com.yy.grace.converter.file.FileCallback;
import com.yy.grace.converter.file.FileConverterFactory;
import com.yy.grace.converter.gson.GsonBodyConverterFactory;
import com.yy.grace.network.DefaultNetworkFactory;
import com.yy.grace.network.cronet.NetworkCronet;
import com.yy.grace.network.okhttp.NetworkOkHttp;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.grace.networkinterceptor.DefaultNetworkDispatcher;
import com.yy.grace.networkinterceptor.NetConfigParse;
import com.yy.grace.singlerequest.metric.UniqueRequestMetric;
import com.yy.grace.strategy.DefaultRetryStrategy;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class GraceWrapper {
    private static final String TAG = "GraceWrapper";
    public static final String TEXT_PLAIN_CHARSET_UTF_8 = "text/plain;charset=utf-8";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=utf-8";
    public static final String APPLICATION_PROTO = "application/proto";
    private static volatile Grace sGrace;
    private static volatile GraceWrapperDelegate graceWrapperDelegate;
    private static volatile String sGraceGetPrematureLog;
    private static volatile boolean isInMainProcess;
    public static boolean executorAbTestMatchB;
    private static volatile ExecutorService executorService;

    public static NetworkCronet cronetNetwork(@NonNull Grace grace) {
        NetworkConverter.Network network = grace.findNetwork("cronet");
        return (NetworkCronet)network;
    }

    public static NetworkOkHttp okhttpNetwork(@NonNull Grace grace) {
        NetworkConverter.Network network = grace.findNetwork("okhttp");
        return (NetworkOkHttp)network;
    }

    public static OkHttpClient getLegacyClient(@NonNull Grace grace) {
        NetworkOkHttp networkOkHttp = GraceWrapper.okhttpNetwork(grace);
        NetworkOkHttp.NetworkOkHttpBuilder builder = networkOkHttp.newNetwork();
        if (graceWrapperDelegate != null) {
            builder.interceptor((Interceptor)graceWrapperDelegate.getGraceInterceptor());
        }
        return builder.build(grace).getOkHttpClient();
    }

    public static Request.Builder<String> postForString(String url, @Nullable Map<String, String> params, @Nullable Map<String, String> header) {
        return new Request.Builder<String>(){}.url(url).addHeader(header).method("POST", (Object)(params == null ? new HashMap() : params));
    }

    public static ExecutorService newExecutorService() {
        boolean executorAbTestMatchB = SettingFlags.getBoolean("GRACE_EXECUTOR_MATCH_B", false);
        if (executorAbTestMatchB) {
            int corePoolSize = RuntimeContext.getPhoneType() == 1 ? SettingFlags.getIntValue("grace_thread_pool_max_thread_low", 32) : SettingFlags.getIntValue("grace_thread_pool_max_thread", 64);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "Grace"));
            executor.allowCoreThreadTimeOut(true);
            return executor;
        }
        YYNormalThreadPoolExecutor.UncaughtThrowableStrategy strategy = RuntimeContext.sIsDebuggable ? YYNormalThreadPoolExecutor.UncaughtThrowableStrategy.THROW : YYNormalThreadPoolExecutor.UncaughtThrowableStrategy.LOG;
        int minSize = HardwareUtils.getCpuCoreCount() * 2;
        int maxSize = RuntimeContext.getPhoneType() == 1 ? SettingFlags.getIntValue("okhttp_dispatcher_max_thread", 20) : 32;
        if (maxSize <= minSize) {
            maxSize = minSize + 1;
        }
        return new YYNormalThreadPoolExecutor(minSize, maxSize, 30L, TimeUnit.SECONDS, new DefaultThreadFactory("Grace"), strategy);
    }

    public static void setGraceWrapperDelegate(GraceWrapperDelegate delegate) {
        graceWrapperDelegate = delegate;
        String logMsg = sGraceGetPrematureLog;
        if (logMsg != null) {
            delegate.reportGraceGetPrematureLog(logMsg, isInMainProcess);
            sGraceGetPrematureLog = null;
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("\u8c03\u7528getGrace\u592a\u65e9\u4e86\uff0c\u8bf7\u67e5\u770b\u539f\u56e0");
            }
        }
    }

    public static void setNetworkConfigListener(NetConfigParse.OnParseNetConfig onParseNetConfig) {
        NetConfigParse.setOnParseNetConfig((NetConfigParse.OnParseNetConfig)onParseNetConfig);
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static String getGraceExecutorInfo() {
        if (executorService == null) {
            return "";
        }
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
        int activeCount = threadPoolExecutor.getActiveCount();
        long taskCount = threadPoolExecutor.getTaskCount();
        int queueSize = threadPoolExecutor.getQueue().size();
        int poolSize = threadPoolExecutor.getPoolSize();
        int maxPoolSize = threadPoolExecutor.getMaximumPoolSize();
        long completedTaskCount = threadPoolExecutor.getCompletedTaskCount();
        return "[activeCount:" + activeCount + "; taskCount:" + taskCount + "; queueSize:" + queueSize + "; completedTaskCount:" + completedTaskCount + "; poolSize: " + poolSize + "; maxPoolSize: " + maxPoolSize + "; executorExp = " + executorAbTestMatchB + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Grace getGrace() {
        if (sGrace != null) return sGrace;
        Class<GraceWrapper> clazz = GraceWrapper.class;
        synchronized (GraceWrapper.class) {
            if (sGrace != null) return sGrace;
            executorService = GraceWrapper.newExecutorService();
            MLog.debug(TAG, "getGrace", new Object[0]);
            Grace.Builder builder = new Grace.Builder(RuntimeContext.sApplicationContext).addConverterFactory((Converter.Factory)new FileConverterFactory()).addConverterFactory((Converter.Factory)new GsonBodyConverterFactory(JsonParser.getGson())).addNetworkFactory((NetworkConverter.Factory)new DefaultNetworkFactory()).setNetworkDispatcher((NetworkDispatcher)new DefaultNetworkDispatcher()).debug(RuntimeContext.sIsDebuggable).enableCronetTimeout(SettingFlags.getBoolean("grace_cronet_timeout_enable", true)).executor(executorService).setRetryStrategy((com.yy.grace.RetryStrategy)new RetryStrategy()).disableHttp2(TargetBuildConstant.enableHttp2 == 2).trustAllCert(DynamicSwitchFactory.getIDynamicSwitch().enableTrustAllCert()).dns(GraceWrapper.getGraceDns()).addRequestInterceptor(GraceWrapper.getRequestInterceptor()).log(GraceWrapper.getGraceLog()).onRequestEvent(GraceWrapper.getGraceRequestEvent()).onRetryEvent(GraceWrapper.getGraceRetryEvent()).onStatEvent(GraceWrapper.getGraceStatEvent()).uniqueRequestMetric(GraceWrapper.getUniqueRequestMetric());
            sGrace = builder.build();
            if (graceWrapperDelegate == null) {
                sGraceGetPrematureLog = Log.getStackTraceString((Throwable)new Exception("getGrace too early"));
                isInMainProcess = RuntimeContext.sIsMainProcess;
            }
            GraceWrapper.listenNetworkChanged();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sGrace;
        }
    }

    private static UniqueRequestMetric getUniqueRequestMetric() {
        return new UniqueRequestMetric(){

            public void onJoinSingleRequestQueue(@NonNull Request<?> request) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getUniqueRequestMetric().onJoinSingleRequestQueue(request);
                }
            }

            public void errorCallback(@NonNull Request<?> request, @Nullable Throwable throwable) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getUniqueRequestMetric().errorCallback(request, throwable);
                }
            }

            public void onRequestSuccess(@NonNull Request<?> request) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getUniqueRequestMetric().onRequestSuccess(request);
                }
            }

            public void onMainRequestThrowException(@NonNull Request<?> request, @Nullable Throwable throwable) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getUniqueRequestMetric().onMainRequestThrowException(request, throwable);
                }
            }

            public void onMainRequestCopyDataError(@Nullable Throwable throwable) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getUniqueRequestMetric().onMainRequestCopyDataError(throwable);
                }
            }

            public void onByte2File(int i, @NonNull String s) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getUniqueRequestMetric().onByte2File(i, s);
                }
            }
        };
    }

    private static StatEventListener getGraceStatEvent() {
        return new StatEventListener(){

            public void stat(HashMap<String, String> hashMap, String s) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getStatEventListener().stat(hashMap, s);
                }
            }

            public boolean isSwitchOn() {
                if (graceWrapperDelegate != null) {
                    return graceWrapperDelegate.getStatEventListener().isSwitchOn();
                }
                return false;
            }
        };
    }

    private static RetryEventListener getGraceRetryEvent() {
        return new RetryEventListener(){

            public void onRetrySuccess(String s) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getRetryEventListener().onRetrySuccess(s);
                }
            }

            public void onRetryError(String s, Exception e) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getRetryEventListener().onRetryError(s, e);
                }
            }

            public void onBackupUrlError(String s, Exception e) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getRetryEventListener().onBackupUrlError(s, e);
                }
            }
        };
    }

    private static RequestEventListener getGraceRequestEvent() {
        return new RequestEventListener(){

            public void onStart(Request.Group group, int i, String s, String s1, Map<String, String> map) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getRequestEventListener().onStart(group, i, s, s1, map);
                }
            }

            public void onCancel(Request.Group group, int i, String s, String s1, Map<String, String> map) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getRequestEventListener().onCancel(group, i, s, s1, map);
                }
            }

            public void onFailure(Request.Group group, int i, String s, String s1, Throwable throwable, Map<String, String> map) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getRequestEventListener().onFailure(group, i, s, s1, throwable, map);
                }
            }

            public void onResponse(Request.Group group, int i, String s, String s1, long l, Map<String, String> map) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getRequestEventListener().onResponse(group, i, s, s1, l, map);
                }
            }
        };
    }

    private static ILog getGraceLog() {
        return new ILog(){

            public void i(Object o, String s, Object ... objects) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getLog().i(o, s, objects);
                }
            }

            public void d(Object o, String s, Object ... objects) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getLog().d(o, s, objects);
                }
            }

            public void e(Object o, String s, Object ... objects) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getLog().e(o, s, objects);
                }
            }

            public void i(Object o, String s) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getLog().i(o, s);
                }
            }

            public void d(Object o, String s) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getLog().d(o, s);
                }
            }

            public void e(Object o, String s, Throwable throwable) {
                if (graceWrapperDelegate != null) {
                    graceWrapperDelegate.getLog().e(o, s, throwable);
                }
            }
        };
    }

    private static RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            @NonNull
            public Request<?> intercept(Request<?> request) {
                BaseGraceInterceptor interceptor = null;
                if (graceWrapperDelegate != null) {
                    interceptor = graceWrapperDelegate.getGraceInterceptor();
                }
                if (interceptor != null) {
                    return (Request)interceptor.intercept(request);
                }
                return request;
            }
        };
    }

    private static Dns getGraceDns() {
        return new Dns(){

            public List<InetAddress> lookup(String s) throws UnknownHostException {
                Dns dns = null;
                if (graceWrapperDelegate != null) {
                    dns = graceWrapperDelegate.getDns();
                }
                if (dns != null) {
                    return dns.lookup(s);
                }
                return null;
            }
        };
    }

    private static void listenNetworkChanged() {
        MLog.debug(TAG, "listenNetworkChanged", new Object[0]);
        NetworkUtils.addNetworkChangeListener(new NetworkChangeListener(){
            private boolean mFirstTime = true;

            @Override
            public void onChange(int networkTyp, NetworkInfo info) {
                if (info != null && info.isConnectedOrConnecting()) {
                    MLog.debug(GraceWrapper.TAG, "network change type: " + networkTyp + ", evictAll idle connection", new Object[0]);
                    if (this.mFirstTime) {
                        MLog.debug(GraceWrapper.TAG, "network change fist time, do nothing", new Object[0]);
                        this.mFirstTime = false;
                    } else {
                        GraceWrapper.evictConnectionPoolAll();
                    }
                }
            }
        });
    }

    private static void handleFileMd5Verify(Call<File> call, Response<File> response, Callback<File> callback, String md5) {
        YYTaskExecutor.execute(() -> {
            File file = (File)response.body();
            String fileMd5 = MD5Utils.fileMd5(file);
            if (StringUtils.equalsIgnoreCase(md5, fileMd5)) {
                YYTaskExecutor.postToMainThread(() -> callback.onResponse(call, response));
            } else {
                YYFileUtils.delete(file);
                YYTaskExecutor.postToMainThread(() -> callback.onFailure(call, (Throwable)new Exception("File Md5 error! origin md5 " + md5 + " file md5 " + fileMd5)));
            }
        });
    }

    public static void evictConnectionPoolAll() {
        GraceWrapper.getGrace().clearConnections();
    }

    public static RequestBody getUploadBody(String type, File file) {
        return RequestBody.create((MediaType)MediaType.parse((String)type), (File)file);
    }

    public static MultipartBody.Part getUploadPart(String key, String value) {
        return MultipartBody.Part.createFormData((String)key, (String)value);
    }

    public static MultipartBody.Part getUploadPart(String key, String fileName, String type, File file) {
        return MultipartBody.Part.createFormData((String)key, (String)fileName, (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)type), (File)file));
    }

    public static void downloadFile(String url, String path, final @NonNull String md5, final Callback<File> callback) {
        Object callbackTemp;
        if (TextUtils.isEmpty((CharSequence)md5)) {
            GraceWrapper.downloadFile(url, path, callback);
            return;
        }
        if (callback instanceof FileCallback) {
            final FileCallback fileFileCallback = (FileCallback)callback;
            callbackTemp = new FileCallback<File>(){

                public void onProgress(long l, long l1) {
                    fileFileCallback.onProgress(l, l1);
                }

                public boolean isCancel() {
                    return fileFileCallback.isCancel();
                }

                public void onResponse(Call<File> call, Response<File> response) {
                    GraceWrapper.handleFileMd5Verify((Call<File>)call, (Response<File>)response, (Callback<File>)callback, md5);
                }

                public void onFailure(Call<File> call, Throwable throwable) {
                    fileFileCallback.onFailure(call, throwable);
                }
            };
        } else {
            callbackTemp = new Callback<File>(){

                public void onResponse(Call<File> call, Response<File> response) {
                    GraceWrapper.handleFileMd5Verify((Call<File>)call, (Response<File>)response, (Callback<File>)callback, md5);
                }

                public void onFailure(Call<File> call, Throwable throwable) {
                    if (callback != null) {
                        callback.onFailure(call, throwable);
                    }
                }
            };
        }
        GraceWrapper.getGrace().newCall(new Request.Builder<File>(){}.get().url(url).filePath(path).group((Request.Group)BizScenc.GENERAL_DOWNLOAD).build()).enqueue((Callback)callbackTemp);
    }

    public static void downloadFile(String url, String path, Callback<File> callback) {
        GraceWrapper.getGrace().newCall(new Request.Builder<File>(){}.get().url(url).filePath(path).group((Request.Group)BizScenc.GENERAL_DOWNLOAD).build()).enqueue(callback);
    }

    public static Response<ResponseBody> downloadFileSync(String url) throws IOException {
        return GraceWrapper.getGrace().newCall(new Request.Builder<ResponseBody>(){}.get().url(url).group((Request.Group)BizScenc.GENERAL_DOWNLOAD).build()).execute();
    }

    public static void upload(Grace newGrace, String url, long connectTimeMills, long readTimeMills, long writeTimeMills, Map<String, String> header, List<MultipartBody.Part> uploadParts, Callback<String> callback) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (uploadParts != null) {
            for (MultipartBody.Part part : uploadParts) {
                bodyBuilder.addPart(part);
            }
        }
        Request.Builder requestBuilder = new Request.Builder<String>(){}.url(url).addHeader(header).post((RequestBody)bodyBuilder.build());
        if (connectTimeMills > 0L) {
            requestBuilder.connectTimeout(connectTimeMills, TimeUnit.MILLISECONDS);
        }
        if (readTimeMills > 0L) {
            requestBuilder.readTimeout(readTimeMills, TimeUnit.MILLISECONDS);
        }
        if (writeTimeMills > 0L) {
            requestBuilder.writeTimeout(writeTimeMills, TimeUnit.MILLISECONDS);
        }
        Grace client = GraceWrapper.getGrace();
        if (newGrace != null) {
            client = newGrace;
        }
        client.newCall(requestBuilder.build()).enqueue(callback);
    }

    static {
        isInMainProcess = false;
        executorAbTestMatchB = false;
    }

    public static interface GraceWrapperDelegate {
        @Nullable
        public String getBackupUrl(String var1);

        public BaseGraceInterceptor getGraceInterceptor();

        public Dns getDns();

        public RequestEventListener getRequestEventListener();

        public StatEventListener getStatEventListener();

        public UniqueRequestMetric getUniqueRequestMetric();

        public ILog getLog();

        public RetryEventListener getRetryEventListener();

        public void reportGraceGetPrematureLog(String var1, boolean var2);
    }

    private static class RetryStrategy
    extends DefaultRetryStrategy {
        private RetryStrategy() {
        }

        public boolean enableRetry(Grace grace, int code, Throwable throwable, Request.Group group) {
            if (throwable instanceof NullPointerException) {
                MLog.error((Object)GraceWrapper.TAG, "enableRetry", throwable, new Object[0]);
            }
            return SettingFlags.getBoolean("grace_enable_retry", true) && super.enableRetry(grace, code, throwable, group);
        }

        public int retryTimes() {
            return SettingFlags.getIntValue("grace_error_retry_times", 1);
        }

        @Nullable
        public String getBackUpUrl(String originUrl, @Nullable Request.Group group) {
            if ((group == BizScenc.HTTP_SERVICE || group == BizScenc.HTTP_RPC) && graceWrapperDelegate != null) {
                return graceWrapperDelegate.getBackupUrl(originUrl);
            }
            return null;
        }
    }

    public static abstract class BaseGraceInterceptor
    extends RequestInterceptor
    implements Interceptor {
    }
}

