/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.memoryrecycle.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.base.crash.CrashMonitor;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableRecycler;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.memoryrecycle.views.RecycleUtils;
import com.yy.base.memoryrecycle.views.ViewSetTagRunnable;
import com.yy.base.memoryrecycle.views.YYRecycleViewCallbackHandler;

public class YYRelativeLayout
extends RelativeLayout
implements IRecycleView {
    private boolean mIsAttachToWindow;
    private YYRecycleViewCallbackHandler mCallbackHandler = new YYRecycleViewCallbackHandler();

    public YYRelativeLayout(Context context) {
        super(context);
    }

    public YYRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.logCreate();
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
    }

    public YYRelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.logCreate();
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        DrawableRecycler.onVisibilityChanged(this, visibility);
    }

    protected void onAttachedToWindow() {
        this.mIsAttachToWindow = true;
        super.onAttachedToWindow();
        this.mCallbackHandler.onAttachedToWindow(this);
        DrawableRecycler.onAttachedToWindow(this);
    }

    protected void onDetachedFromWindow() {
        this.mIsAttachToWindow = false;
        super.onDetachedFromWindow();
        this.mCallbackHandler.onDettachedFromWindow(this);
        DrawableRecycler.onDetachedFromWindow(this);
    }

    public void setBackgroundDrawable(Drawable background) {
        super.setBackgroundDrawable(background);
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, background);
    }

    public void setBackgroundResource(int resid) {
        super.setBackgroundResource(resid);
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, resid);
    }

    public Drawable getBackground() {
        DrawableRecycler.onGetBackground(this);
        Drawable drawable2 = super.getBackground();
        DrawableRecycler.onGetBackgroundEnd(this);
        return drawable2;
    }

    @Override
    public void setBackgroundToNull() {
        super.setBackgroundDrawable(null);
    }

    @Override
    public Drawable getBackgroundInner() {
        return super.getBackground();
    }

    @Override
    public boolean isAttachToWindow() {
        return this.mIsAttachToWindow;
    }

    @Override
    public boolean isWindowInVisible() {
        return this.mCallbackHandler.isWindowInVisible();
    }

    @Override
    public boolean closeAutoRecycleDrawables() {
        return false;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT < 21) {
            super.dispatchDraw(canvas);
        } else {
            if (RuntimeContext.sIsDebuggable) {
                try {
                    super.dispatchDraw(canvas);
                }
                catch (Exception e) {
                    MLog.error(this.toString(), e);
                    throw e;
                }
            }
            try {
                super.dispatchDraw(canvas);
            }
            catch (Throwable e) {
                CrashMonitor.tryCatch((Object)this, "com.yy.base.memoryrecycle.views.YYRelativeLayout#dispatchDraw", e);
            }
        }
    }

    public void draw(Canvas canvas) {
        if (Build.VERSION.SDK_INT < 21) {
            super.draw(canvas);
        }
        try {
            super.draw(canvas);
        }
        catch (Throwable e) {
            CrashMonitor.tryCatch((Object)this, "com.yy.base.memoryrecycle.views.YYRelativeLayout#draw", e);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (Build.VERSION.SDK_INT < 21) {
            return super.dispatchTouchEvent(ev);
        }
        try {
            return super.dispatchTouchEvent(ev);
        }
        catch (Throwable e) {
            CrashMonitor.tryCatch((Object)this, "com.yy.base.memoryrecycle.views.YYRelativeLayout#dispatchTouchEvent", e);
            return false;
        }
    }

    public void setTag(int key, Object tag) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            super.setTag(key, tag);
        } else {
            this.post(new ViewSetTagRunnable((View)this, key, tag));
        }
    }

    public Object getTag(int key) {
        try {
            return super.getTag(key);
        }
        catch (Exception e) {
            MLog.error("YYRelativeLayout", e);
            return null;
        }
    }

    @Override
    public void onWindowRealVisible() {
        RecycleUtils.onWindowShown((ViewGroup)this);
        this.mCallbackHandler.onWindowRealVisible(this);
    }

    @Override
    public void onWindowInvisible() {
        RecycleUtils.onWindowHidden((ViewGroup)this);
        this.mCallbackHandler.onWindowInvisible(this);
    }

    @Override
    public void addListener(IRecycleView.IRecycleViewCallback callback) {
        this.mCallbackHandler.addListener(callback);
    }

    @Override
    public void removeListener(IRecycleView.IRecycleViewCallback callback) {
        this.mCallbackHandler.removeListener(callback);
    }

    public void removeView(View view) {
        if (RuntimeContext.getStartMonitorRemoveViewFlag()) {
            MLog.error("MonitorRemoveView", new RuntimeException("removeView"));
        }
        super.removeView(view);
    }

    public void removeViewAt(int index) {
        if (RuntimeContext.getStartMonitorRemoveViewFlag()) {
            MLog.error("MonitorRemoveView", new RuntimeException("removeViewAt"));
        }
        super.removeViewAt(index);
    }

    public void removeAllViewsInLayout() {
        if (RuntimeContext.getStartMonitorRemoveViewFlag()) {
            MLog.error("MonitorRemoveView", new RuntimeException("removeAllViewsInLayout()"));
        }
        super.removeAllViewsInLayout();
    }

    public void removeAllViews() {
        if (RuntimeContext.getStartMonitorRemoveViewFlag()) {
            MLog.error("MonitorRemoveView", new RuntimeException("removeAllViews()"));
        }
        super.removeAllViews();
    }
}

