/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.memoryrecycle.views;

import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.utils.SystemUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class YYRecycleViewCallbackHandler {
    private ArrayList<WeakReference<IRecycleView.IRecycleViewCallback>> mCallbacks = null;
    private IRecycleView view;
    private boolean isViewDetach = false;
    private boolean isWindowInVisible = false;
    private static final boolean sEnableLog;

    public boolean isWindowInVisible() {
        return this.isWindowInVisible;
    }

    public synchronized void addListener(IRecycleView.IRecycleViewCallback callback) {
        if (this.mCallbacks == null) {
            this.mCallbacks = new ArrayList(3);
        }
        if (this.find(callback)) {
            return;
        }
        this.mCallbacks.add(new WeakReference<IRecycleView.IRecycleViewCallback>(callback));
    }

    synchronized boolean find(IRecycleView.IRecycleViewCallback callback) {
        if (this.mCallbacks != null && this.mCallbacks.size() > 0) {
            for (WeakReference<IRecycleView.IRecycleViewCallback> item : this.mCallbacks) {
                if (item == null || item.get() != callback) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void removeListener(IRecycleView.IRecycleViewCallback callback) {
        if (this.mCallbacks != null && this.mCallbacks.size() > 0) {
            for (WeakReference<IRecycleView.IRecycleViewCallback> item : this.mCallbacks) {
                if (item == null || item.get() != callback) continue;
                this.mCallbacks.remove(item);
                return;
            }
        }
    }

    public synchronized void onWindowRealVisible(IRecycleView view) {
        if (view == null) {
            return;
        }
        this.isWindowInVisible = false;
        if (!this.isViewDetach) {
            this.onViewShow();
        }
        if (sEnableLog) {
            MLog.info("ViewHolder", "onWindowRealVisible holder:%s, view:%s", this.toString(), view.toString());
        }
    }

    public synchronized void onWindowInvisible(IRecycleView view) {
        if (view == null) {
            return;
        }
        this.isWindowInVisible = true;
        if (!this.isViewDetach) {
            this.onViewHide();
        }
        if (sEnableLog) {
            MLog.info("ViewHolder", "onWindowInvisible holder:%s, view:%s", this.toString(), view.toString());
        }
    }

    public synchronized void onAttachedToWindow(IRecycleView view) {
        if (view == null) {
            return;
        }
        this.isViewDetach = false;
        if (!this.isWindowInVisible) {
            this.onViewShow();
        }
        if (sEnableLog) {
            MLog.info("ViewHolder", "onViewAttach holder:%s, view:%s", this.toString(), view.toString());
        }
    }

    public synchronized void onDettachedFromWindow(IRecycleView view) {
        if (view == null) {
            return;
        }
        this.isViewDetach = true;
        if (!this.isWindowInVisible) {
            this.onViewHide();
        }
        if (sEnableLog) {
            MLog.info("ViewHolder", "onViewDetach holder:%s, view:%s", this.toString(), view.toString());
        }
    }

    public void onViewHide() {
        if (this.mCallbacks != null && this.mCallbacks.size() > 0) {
            IRecycleView.IRecycleViewCallback callback = null;
            for (WeakReference<IRecycleView.IRecycleViewCallback> item : this.mCallbacks) {
                if (item == null || (callback = (IRecycleView.IRecycleViewCallback)item.get()) == null) continue;
                callback.onViewInvisible(this.view);
            }
        }
    }

    public void onViewShow() {
        if (this.mCallbacks != null && this.mCallbacks.size() > 0) {
            IRecycleView.IRecycleViewCallback callback = null;
            for (WeakReference<IRecycleView.IRecycleViewCallback> item : this.mCallbacks) {
                if (item == null || (callback = (IRecycleView.IRecycleViewCallback)item.get()) == null) continue;
                callback.onViewVisible(this.view);
            }
        }
    }

    static {
        if (SystemUtils.isShowEnvSetting()) {
            // empty if block
        }
        sEnableLog = false;
    }
}

