/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.memoryrecycle.views;

import android.graphics.drawable.Drawable;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.utils.SystemUtils;

public interface IRecycleView {
    public void setBackgroundToNull();

    public Drawable getBackgroundInner();

    public boolean isAttachToWindow();

    public boolean isWindowInVisible();

    public boolean closeAutoRecycleDrawables();

    default public void onWindowRealVisible() {
    }

    default public void onWindowInvisible() {
    }

    default public void addListener(IRecycleViewCallback callback) {
    }

    default public void removeListener(IRecycleViewCallback callback) {
    }

    default public boolean canRecycleRes() {
        return true;
    }

    default public boolean recycleRes() {
        return false;
    }

    default public void logCreate() {
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add("ViewCreate_" + this, new Object[0]);
        }
    }

    default public String getWindowName() {
        return "";
    }

    public static interface IRecycleViewCallback {
        public void onViewVisible(IRecycleView var1);

        public void onViewInvisible(IRecycleView var1);
    }
}

