/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger;

import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.NormalLogImpl;
import com.yy.base.logger.memorycachelog.MemoryCacheLogImpl;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.hago.xlog.KLogUtils;
import com.yy.hago.xlog.LogOptions;
import java.util.Map;
import tv.athena.klog.api.LogLevel;

public class MLog {
    private static NormalLogImpl sNormalLog = new NormalLogImpl();
    private static MemoryCacheLogImpl sMemoryCacheLog = new MemoryCacheLogImpl();
    private static volatile int sNeedMemoryLogSwitch = -1;

    static boolean isNeedMemoryCacheLog() {
        if (SystemUtils.isShowEnvSetting()) {
            return false;
        }
        if (sNeedMemoryLogSwitch == -1 && SettingFlags.hasInited()) {
            sNeedMemoryLogSwitch = SettingFlags.getBoolean("open_memory_log", false) ? 1 : 0;
        }
        return RuntimeContext.sIsMainProcess && sNeedMemoryLogSwitch == 1;
    }

    public static void verbose(Object obj, String format, Object ... args) {
        if (KLogUtils.getLogCurLevel() > LogOptions.LEVEL_VERBOSE) {
            return;
        }
        (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).verbose(obj, format, args);
    }

    public static boolean isLogLevelBlowInfo() {
        return MLog.getLogLevel() <= LogOptions.LEVEL_INFO;
    }

    public static void infoIfDebug(Object obj, String format, Object ... args) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info(obj, format, args);
        }
    }

    public static int debug(Object obj, String format, Object ... args) {
        if (!RuntimeContext.sIsDebuggable && KLogUtils.getLogCurLevel() > LogOptions.LEVEL_DEBUG) {
            return 0;
        }
        (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).debug(obj, format, args);
        return 1;
    }

    public static void info(Object obj, String format, Object ... args) {
        if (!RuntimeContext.sIsDebuggable && KLogUtils.getLogCurLevel() > LogOptions.LEVEL_INFO) {
            return;
        }
        (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).info(obj, format, args);
    }

    public static void warn(Object obj, String format, Object ... args) {
        if (!RuntimeContext.sIsDebuggable && KLogUtils.getLogCurLevel() > LogOptions.LEVEL_WARN) {
            return;
        }
        (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).warn(obj, format, args);
    }

    public static void error(Object obj, String format, Object ... args) {
        if (!RuntimeContext.sIsDebuggable && KLogUtils.getLogCurLevel() > LogOptions.LEVEL_ERROR) {
            return;
        }
        if (RuntimeContext.sIsDebuggable) {
            (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).warn(obj, format, args);
        } else {
            (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).error(obj, format, args);
        }
    }

    public static void error(Object obj, String format, Throwable t, Object ... args) {
        if (!RuntimeContext.sIsDebuggable && KLogUtils.getLogCurLevel() > LogOptions.LEVEL_ERROR) {
            return;
        }
        (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).error(obj, format, t, args);
    }

    public static void error(Object obj, Throwable t) {
        (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).error(obj, t);
    }

    public static void trace(Object obj, String message) {
        (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).trace(obj, message);
    }

    @Deprecated
    public static void flush() {
        KLogUtils.flush();
    }

    @Deprecated
    public static void close() {
    }

    public static void updateLogLevel(int level) {
        if (level < LogOptions.LEVEL_VERBOSE) {
            return;
        }
        if (RuntimeContext.sIsDebuggable && level > LogOptions.LEVEL_DEBUG) {
            return;
        }
        if (!RuntimeContext.sIsDebuggable && level < LogOptions.LEVEL_INFO) {
            return;
        }
        KLogUtils.updateLogLevel(level);
        MLog.info("MLog", " update level:%d", MLog.getLogLevel());
    }

    public static int getLogLevel() {
        return KLogUtils.getLogCurLevel();
    }

    public static boolean isLogLevelAboveDebug() {
        return MLog.getLogLevel() > LogOptions.LEVEL_DEBUG;
    }

    @Deprecated
    public static boolean isLogLevelAboveVerbose() {
        return MLog.getLogLevel() > LogOptions.LEVEL_VERBOSE;
    }

    public static void processSilentException(Throwable ex) {
        MLog.error(" ", ex);
    }

    public static void processSilentException(Object tag, Throwable ex) {
        MLog.error(tag, ex);
    }

    @Deprecated
    public static boolean isIsInitialized() {
        return KLogUtils.isInitialized();
    }

    private static synchronized void flushCacheLogs() {
        (MLog.isNeedMemoryCacheLog() ? sMemoryCacheLog : sNormalLog).flushCacheLogs();
    }

    public static void handleStartupFiveSecond() {
        YYTaskExecutor.execute(() -> MLog.flushCacheLogs());
    }

    public static boolean isNeedCacheLog() {
        if (!MLog.isNeedMemoryCacheLog()) {
            return sNormalLog.isNeedCacheLog();
        }
        return false;
    }

    public static int getVerboseLevel() {
        return LogLevel.INSTANCE.getLEVEL_VERBOSE();
    }

    public static void loge(String tag, String msg) {
        if (tag == null || tag.length() == 0 || msg == null || msg.length() == 0) {
            return;
        }
        int segmentSize = 3072;
        long length = msg.length();
        if (length <= (long)segmentSize) {
            Log.e((String)tag, (String)msg);
        } else {
            while (msg.length() > segmentSize) {
                String logContent = msg.substring(0, segmentSize);
                msg = msg.replace(logContent, "");
                Log.e((String)tag, (String)("-------------------" + logContent));
            }
            Log.e((String)tag, (String)("-------------------" + msg));
        }
    }

    public static void logAllThreadInfo(String by, boolean justOurLogFile) {
        if (!SystemUtils.isShowEnvSetting()) {
            return;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<Thread, StackTraceElement[]> stackTrace : Thread.getAllStackTraces().entrySet()) {
                Thread thread = stackTrace.getKey();
                StackTraceElement[] stack = stackTrace.getValue();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("\u7ebf\u7a0b\uff1a" + thread.getName() + "\n");
                for (StackTraceElement stackTraceElement : stack) {
                    if (stackTraceElement == null) continue;
                    stringBuilder.append(stackTraceElement.toString());
                    stringBuilder.append("\n");
                }
                String info = stringBuilder.toString();
                if (justOurLogFile) {
                    MLog.info(by, info, new Object[0]);
                    continue;
                }
                Log.i((String)by, (String)info);
            }
        }
        catch (Throwable e) {
            MLog.error(by, e);
        }
    }
}

