/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.customcache;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import java.util.HashMap;

public class YYLruBitmapPool
extends LruBitmapPool {
    private static boolean sDebug = ImageLoader.sDebugSwitch && RuntimeContext.sIsDebuggable;
    private HashMap<Bitmap, Integer> itemSizes = new HashMap();
    private int lruMemItemSizeOpt = -1;

    public YYLruBitmapPool(int maxSize) {
        super(maxSize);
    }

    @Override
    public synchronized void put(Bitmap bitmap) {
        if (bitmap != null && (double)bitmap.getByteCount() > 1572864.0) {
            if (sDebug && !MLog.isLogLevelAboveDebug()) {
                MLog.debug("YYLruBitmapPool", "not add bitmap exLarge:" + bitmap.getByteCount(), new Object[0]);
            }
            return;
        }
        if (bitmap != null && sDebug && !MLog.isLogLevelAboveDebug()) {
            MLog.debug("YYLruBitmapPool", "add bitmap:" + bitmap.getWidth() + " " + bitmap.getHeight(), new Object[0]);
        }
        if (bitmap != null) {
            super.put(bitmap);
        }
    }

    @Override
    @TargetApi(value=12)
    public synchronized Bitmap getDirty(int width, int height, Bitmap.Config config) {
        if (width <= 0 || height <= 0) {
            return null;
        }
        Bitmap result = super.getDirty(width, height, config);
        if (result != null && sDebug && !MLog.isLogLevelAboveDebug()) {
            MLog.debug("YYLruBitmapPool", "get bitmap:" + result.getWidth() + " " + result.getHeight(), new Object[0]);
        }
        return result;
    }

    @Override
    public void trimMemory(int level) {
        MLog.info("YYLruBitmapPool", "trimMemory, level=" + level, new Object[0]);
        if (level >= 40) {
            super.trimMemory(level);
        } else {
            super.trimMemory(40);
        }
    }

    @Override
    protected int getSize(Bitmap bitmap) {
        return this.getItemSize(bitmap);
    }

    @Override
    protected void removeFromTrack(Bitmap removed) {
        super.removeFromTrack(removed);
        this.removeItem(removed);
    }

    @Override
    public void clearMemory() {
        super.clearMemory();
        this.clearItemSizes();
    }

    private boolean isItemSizeOptSwitchOn() {
        if (this.lruMemItemSizeOpt == -1 && SettingFlags.hasInited()) {
            this.lruMemItemSizeOpt = SettingFlags.getIntValue("lru_mem_item_size_opt", 0);
            if (SystemUtils.isShowEnvSetting()) {
                this.lruMemItemSizeOpt = 1;
            }
        }
        return this.lruMemItemSizeOpt == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearItemSizes() {
        HashMap<Bitmap, Integer> hashMap = this.itemSizes;
        synchronized (hashMap) {
            this.itemSizes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getItemSize(Bitmap bitmap) {
        if (!this.isItemSizeOptSwitchOn()) {
            return super.getSize(bitmap);
        }
        int size = 0;
        HashMap<Bitmap, Integer> hashMap = this.itemSizes;
        synchronized (hashMap) {
            Integer itemSize = this.itemSizes.get(bitmap);
            if (itemSize != null) {
                size = itemSize;
            }
            if (size <= 0) {
                size = super.getSize(bitmap);
                if (size > 0) {
                    this.itemSizes.put(bitmap, size);
                }
            } else if (SystemUtils.isShowEnvSetting()) {
                int newSize = super.getSize(bitmap);
                if (newSize != size) {
                    MLog.error((Object)"YYLruBitmapPool", "item:%s, oldSize:%d, newSize:%d!", bitmap, size, newSize);
                } else {
                    MLog.info("YYLruBitmapPool", "item:%s, size:%d use cache!", bitmap, size);
                }
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItem(Bitmap bitmap) {
        HashMap<Bitmap, Integer> hashMap = this.itemSizes;
        synchronized (hashMap) {
            this.itemSizes.remove(bitmap);
        }
    }
}

