/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.BitmapUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ViewImage {
    private static final String TAG = "ViewImage";
    public static final String PNG_SUFFIX = ".png";
    public static final String JPG_SUFFIX = ".jpg";
    public static final String WEBP_SUFFIX = ".webp";

    @Nullable
    public static Bitmap getViewBitmap(View view) {
        return ViewImage.getViewBitmap(view, Bitmap.Config.ARGB_4444);
    }

    public static Bitmap getViewBitmap(View view, Bitmap.Config config) {
        return ViewImage.getViewBitmap(view, view.getMeasuredWidth(), view.getMeasuredHeight(), config);
    }

    public static Bitmap getViewBitmap(View view, int width, int height, Bitmap.Config config) {
        Bitmap bitmap = null;
        if (view != null) {
            try {
                bitmap = BitmapUtils.createBitmap(width, height, config);
                ViewImage.drawCanvas(view, bitmap);
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, "[getViewImage]", throwable, new Object[0]);
            }
        } else {
            MLog.error((Object)TAG, "[getViewImage] null view", new Object[0]);
        }
        return bitmap;
    }

    public static void drawCanvas(View view, Bitmap bitmap) {
        if (view == null) {
            return;
        }
        try {
            Canvas canvas = new Canvas(bitmap);
            view.draw(canvas);
        }
        catch (NullPointerException e) {
            MLog.error((Object)TAG, "view is null", new Object[0]);
        }
    }

    @WorkerThread
    public static String saveImgToLocal(Bitmap bitmap, String name, String parentPath, Bitmap.CompressFormat format) {
        return ViewImage.saveImg(bitmap, name, parentPath, false, format);
    }

    @WorkerThread
    public static String saveImgToAlbum(Bitmap bitmap, String name, String parentPath, Bitmap.CompressFormat format, boolean saveToSysAlbum) {
        return ViewImage.saveImg(bitmap, name, parentPath, saveToSysAlbum, format);
    }

    public static void insertImgToAlbum(String imgPath) {
        if (!YYFileUtils.isPathExist(imgPath)) {
            MLog.error((Object)TAG, "insert to album error, file not exist", new Object[0]);
            return;
        }
        try {
            File imgFile = new File(imgPath);
            InsertImageUtils.insertImage(RuntimeContext.sApplicationContext.getContentResolver(), imgFile.getAbsolutePath(), imgFile.getName(), null);
            RuntimeContext.sApplicationContext.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + imgFile.getAbsolutePath()))));
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "save to album error", e, new Object[0]);
        }
    }

    @WorkerThread
    public static String saveImg(Bitmap bitmap, String name, String parentPath, boolean saveToAlbum, Bitmap.CompressFormat format) {
        Bitmap.CompressFormat compressFormat;
        String path = "";
        Bitmap.CompressFormat compressFormat2 = compressFormat = format == null ? Bitmap.CompressFormat.JPEG : format;
        if (!TextUtils.isEmpty((CharSequence)name)) {
            String suffix = "";
            if (name.lastIndexOf(".") != -1) {
                suffix = name.substring(name.lastIndexOf("."), name.length());
            }
            switch (compressFormat) {
                case JPEG: {
                    if (JPG_SUFFIX.equals(suffix)) break;
                    name = name + JPG_SUFFIX;
                    break;
                }
                case PNG: {
                    if (PNG_SUFFIX.equals(suffix)) break;
                    name = name + PNG_SUFFIX;
                    break;
                }
                case WEBP: {
                    if (WEBP_SUFFIX.equals(suffix)) break;
                    name = name + WEBP_SUFFIX;
                    break;
                }
            }
        }
        if (bitmap != null && !bitmap.isRecycled() && !FP.empty(parentPath)) {
            File file = null;
            try {
                File tempDir = new File(parentPath);
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
                if ((file = new File(tempDir, name)).exists()) {
                    file.delete();
                }
                FileOutputStream fos = new FileOutputStream(file);
                bitmap.compress(compressFormat, 100, (OutputStream)fos);
                fos.flush();
                fos.close();
                path = file.getAbsolutePath();
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "[saveImg] path: %s", path);
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, "save error", e, new Object[0]);
            }
            if (saveToAlbum && !TextUtils.isEmpty((CharSequence)path) && file != null) {
                try {
                    InsertImageUtils.insertImage(RuntimeContext.sApplicationContext.getContentResolver(), file.getAbsolutePath(), file.getName(), null);
                    RuntimeContext.sApplicationContext.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + path))));
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, "save to album error", e, new Object[0]);
                }
            }
        } else {
            MLog.error((Object)TAG, "[saveImg] wrong params, bitmap: %s, parentPath: %s", bitmap, parentPath);
        }
        return path;
    }

    public static class InsertImageUtils {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final String insertImage(ContentResolver cr, String imagePath, String name, String description) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(imagePath);
                Bitmap bm = YYImageUtils.decodeFile(imagePath);
                String ret = InsertImageUtils.insertImage(cr, imagePath, bm, name, description);
                bm.recycle();
                String string2 = ret;
                return string2;
            }
            catch (Throwable e) {
                MLog.error((Object)ViewImage.TAG, "[insertImage]", e, new Object[0]);
                String string3 = "";
                return string3;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final String insertImage(ContentResolver cr, String imagePath, Bitmap source, String title, String description) {
            String stringUrl;
            Uri url;
            block8: {
                ContentValues values = new ContentValues();
                values.put("title", title);
                values.put("description", description);
                values.put("mime_type", InsertImageUtils.getPhotoMimeType(imagePath));
                values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
                url = null;
                stringUrl = null;
                try {
                    url = cr.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                    if (source != null) {
                        try (OutputStream imageOut = cr.openOutputStream(url);){
                            source.compress(Bitmap.CompressFormat.JPEG, 100, imageOut);
                        }
                        long id2 = ContentUris.parseId((Uri)url);
                        Bitmap miniThumb = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)cr, (long)id2, (int)1, null);
                        Bitmap bitmap = InsertImageUtils.storeThumbnail(cr, miniThumb, id2, 50.0f, 50.0f, 3);
                        break block8;
                    }
                    MLog.error((Object)ViewImage.TAG, "Failed to create thumbnail, removing original", new Object[0]);
                    cr.delete(url, null, null);
                    url = null;
                }
                catch (Exception e) {
                    MLog.error((Object)ViewImage.TAG, "Failed to insert image", e, new Object[0]);
                    if (url == null) break block8;
                    cr.delete(url, null, null);
                    url = null;
                }
            }
            if (url != null) {
                stringUrl = url.toString();
            }
            return stringUrl;
        }

        public static String getPhotoMimeType(String path) {
            String lowerPath = path.toLowerCase();
            if (lowerPath.endsWith("jpg") || lowerPath.endsWith("jpeg")) {
                return "image/jpeg";
            }
            if (lowerPath.endsWith("png")) {
                return "image/png";
            }
            if (lowerPath.endsWith("gif")) {
                return "image/gif";
            }
            return "image/jpeg";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final Bitmap storeThumbnail(ContentResolver cr, Bitmap source, long id2, float width, float height, int kind) {
            Matrix matrix = new Matrix();
            float scaleX = width / (float)source.getWidth();
            float scaleY = height / (float)source.getHeight();
            matrix.setScale(scaleX, scaleY);
            Bitmap thumb = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
            ContentValues values = new ContentValues(4);
            values.put("kind", Integer.valueOf(kind));
            values.put("image_id", Integer.valueOf((int)id2));
            values.put("height", Integer.valueOf(thumb.getHeight()));
            values.put("width", Integer.valueOf(thumb.getWidth()));
            Uri url = cr.insert(MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, values);
            OutputStream thumbOut = null;
            try {
                thumbOut = cr.openOutputStream(url);
                thumb.compress(Bitmap.CompressFormat.JPEG, 100, thumbOut);
                Bitmap bitmap = thumb;
                return bitmap;
            }
            catch (Throwable e) {
                MLog.error((Object)ViewImage.TAG, "[StoreThumbnail]", e, new Object[0]);
            }
            finally {
                if (null != thumbOut) {
                    try {
                        thumbOut.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }
    }
}

