/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.os.Build;
import com.bumptech.glide.load.engine.cache.MemorySizeCalculator;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class ImageLoaderSetup {
    private boolean isDebug = false;
    private static final int DEFAULT_ARRAY_CACHE_SIZE = Build.VERSION.SDK_INT >= 21 ? 0x400000 : 0x200000;
    private static final int DEFAULT_BITMAP_CACHE_SIZE = Build.VERSION.SDK_INT >= 21 ? 0x1400000 : 0xA00000;
    private static final int DEFAULT_RESOURCE_CACHE_SIZE = Build.VERSION.SDK_INT >= 21 ? 0x1400000 : 0xA00000;
    private boolean recycleSwitch = true;
    private int bitmapPoolSize;
    private int resourceCacheSize;
    private int arrayPoolCacheSize;
    private ModelLoaderFactory<GlideUrl, InputStream> loaderFactory;
    private boolean bigImageAutoRecycle = false;
    private int bigRecycleSizeMultiplier = 5;
    private MemorySizeCalculator memorySizeCalculator;

    ImageLoaderSetup() {
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isRecycleSwitch() {
        return this.recycleSwitch;
    }

    public int getBitmapPoolSize() {
        if (this.bitmapPoolSize <= 0) {
            return DEFAULT_BITMAP_CACHE_SIZE;
        }
        return this.bitmapPoolSize;
    }

    public int getResourceCacheSize() {
        if (this.resourceCacheSize <= 0) {
            return DEFAULT_RESOURCE_CACHE_SIZE;
        }
        return this.resourceCacheSize;
    }

    public int getArrayPoolCacheSize() {
        if (this.resourceCacheSize <= 0) {
            return DEFAULT_ARRAY_CACHE_SIZE;
        }
        return this.arrayPoolCacheSize;
    }

    public MemorySizeCalculator getMemorySizeCalculator() {
        return this.memorySizeCalculator;
    }

    public ModelLoaderFactory<GlideUrl, InputStream> getLoaderFactory() {
        return this.loaderFactory;
    }

    public boolean isBigImageAutoRecycle() {
        return this.bigImageAutoRecycle;
    }

    public int getBigRecycleSizeMultiplier() {
        return this.bigRecycleSizeMultiplier;
    }

    public static class Builder {
        private ImageLoaderSetup mSetup = new ImageLoaderSetup();

        Builder() {
        }

        public Builder isDebug(boolean isDebug) {
            this.mSetup.isDebug = isDebug;
            return this;
        }

        public Builder recycleSwitch(boolean recycleSwitch) {
            this.mSetup.recycleSwitch = recycleSwitch;
            return this;
        }

        public Builder bitmapPoolSize(int bitmapPoolSize) {
            if (bitmapPoolSize > 0) {
                this.mSetup.bitmapPoolSize = bitmapPoolSize;
            }
            return this;
        }

        public Builder resourceCacheSize(int resourceCacheSize) {
            if (resourceCacheSize > 0) {
                this.mSetup.resourceCacheSize = resourceCacheSize;
            }
            return this;
        }

        public Builder arrayCacheSize(int arrayPoolCacheSize) {
            if (arrayPoolCacheSize > 0) {
                this.mSetup.arrayPoolCacheSize = arrayPoolCacheSize;
            }
            return this;
        }

        public Builder memorySizeCalculator(@NotNull MemorySizeCalculator calculator) {
            this.mSetup.memorySizeCalculator = calculator;
            return this;
        }

        public Builder bigImgAutoRecycle(boolean bigImgAutoRecycle) {
            this.mSetup.bigImageAutoRecycle = bigImgAutoRecycle;
            return this;
        }

        public Builder bigRecycleSizeMultiplier(int bigRecycleSizeMultiplier) {
            if (bigRecycleSizeMultiplier > 0) {
                this.mSetup.bigRecycleSizeMultiplier = bigRecycleSizeMultiplier;
            }
            return this;
        }

        public Builder loaderFactory(ModelLoaderFactory<GlideUrl, InputStream> loaderFactory) {
            this.mSetup.loaderFactory = loaderFactory;
            return this;
        }

        public ImageLoaderSetup build() {
            return this.mSetup;
        }
    }
}

