/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.PerformanceData;
import com.bumptech.glide.load.engine.cache.MemorySizeCalculator;
import com.bumptech.glide.load.engine.executor.GlideExecutor;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.target.Target;
import com.yy.base.R;
import com.yy.base.imageloader.BaseImageData;
import com.yy.base.imageloader.BigPicRecycler;
import com.yy.base.imageloader.GifHandler;
import com.yy.base.imageloader.GlideRegistry;
import com.yy.base.imageloader.IRecycler;
import com.yy.base.imageloader.ImageBitmapData;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageData;
import com.yy.base.imageloader.ImageFormatTransformer;
import com.yy.base.imageloader.ImageInnerHandler;
import com.yy.base.imageloader.ImageLoaderSetup;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.ImgFormatInfo;
import com.yy.base.imageloader.customcache.ImageCache;
import com.yy.base.imageloader.customcache.YYLruArrayPool;
import com.yy.base.imageloader.customcache.YYLruBitmapPool;
import com.yy.base.imageloader.customcache.YYLruResourceCache;
import com.yy.base.imageloader.httptohttpsstrategyimpl.HttpsSchemeTransformStrategy;
import com.yy.base.imageloader.strategy.StrategySelector;
import com.yy.base.imageloader.strategy.StrategyStatus;
import com.yy.base.imageloader.transform.BlurTransformation;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.filestorage.FileOperatorQ;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class ImageLoader {
    private static final String TAG = "ImageLoader";
    public static boolean sDebugSwitch = false;
    private static volatile YYLruResourceCache sGlideCache;
    private static volatile YYLruBitmapPool sBitmapPool;
    private static volatile YYLruArrayPool sArrayPool;
    private static volatile ImageCache sNormalCache;
    private static volatile ImageLoaderSetup mSetupData;
    private static GlideExecutor sExecutor;
    private static final AtomicInteger sIndex;
    private static boolean sResetDrawableToNulling;
    private static final List<IMonitor> sMonitorList;
    private static volatile ImageLoaderDelegate sDelegate;
    private static ImageInnerHandler sImageInnerHandler;
    private static volatile WeakReference<Context> sContextRef;
    private MemorySizeCalculator calculator;

    public static void attachApplicationContext(Context context) {
        if (context == null) {
            return;
        }
        MLog.info(TAG, "attach application context", new Object[0]);
        sContextRef = new WeakReference<Context>(context.getApplicationContext());
    }

    public static synchronized void init(Context context, ImageLoaderSetup setupData, ImageLoaderDelegate delegate) {
        MLog.info(TAG, "init", new Object[0]);
        ImageLoader.attachApplicationContext(context);
        sDelegate = delegate;
        if (setupData != null) {
            mSetupData = setupData;
            GlideRegistry.registry(setupData.getLoaderFactory());
            BigPicRecycler.updateParams(setupData.isBigImageAutoRecycle(), setupData.getBigRecycleSizeMultiplier());
        }
        if (context instanceof Application) {
            IRecycler recycler = new IRecycler(){

                @Override
                public boolean recycle(RecycleImageView imageView) {
                    return ImageLoader.recycle(imageView);
                }

                @Override
                public boolean recovery(RecycleImageView imageView) {
                    return ImageLoader.recovery(imageView);
                }
            };
            GifHandler.init((Application)context, recycler);
            BigPicRecycler.init((Application)context, recycler);
        }
    }

    public static void addMonitor(IMonitor monitor) {
        if (monitor == null) {
            return;
        }
        if (!sMonitorList.contains(monitor)) {
            sMonitorList.add(monitor);
        }
    }

    private static int generateLoadId() {
        return sIndex.incrementAndGet();
    }

    public static ImageLoaderSetup.Builder setup() {
        return new ImageLoaderSetup.Builder();
    }

    public static void setExecutor(GlideExecutor executor) {
        if (executor != null) {
            sExecutor = executor;
        }
    }

    public static boolean fillExecutor(GlideBuilder glideBuilder) {
        if (glideBuilder != null && sExecutor != null) {
            glideBuilder.setSourceExecutor(sExecutor);
            return true;
        }
        return false;
    }

    public static MemorySizeCalculator getMemorySizeCalculator() {
        return mSetupData.getMemorySizeCalculator();
    }

    public static YYLruBitmapPool getBitmapPool() {
        if (sBitmapPool == null) {
            sBitmapPool = new YYLruBitmapPool(mSetupData.getBitmapPoolSize());
        }
        return sBitmapPool;
    }

    public static YYLruResourceCache getResourceCache() {
        if (sGlideCache == null) {
            sGlideCache = new YYLruResourceCache(mSetupData.getResourceCacheSize());
        }
        return sGlideCache;
    }

    public static YYLruArrayPool getArrayCache() {
        if (sArrayPool == null) {
            sArrayPool = new YYLruArrayPool(mSetupData.getArrayPoolCacheSize());
        }
        return sArrayPool;
    }

    private static ImageCache getYYImageCache() {
        if (sNormalCache == null) {
            sNormalCache = new ImageCache(ImageLoader.getContext());
        }
        return sNormalCache;
    }

    private static ImageInnerHandler getImageHandler() {
        if (sImageInnerHandler == null) {
            sImageInnerHandler = new ImageInnerHandler(mSetupData, sDelegate);
        }
        return sImageInnerHandler;
    }

    public static ImageData checkData(@Nullable ImageView imageView) {
        Object dataObject;
        if (imageView != null && (dataObject = imageView.getTag(R.id.yy_image_data_id)) instanceof ImageData) {
            return (ImageData)dataObject;
        }
        return null;
    }

    public static Target checkGlideTarget(@Nullable ImageView imageView) {
        Object dataObject;
        if (imageView != null && (dataObject = imageView.getTag(R.id.yy_glide_target_id)) instanceof Target) {
            return (Target)dataObject;
        }
        return null;
    }

    public static ImageBitmapData checkBitmapData(@Nullable ImageView imageView) {
        Object dataObject;
        if (imageView != null && (dataObject = imageView.getTag(R.id.yy_image_data_id)) instanceof ImageBitmapData) {
            return (ImageBitmapData)dataObject;
        }
        return null;
    }

    static Context getContext() {
        Context context = null;
        if (sContextRef != null) {
            context = (Context)sContextRef.get();
        }
        if (context == null) {
            throw new RuntimeException("ImageLoader getContext null");
        }
        return context;
    }

    private static void checkLoadSize(ImageView view, BaseImageData imageData) {
        if (imageData == null || view == null) {
            return;
        }
        int w = imageData.width;
        if (w <= 0 && (w = view.getWidth()) <= 0) {
            if (view.getLayoutParams() != null) {
                w = view.getLayoutParams().width;
            }
            if (w <= 0) {
                w = view.getMeasuredWidth();
            }
        }
        imageData.width = w;
        int h = imageData.height;
        if (h <= 0 && (h = view.getHeight()) <= 0) {
            if (view.getLayoutParams() != null) {
                h = view.getLayoutParams().height;
            }
            if (h <= 0) {
                h = view.getMeasuredHeight();
            }
        }
        imageData.height = h;
        if (mSetupData.isDebug()) {
            MLog.info(TAG, "checkLoadSize w: %d, h: %d", w, h);
        }
    }

    static void setImageDataToTag(@Nullable ImageView imageView, @Nullable ImageData imageData) {
        if (imageView == null) {
            return;
        }
        imageView.setTag(R.id.yy_image_data_id, (Object)imageData);
    }

    static void setBitmapDataToTag(@Nullable ImageView imageView, @Nullable ImageBitmapData imageData) {
        if (imageView == null) {
            return;
        }
        imageView.setTag(R.id.yy_image_data_id, (Object)imageData);
    }

    static void setImageTargetToTag(@Nullable ImageView imageView, @Nullable Target target) {
        if (imageView != null) {
            imageView.setTag(R.id.yy_glide_target_id, (Object)target);
        }
    }

    public static void clearRequest(ImageView imageView) {
        if (imageView != null) {
            Object target = imageView.getTag(R.id.yy_glide_target_id);
            if (target instanceof Target) {
                ImageLoader.clear((Target)target);
                imageView.setTag(R.id.yy_glide_target_id, null);
            } else {
                ImageLoader.clear(imageView);
            }
        }
    }

    private static void checkUrlHasResize(@Nullable String url) {
        if (mSetupData.isDebug() && !TextUtils.isEmpty((CharSequence)url) && !url.contains("resize,") && !url.endsWith(".mp4") && sDelegate != null && sDelegate.isBusinessTarget(url)) {
            MLog.warn("\u56fe\u7247\u52a0\u8f7d\u8fdd\u89c4", Log.getStackTraceString((Throwable)new RuntimeException("\u9700\u8981\u62fc\u63a5\u5c3a\u5bf8\uff1a" + url)), new Object[0]);
        }
    }

    private static void checkFinalFormat(ImageView imageView, ImgFormatInfo formatInfo) {
        if (formatInfo == null) {
            return;
        }
        String realRequestUrl = formatInfo.getOriginUrl();
        formatInfo.setFormat(ImgFormat.WEBP);
        if (sDelegate != null) {
            formatInfo.setFormat(sDelegate.canUseFormat(imageView, formatInfo.getOriginUrl(), formatInfo));
        }
    }

    private static String checkFinalRequestUrl(ImageView imageView, @Nullable String originUrl, int width, int height, boolean useHeif) {
        if (TextUtils.isEmpty((CharSequence)originUrl)) {
            return originUrl;
        }
        ImgFormatInfo formatInfo = new ImgFormatInfo(originUrl, width, height);
        ImageLoader.checkFinalFormat(imageView, formatInfo);
        String realRequestUrl = ImageFormatTransformer.getRealRequestUrl(formatInfo);
        realRequestUrl = StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorResult(StrategyStatus.FINAL, realRequestUrl);
        if (mSetupData.isDebug()) {
            MLog.info(TAG, "checkFinalLoadUrl origin url: %s, final url: %s, width: %d, height: %d, useHeif: %b, format: %s", new Object[]{originUrl, realRequestUrl, width, height, useHeif, formatInfo.getFormat()});
            try {
                ImageLoader.checkHasResizeParam(formatInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return realRequestUrl;
    }

    private static void checkHasResizeParam(ImgFormatInfo formatInfo) {
        if (formatInfo.getWidth() <= 0 && formatInfo.getHeight() <= 0) {
            return;
        }
        String url = formatInfo.getOriginUrl();
        if (url != null) {
            String[] urlSplit = url.split("/");
            for (int j = urlSplit.length - 1; j >= 0; --j) {
                String s = urlSplit[j];
                if (!s.contains("resize")) continue;
                int width = 0;
                int height = 0;
                String[] sizeSplit = s.split(",");
                for (int i = 0; i < sizeSplit.length; ++i) {
                    if (i == 0) continue;
                    int size = Integer.parseInt(sizeSplit[i].substring(2));
                    if (i == 1) {
                        width = size;
                        continue;
                    }
                    height = size;
                }
                double mul = 1.5;
                boolean isPrintWidth = false;
                boolean isPrintHeight = false;
                if (formatInfo.getWidth() > 0 && (double)width > (double)formatInfo.getWidth() * mul) {
                    isPrintWidth = true;
                }
                if (formatInfo.getHeight() > 0 && (double)height > (double)formatInfo.getHeight() * mul) {
                    isPrintHeight = true;
                }
                if (isPrintWidth) {
                    MLog.error((Object)"ImageLoader_monitor", "url\u5bbd\u9ad8\u62fc\u63a5\u5927\u4e8e\u63a7\u4ef6\u5b9e\u9645\u5bbd\u9ad8\uff0c\u63a7\u4ef6\u5bbd\uff1a%d\uff0curl\u5bbd\uff1a%d\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u8bbe\u7f6e\uff01\u5728\u786e\u5b9aImageView\u5927\u5c0f\u60c5\u51b5\u4e0b\u5efa\u8bae\u76f4\u63a5\u4f7f\u7528ImageLoader\u81ea\u52a8\u62fc\u63a5\u529f\u80fd\uff0c\u65e0\u987b\u4e0a\u5c42\u62fc\u63a5 url: %s", formatInfo.getWidth(), width, url);
                }
                if (!isPrintHeight) break;
                MLog.error((Object)"ImageLoader_monitor", "url\u5bbd\u9ad8\u62fc\u63a5\u5927\u4e8e\u63a7\u4ef6\u5b9e\u9645\u5bbd\u9ad8\uff0c\u63a7\u4ef6\u9ad8\uff1a%d\uff0curl\u9ad8\uff1a%d\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u8bbe\u7f6e\uff01\u5728\u786e\u5b9aImageView\u5927\u5c0f\u60c5\u51b5\u4e0b\u5efa\u8bae\u76f4\u63a5\u4f7f\u7528ImageLoader\u81ea\u52a8\u62fc\u63a5\u529f\u80fd\uff0c\u65e0\u987b\u4e0a\u5c42\u62fc\u63a5 url: %s", formatInfo.getHeight(), height, url);
                break;
            }
        }
    }

    private static Object checkFinalRequestThumbnail(ImageView imageView, @Nullable Object thumbnail, int width, int height, boolean useHeif) {
        if (thumbnail instanceof String) {
            String realRequestUrl = (String)thumbnail;
            realRequestUrl = ImageLoader.checkFinalRequestUrl(imageView, realRequestUrl, width, height, useHeif);
            if (mSetupData.isDebug()) {
                MLog.info(TAG, "checkFinalRequestThumbnail origin url: %s, final url: %s, width: %d, height: %d, useHeif: %b", thumbnail, realRequestUrl, width, height, useHeif);
            }
            return realRequestUrl;
        }
        return thumbnail;
    }

    private static String getCacheKey(String url) {
        return url;
    }

    private static String getCacheKey(String url, int width, int height) {
        return TextUtils.isEmpty((CharSequence)url) ? url : "#W" + width + "#H" + height + url;
    }

    public static boolean addBitmapToCache(String key, BitmapDrawable bitmap) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        ImageLoader.getYYImageCache().addBitmapToCache(ImageLoader.getCacheKey(key), bitmap);
        return true;
    }

    public static boolean addBitmapToCache(String key, BitmapDrawable bitmap, ImageConfig imageConfig) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        if (imageConfig == null) {
            ImageLoader.getYYImageCache().addBitmapToCache(ImageLoader.getCacheKey(key), bitmap);
        } else {
            ImageLoader.getYYImageCache().addBitmapToCache(ImageLoader.getCacheKey(key, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight()), bitmap);
        }
        return true;
    }

    public static void removeBitmapFromCache(String key, ImageConfig imageConfig) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (imageConfig == null) {
            ImageLoader.getYYImageCache().removeBitmapFromCache(ImageLoader.getCacheKey(key));
        } else {
            ImageLoader.getYYImageCache().removeBitmapFromCache(ImageLoader.getCacheKey(key, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight()));
        }
    }

    @Nullable
    public static BitmapDrawable getBitmapFromCache(String key) {
        return ImageLoader.getBitmapFromCache(key, null);
    }

    public static BitmapDrawable getBitmapFromCache(String key, ImageConfig imageConfig) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (imageConfig == null) {
            return ImageLoader.getYYImageCache().getBitmapFromMemCache(ImageLoader.getCacheKey(key));
        }
        return ImageLoader.getYYImageCache().getBitmapFromMemCache(ImageLoader.getCacheKey(key, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight()));
    }

    public static void removeBitmapFromCache(String key) {
        ImageLoader.removeBitmapFromCache(key, null);
    }

    public static void pauseRequests() {
        ImageLoader.getImageHandler().pauseRequest(ImageLoader.getContext(), false);
    }

    public static void resumeRequests() {
        ImageLoader.getImageHandler().resumeRequest(ImageLoader.getContext(), false);
    }

    public static void pauseRequests(Context context) {
        if (context == null) {
            return;
        }
        ImageLoader.getImageHandler().pauseRequest(context, true);
    }

    public static void resumeRequests(Context context) {
        if (context == null) {
            return;
        }
        ImageLoader.getImageHandler().resumeRequest(context, true);
    }

    public static ImageData.Builder with(ImageView imageView, String url) {
        return new ImageData.Builder(imageView, url);
    }

    public static ImageBitmapData.Builder withBitmap(Context context, String url, BitmapLoadListener listener) {
        return new ImageBitmapData.Builder(context, null, url).setListener(listener);
    }

    public static void preloadImage(Context context, String url) {
        ImageLoader.preloadImage(context, url, 0, 0);
    }

    public static void preloadImage(Context context, String url, int width, int height, boolean useHeif) {
        if (context == null || TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        String finalUrl = ImageLoader.checkFinalRequestUrl(null, url, width, height, useHeif);
        ImageLoader.checkUrlHasResize(finalUrl);
        ImageLoader.getImageHandler().preload(context, finalUrl, width, height);
    }

    public static void preloadImage(Context context, String url, int width, int height) {
        ImageLoader.preloadImage(context, url, width, height, false);
    }

    public static boolean loadBlurImage(ImageView v, String url, int placeholderId) {
        return ImageLoader.loadBlurImage(v, url, 25, placeholderId);
    }

    public static boolean loadBlurImage(ImageView v, String url, int radius, int placeholderId) {
        ImageLoader.clear(v);
        ImageData imageData = new ImageData(url);
        ImageLoader.setImageDataToTag(v, imageData);
        ImageLoader.checkLoadSize(v, imageData);
        imageData.url = ImageLoader.checkFinalRequestUrl(v, url, imageData.width, imageData.height, imageData.useHeif);
        if (placeholderId > 0) {
            v.setImageResource(placeholderId);
        }
        ImageLoader.loadBlur(v, imageData.url, url, radius, null, false);
        return false;
    }

    public static void loadBlurImageByBlurPlaceholder(ImageView v, String url, byte[] blurImageData) {
        if (!ImageLoader.loadBlurImage(v, url, 0)) {
            ImageLoader.loadBlur(v, blurImageData, url, 25, null, true);
        }
    }

    public static void loadImageByBlurPlaceholder(@Nullable ImageView v, @Nullable String url, byte[] blurImageData, int width, int height) {
        ImageLoader.with(v, url).setSize(width, height).load();
        if (!YYImageUtils.isHttpRequest(url)) {
            MLog.debug(TAG, "loadImageByBlurPlaceholder url: %s is not http, no need load blur placeholder", new Object[0]);
            return;
        }
        if (blurImageData != null && blurImageData.length > 0) {
            ImageLoader.loadBlur(v, blurImageData, url, 25, null, true);
        }
    }

    public static void loadImageByBlurPlaceholder(@Nullable ImageView v, @Nullable String url, @Nullable String blurUrl, int width, int height) {
        ImageLoader.with(v, url).setSize(width, height).load();
        if (!YYImageUtils.isHttpRequest(url)) {
            MLog.debug(TAG, "loadImageByBlurPlaceholder url: %s is not http, no need load blur placeholder", new Object[0]);
            return;
        }
        ImageLoader.loadBlur(v, blurUrl, url, 25, null, true);
    }

    public static void loadImageByBlurPlaceholder(@Nullable ImageView v, @Nullable String url, @Nullable String blurUrl, int width, int height, @Nullable ImageLoadListener listener) {
        ImageLoader.with(v, url).setSize(width, height).setListener(listener).load();
        if (!YYImageUtils.isHttpRequest(url)) {
            MLog.debug(TAG, "loadImageByBlurPlaceholder url: %s is not http, no need load blur placeholder", new Object[0]);
            return;
        }
        ImageLoader.loadBlur(v, blurUrl, url, 25, null, true);
    }

    private static void loadBlur(@Nullable ImageView imageView, final @Nullable byte[] blurBytes, final @Nullable String callUrl, int radius, final @Nullable BitmapLoadListener listener, final boolean checkLoadSuccess) {
        if (imageView == null || blurBytes == null || blurBytes.length <= 0) {
            return;
        }
        MLog.debug(TAG, "loadBlur blurBytes: " + blurBytes.length, new Object[0]);
        final WeakReference<ImageView> viewRef = new WeakReference<ImageView>(imageView);
        ImageBitmapData bitmapData = new ImageBitmapData(callUrl){

            @Override
            public Object getLoadObj() {
                return blurBytes;
            }
        };
        bitmapData.listener = new BitmapLoadListener(){

            @Override
            public void onResourceReady(Bitmap resource) {
                ImageData imageData;
                ImageView view = (ImageView)viewRef.get();
                if (view == null) {
                    MLog.debug(ImageLoader.TAG, "loadBlur fail, view has recycled", new Object[0]);
                    return;
                }
                if (!(resource.isRecycled() || (imageData = ImageLoader.checkData(view)) == null || !TextUtils.equals((CharSequence)imageData.originUrl, (CharSequence)callUrl) || checkLoadSuccess && imageData.loadSuccess)) {
                    view.setImageBitmap(resource);
                }
                if (listener != null) {
                    listener.onResourceReady(resource);
                }
            }

            @Override
            public void onLoadFailed(Exception e) {
                MLog.error((Object)ImageLoader.TAG, "loadBlur error, blurBytes: " + blurBytes.length, e, new Object[0]);
                if (listener != null) {
                    listener.onLoadFailed(e);
                }
            }
        };
        bitmapData.transformations = new YYBitmapTransformation[]{new BlurTransformation(radius)};
        ImageLoader.getImageHandler().loadBitmap(imageView.getContext(), bitmapData);
    }

    private static void loadBlur(@Nullable ImageView imageView, final @Nullable String blurUrl, final @Nullable String callUrl, int radius, final @Nullable BitmapLoadListener listener, final boolean checkLoadSuccess) {
        if (imageView == null) {
            return;
        }
        MLog.debug(TAG, "loadBlur blurUrl: " + blurUrl, new Object[0]);
        ImgFormatInfo imgFormatInfo = new ImgFormatInfo(blurUrl, -1, -1);
        if (sDelegate != null) {
            imgFormatInfo.setFormat(sDelegate.canUseFormat(imageView, blurUrl, imgFormatInfo));
        }
        String finalUrl = ImageFormatTransformer.getRealRequestUrl(imgFormatInfo);
        ImageLoader.checkUrlHasResize(finalUrl);
        final WeakReference<ImageView> viewRef = new WeakReference<ImageView>(imageView);
        ImageBitmapData bitmapData = new ImageBitmapData(callUrl);
        bitmapData.url = finalUrl;
        bitmapData.transformations = new YYBitmapTransformation[]{new BlurTransformation(radius)};
        bitmapData.listener = new BitmapLoadListener(){

            @Override
            public void onResourceReady(Bitmap bitmap) {
                ImageData imageData;
                ImageView view = (ImageView)viewRef.get();
                if (view == null) {
                    MLog.debug(ImageLoader.TAG, "loadBlur fail, view has recycled", new Object[0]);
                    return;
                }
                if (!(bitmap.isRecycled() || (imageData = ImageLoader.checkData(view)) == null || !TextUtils.equals((CharSequence)imageData.originUrl, (CharSequence)callUrl) || checkLoadSuccess && imageData.loadSuccess)) {
                    view.setImageBitmap(bitmap);
                }
                if (listener != null) {
                    listener.onResourceReady(bitmap);
                }
            }

            @Override
            public void onLoadFailed(Exception e) {
                MLog.error((Object)ImageLoader.TAG, "loadBlur error, url: " + blurUrl, e, new Object[0]);
                if (listener != null) {
                    listener.onLoadFailed(e);
                }
            }
        };
        ImageLoader.getImageHandler().loadBitmap(imageView.getContext(), bitmapData);
    }

    public static void loadImage(ImageView recycleImageView, int placeholderId) {
        ImageLoader.with(recycleImageView, null).placeholder(placeholderId).load();
    }

    public static void loadImage(ImageView recycleImageView, String url) {
        ImageLoader.with(recycleImageView, url).load();
    }

    public static void loadImage(ImageView recycleImageView, String url, int placeholderId) {
        ImageLoader.with(recycleImageView, url).placeholder(placeholderId).load();
    }

    public static void loadImage(ImageView recycleImageView, String url, int placeholderId, int errorID) {
        ImageLoader.with(recycleImageView, url).placeholder(placeholderId).error(errorID).load();
    }

    public static void loadImage(ImageView recycleImageView, String url, int placeholderId, int errorId, ImageLoadListener listener) {
        ImageLoader.with(recycleImageView, url).placeholder(placeholderId).error(errorId).setListener(listener).load();
    }

    public static void loadImage(ImageView recycleImageView, String url, Drawable placeholderDrawable) {
        ImageLoader.with(recycleImageView, url).placeholder(placeholderDrawable).load();
    }

    public static void loadImage(ImageView recycleImageView, String url, Drawable placeholderDrawable, Drawable errorDrawable, ImageLoadListener listener) {
        ImageLoader.with(recycleImageView, url).placeholder(placeholderDrawable).error(errorDrawable).setListener(listener).load();
    }

    public static void clear(ImageView recycleImageView) {
        try {
            ImageLoader.getImageHandler().clearRequest(ImageLoader.getContext(), recycleImageView);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void clear(@Nullable Target<?> target) {
        try {
            ImageLoader.getImageHandler().clearRequest(ImageLoader.getContext(), target);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void clearDiskCache() {
        ImageLoader.getImageHandler().clearDiskCache(ImageLoader.getContext(), null);
    }

    static void loadImage(ImageView imageView, ImageData imageData) {
        if (imageData == null || imageView == null) {
            return;
        }
        ImageLoader.checkLoadSize(imageView, imageData);
        imageData.url = ImageLoader.checkFinalRequestUrl(imageView, imageData.originUrl, imageData.width, imageData.height, imageData.useHeif);
        imageData.thumbnail = ImageLoader.checkFinalRequestThumbnail(imageView, imageData.originThumbnail, imageData.thumbnailW, imageData.thumbnailH, imageData.useHeif);
        if (imageData.needCheckUrl) {
            ImageLoader.checkUrlHasResize(imageData.url);
        }
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread(() -> ImageLoader.loadImageInner(imageView, imageData));
        } else {
            ImageLoader.loadImageInner(imageView, imageData);
        }
    }

    public static void loadCorpImageWithNineBg(@Nullable ImageView recycleImageView, @Nullable String url, final int placeholderNinePngId) {
        if (recycleImageView == null) {
            return;
        }
        final WeakReference<ImageView> viewRef = new WeakReference<ImageView>(recycleImageView);
        recycleImageView.setBackgroundResource(placeholderNinePngId);
        ImageLoader.with(recycleImageView, url).setListener(new ImageLoadListener(){

            @Override
            public void onLoadFailed(Exception e) {
                ImageView lastView = (ImageView)viewRef.get();
                if (lastView != null) {
                    lastView.setBackgroundResource(placeholderNinePngId);
                }
            }

            @Override
            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                ImageView lastView = (ImageView)viewRef.get();
                if (lastView != null) {
                    lastView.setBackground(null);
                }
            }
        }).load();
    }

    protected static void loadImageInner(ImageView imageView, ImageData imageData) {
        if (imageData.useCacheForOrigin) {
            BitmapDrawable drawableCache = ImageLoader.getBitmapFromCache(imageData.originUrl);
            if (drawableCache != null) {
                MLog.debug(TAG, "loadImageInner get cache for origin url: " + imageData.originUrl, new Object[0]);
                if (imageView != null) {
                    ImageLoader.clearRequest(imageView);
                    imageView.setImageDrawable((Drawable)drawableCache);
                    ImageLoader.setImageDataToTag(imageView, imageData);
                }
                if (imageData.listener != null) {
                    imageData.listener.onResourceReady(drawableCache.getBitmap(), true, DataSource.MEMORY_CACHE);
                }
                return;
            }
            MLog.debug(TAG, "loadImageInner get no cache for origin url: %s", imageData.originUrl);
        }
        imageData.loadId = ImageLoader.generateLoadId();
        List last = imageData.monitors;
        ArrayList<IMonitor> finalMonitors = new ArrayList<IMonitor>(sMonitorList);
        if (last != null && !last.isEmpty()) {
            finalMonitors.addAll(last);
        }
        imageData.monitors = finalMonitors;
        ImageLoader.setImageDataToTag(imageView, imageData);
        ImageLoader.getImageHandler().loadImage(imageView, imageData);
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener) {
        ImageLoader.withBitmap(context, url, listener).setSize(ImageLoader.getDefaultMaxWidth(), ImageLoader.getDefaultMaxHeight()).load();
    }

    private static void loadBitmapInner(Context context, ImageView recycleImageView, ImageBitmapData bitmapData) {
        BitmapDrawable drawableFromCache;
        if (bitmapData.useCacheForOrigin && (drawableFromCache = ImageLoader.getBitmapFromCache(bitmapData.originUrl)) != null) {
            MLog.debug(TAG, "loadBitmapInner get cache for origin url: " + bitmapData.originUrl, new Object[0]);
            if (recycleImageView != null) {
                ImageLoader.clearRequest(recycleImageView);
                recycleImageView.setImageDrawable((Drawable)drawableFromCache);
                ImageLoader.setBitmapDataToTag(recycleImageView, bitmapData);
            }
            if (bitmapData.listener != null) {
                bitmapData.listener.onResourceReady(drawableFromCache.getBitmap());
            }
            return;
        }
        bitmapData.loadId = ImageLoader.generateLoadId();
        List last = bitmapData.monitors;
        ArrayList<IMonitor> finalMonitors = new ArrayList<IMonitor>(sMonitorList);
        if (last != null && !last.isEmpty()) {
            finalMonitors.addAll(last);
        }
        bitmapData.monitors = finalMonitors;
        Context finalContext = context;
        if (finalContext == null && recycleImageView != null) {
            finalContext = recycleImageView.getContext();
        }
        ImageLoader.setBitmapDataToTag(recycleImageView, bitmapData);
        ImageLoader.getImageHandler().loadBitmap(finalContext, bitmapData);
    }

    static void loadBitmap(Context context, ImageView imageView, ImageBitmapData bitmapData) {
        if (bitmapData == null) {
            return;
        }
        ImageLoader.checkLoadSize(imageView, bitmapData);
        bitmapData.url = ImageLoader.checkFinalRequestUrl(imageView, bitmapData.originUrl, bitmapData.width, bitmapData.height, bitmapData.useHeif);
        bitmapData.thumbnail = ImageLoader.checkFinalRequestThumbnail(imageView, bitmapData.originThumbnail, bitmapData.thumbnailW, bitmapData.thumbnailH, bitmapData.useHeif);
        if (bitmapData.needCheckUrl) {
            ImageLoader.checkUrlHasResize(bitmapData.url);
        }
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread(() -> ImageLoader.loadBitmapInner(context, imageView, bitmapData));
        } else {
            ImageLoader.loadBitmapInner(context, imageView, bitmapData);
        }
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener, int maxWidth, int maxHeight) {
        ImageLoader.withBitmap(context, url, listener).setSize(maxWidth, maxHeight).load();
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener, int maxWidth, int maxHeight, boolean skipCache) {
        ImageLoader.withBitmap(context, url, listener).setSize(maxWidth, maxHeight).skipMemCache(skipCache).skipDiskCache(skipCache).load();
    }

    public static void loadImageResource(int resource, ImageView imageView, ImageConfig imageConfig) {
        BitmapDrawable bitmapDrawable = ImageLoader.getBitmapDrawable(resource, imageConfig);
        if (imageView != null) {
            imageView.setImageDrawable((Drawable)bitmapDrawable);
        }
    }

    public static void preloadBitmap(String url) {
        ImageLoader.preloadBitmap(url, -1, -1);
    }

    public static BitmapDrawable getBitmapDrawable(int resourceId, ImageConfig imageConfig) {
        Bitmap loadingBitmap;
        if (resourceId <= 0 || imageConfig == null) {
            return null;
        }
        String key = ImageLoader.getCacheKey(String.valueOf(resourceId), imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight());
        BitmapDrawable loadingBitmapDrawable = ImageLoader.getBitmapFromCache(key);
        if (loadingBitmapDrawable == null && (loadingBitmap = ImageUtil.decodeSampledBitmapFromResourceId(ImageLoader.getContext(), resourceId, imageConfig)) != null) {
            loadingBitmapDrawable = new BitmapDrawable(ImageLoader.getContext().getResources(), loadingBitmap);
            ImageLoader.addBitmapToCache(key, loadingBitmapDrawable);
        }
        return loadingBitmapDrawable;
    }

    public static void preloadBitmap(String url, int maxWidth, int maxHeight) {
        int height;
        int width;
        String key;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (maxWidth > 0 && maxHeight > 0) {
            key = ImageLoader.getCacheKey(url, maxWidth, maxHeight);
            width = maxWidth;
            height = maxHeight;
        } else {
            key = ImageLoader.getCacheKey(url);
            width = ImageLoader.getDefaultMaxWidth();
            height = ImageLoader.getDefaultMaxHeight();
        }
        if (ImageLoader.getBitmapFromCache(key) != null) {
            return;
        }
        new ImageBitmapData.Builder(ImageLoader.getContext(), null, url).setListener(new BitmapLoadListener(){

            @Override
            public void onLoadFailed(Exception e) {
            }

            @Override
            public void onResourceReady(Bitmap bitmap) {
                if (bitmap != null) {
                    ImageLoader.addBitmapToCache(key, new BitmapDrawable(ImageLoader.getContext().getResources(), bitmap));
                }
            }
        }).setSize(width, height).skipMemCache(true).skipDiskCache(true).load();
    }

    public static void loadBitmap(ImageView imageView, String url, int placeResId) {
        if (imageView == null) {
            return;
        }
        if (mSetupData.isDebug()) {
            MLog.debug(TAG, "loadBitmap with imageView url: %s", url);
        }
        ImageLoader.loadBitmap(imageView, url, placeResId, -1, -1);
    }

    public static void loadBitmap(ImageView imageView, String url, int placeResId, int maxWidth, int maxHeight) {
        if (imageView == null) {
            return;
        }
        if (mSetupData.isDebug()) {
            MLog.debug(TAG, "loadBitmap with imageView url: %s, w: %d, h: %d", url, maxWidth, maxHeight);
        }
        imageView.setImageResource(placeResId);
        final WeakReference<ImageView> viewRef = new WeakReference<ImageView>(imageView);
        ImageBitmapData bitmapData = new ImageBitmapData(url);
        bitmapData.skipMemCache = true;
        bitmapData.useCacheForOrigin = true;
        bitmapData.width = maxWidth;
        bitmapData.height = maxHeight;
        bitmapData.listener = new BitmapLoadListener(){

            @Override
            public void onResourceReady(Bitmap bitmap) {
                ImageView v;
                if (bitmap != null && !bitmap.isRecycled() && (v = (ImageView)viewRef.get()) != null) {
                    v.setImageBitmap(bitmap);
                }
            }

            @Override
            public void onLoadFailed(Exception e) {
                MLog.debug(ImageLoader.TAG, "loadBitmap error: " + e, new Object[0]);
            }
        };
        ImageLoader.loadBitmap(ImageLoader.getContext(), imageView, bitmapData);
    }

    private static int getDefaultMaxWidth() {
        int width = (int)((float)ImageConfig.fullImageConfig().getImagePrecision().getWidth() * 0.85f);
        if (width <= 0) {
            width = Integer.MIN_VALUE;
        }
        return width;
    }

    private static int getDefaultMaxHeight() {
        int height = (int)((float)ImageConfig.fullImageConfig().getImagePrecision().getHeight() * 0.85f);
        if (height <= 0) {
            height = Integer.MIN_VALUE;
        }
        return height;
    }

    public static void savePhotoSync(String url, File saveTo) throws Exception {
        if (mSetupData.isDebug() && YYTaskExecutor.isMainThread()) {
            throw new RuntimeException("please don not call savePhotoSync in Main Thread!");
        }
        if (TextUtils.isEmpty((CharSequence)url) || saveTo == null) {
            throw new RuntimeException("savePhotoSync : url or saveto is null");
        }
        FutureTarget<File> future = ImageLoader.getImageHandler().loadFile(ImageLoader.getContext(), url);
        File cacheFile = (File)future.get();
        if (cacheFile == null) {
            throw new RuntimeException("savePhotoSync : load url error" + url);
        }
        YYFileUtils.copyFile(cacheFile, saveTo);
        ImageLoader.loadBitmap(ImageLoader.getContext(), cacheFile.getAbsolutePath(), null);
    }

    public static void savePhotoSyncToMedia(String url, File saveTo, String fileName) throws Exception {
        if (mSetupData.isDebug() && YYTaskExecutor.isMainThread()) {
            throw new RuntimeException("please don not call savePhotoSyncToMedia in Main Thread!");
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new RuntimeException("savePhotoSyncToMedia : url or saveto is null");
        }
        FutureTarget<File> future = ImageLoader.getImageHandler().loadFile(ImageLoader.getContext(), url);
        File cacheFile = (File)future.get();
        if (cacheFile != null) {
            if (SdkVersionUtils.hasScopedStorage()) {
                FileOperatorQ.INSTANCE.saveMediaFile(cacheFile.getAbsolutePath(), false, fileName);
            } else {
                YYFileUtils.copyFile(cacheFile, saveTo);
            }
        } else {
            throw new RuntimeException("savePhotoSyncToMedia : load url error" + url);
        }
        ImageLoader.loadBitmap(ImageLoader.getContext(), cacheFile.getAbsolutePath(), null);
    }

    private static void handlePhotoSave(@NonNull String url, final @NonNull File saveTo, final ISavePicListener listener) {
        ImageBitmapData bitmapData = new ImageBitmapData(url);
        bitmapData.listener = new BitmapLoadListener(){

            @Override
            public void onResourceReady(final Bitmap bitmap) {
                if (bitmap == null) {
                    this.onLoadFailed(new Exception("bitmap is null"));
                    return;
                }
                YYTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        FileOutputStream outputStream = null;
                        try {
                            outputStream = new FileOutputStream(saveTo);
                            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
                            YYTaskExecutor.postToMainThread(() -> {
                                if (listener != null) {
                                    listener.onSuccess();
                                }
                            });
                        }
                        catch (Exception e) {
                            this.onLoadFailed(e);
                        }
                        finally {
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }

            @Override
            public void onLoadFailed(final Exception e) {
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onFailed(e);
                        }
                    }
                });
            }
        };
        ImageLoader.getImageHandler().loadBitmap(ImageLoader.getContext(), bitmapData);
    }

    public static void savePhotoSync(String url, File saveTo, ISavePicListener listener) {
        if (TextUtils.isEmpty((CharSequence)url) || saveTo == null) {
            YYTaskExecutor.postToMainThread(() -> {
                if (listener != null) {
                    listener.onFailed(new Exception("savePhotoSync fail, url or saveTo is null"));
                }
            });
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute(() -> ImageLoader.handlePhotoSave(url, saveTo, listener));
        } else {
            ImageLoader.handlePhotoSave(url, saveTo, listener);
        }
    }

    public static Bitmap getBitmapFromCustomDrawable(Drawable drawable) {
        try {
            if (drawable != null) {
                if (drawable instanceof GifDrawable) {
                    return ((GifDrawable)drawable).getFirstFrame();
                }
                if (drawable instanceof BitmapDrawable) {
                    return ((BitmapDrawable)drawable).getBitmap();
                }
                if (drawable instanceof TransitionDrawable) {
                    TransitionDrawable td = (TransitionDrawable)drawable;
                    int index = td.getNumberOfLayers();
                    Drawable d = null;
                    for (int i = 0; i < index; ++i) {
                        d = td.getDrawable(i);
                        if (!(d instanceof BitmapDrawable)) continue;
                        return ((BitmapDrawable)d).getBitmap();
                    }
                }
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, "getBitmapFromCustomDrawable error", ex, new Object[0]);
        }
        return null;
    }

    public static void clearMemory() {
        MLog.info(TAG, "clearMemory!", new Object[0]);
        ImageLoader.getImageHandler().clearMemory(ImageLoader.getContext());
        if (sNormalCache != null) {
            sNormalCache.cleanMemCache();
        }
    }

    public static void trimMemory(int level) {
        MLog.info(TAG, "trimMemory:  " + level, new Object[0]);
        ImageLoader.getImageHandler().trimMemory(ImageLoader.getContext(), level);
        if (sNormalCache != null) {
            if (level >= 40) {
                sNormalCache.cleanMemCache();
            } else {
                sNormalCache.cleanHalfMemCache();
            }
        }
    }

    private static boolean recycle(RecycleImageView imageView) {
        Object recycled;
        if (imageView == null) {
            return false;
        }
        String from = "";
        if (mSetupData.isDebug() && sDebugSwitch && imageView instanceof RecycleImageView) {
            from = imageView.getFrom();
        }
        if (!mSetupData.isRecycleSwitch()) {
            MLog.warn(TAG, "recycle fail, recycle switch is off", new Object[0]);
            return false;
        }
        if (mSetupData.isDebug() && sDebugSwitch) {
            MLog.debug(TAG, "start recycle imageView: %s", imageView);
        }
        if ((recycled = imageView.getTag(R.id.yy_recycled)) instanceof Boolean && ((Boolean)recycled).booleanValue() && imageView.getImageDrawableInner() == null) {
            if (mSetupData.isDebug() && sDebugSwitch) {
                MLog.info(TAG + from, "ImageView has recycled:%s", imageView);
            }
            return false;
        }
        Object data = imageView.getTag(R.id.yy_image_data_id);
        String url = "";
        boolean canRecycle = true;
        if (data instanceof ImageData) {
            ImageData imageData = (ImageData)data;
            url = imageData.url;
            canRecycle = imageData.canRecycle;
        } else if (data instanceof ImageBitmapData) {
            ImageBitmapData imageData = (ImageBitmapData)data;
            url = imageData.url;
            canRecycle = imageData.canRecycle;
        } else {
            if (mSetupData.isDebug() && sDebugSwitch) {
                MLog.info(TAG + from, "ImageView can not recycle:%s, %s", data, imageView);
            }
            return false;
        }
        if (!StringUtils.isEmpty(url) && canRecycle) {
            if (mSetupData.isDebug() && sDebugSwitch) {
                MLog.info(TAG + from, "ImageView recycle url:%s %s", imageView, url);
            }
            if (sDelegate != null) {
                sDelegate.onImageRecycle();
            }
            sResetDrawableToNulling = true;
            ImageLoader.clear(imageView);
            imageView.setImageDrawable(null);
            imageView.setTag(R.id.yy_recycled, true);
            sResetDrawableToNulling = false;
            return true;
        }
        if (mSetupData.isDebug() && sDebugSwitch) {
            MLog.info(TAG + from, "ImageView canRecycle:%b %s url:%s", canRecycle, imageView, url);
        }
        return false;
    }

    public static boolean recycleByNotVisible(RecycleImageView imageView) {
        if (mSetupData.isDebug() && sDebugSwitch) {
            MLog.debug(TAG, "recycleByNotVisible imageView: " + imageView.getClass().getName(), new Object[0]);
        }
        return ImageLoader.recycle(imageView);
    }

    private static boolean recovery(ImageView imageView) {
        Object recycled;
        if (imageView == null) {
            return false;
        }
        if (!mSetupData.isRecycleSwitch()) {
            MLog.warn(TAG, "recovery fail, recycler switch is off:%s", imageView);
            return false;
        }
        if (mSetupData.isDebug() && sDebugSwitch) {
            MLog.debug(TAG, "start recovery imageView: %s", imageView);
        }
        if ((recycled = imageView.getTag(R.id.yy_recycled)) instanceof Boolean && ((Boolean)recycled).booleanValue()) {
            String url;
            Object data = imageView.getTag(R.id.yy_image_data_id);
            ImageData imageData = null;
            ImageBitmapData imageBitmapData = null;
            if (data instanceof ImageData) {
                imageData = (ImageData)data;
            } else if (data instanceof ImageBitmapData) {
                imageBitmapData = (ImageBitmapData)data;
            }
            if (imageData == null && imageBitmapData == null) {
                if (mSetupData.isDebug() && sDebugSwitch) {
                    MLog.debug(TAG, "ImageView not recovery :%s, by data invalid", imageView);
                }
                return false;
            }
            String string2 = url = imageData != null ? imageData.url : imageBitmapData.url;
            if (StringUtils.isNotEmpty(url)) {
                if (mSetupData.isDebug() && sDebugSwitch) {
                    MLog.debug(TAG, "ImageView recovery url:%s, %s,", imageView, url);
                }
                if (imageData != null) {
                    imageData.needCheckUrl = false;
                    ImageLoader.loadImage(imageView, imageData);
                } else {
                    imageBitmapData.needCheckUrl = false;
                    ImageLoader.loadBitmap(null, imageView, imageBitmapData);
                }
                imageView.setTag(R.id.yy_recycled, (Object)false);
                if (mSetupData.isDebug() && sDebugSwitch) {
                    MLog.debug(TAG, "ImageView recovery url:%s, %s end", imageView, url);
                }
                return true;
            }
        } else if (mSetupData.isDebug() && sDebugSwitch) {
            MLog.debug(TAG, "start not recovery by not recycle imageView: %s", imageView);
        }
        return false;
    }

    public static void recoveryByBeVisible(ImageView imageView) {
        if (mSetupData.isDebug() && sDebugSwitch) {
            MLog.debug(TAG, "recoveryByBeVisible imageView: %s", imageView);
        }
        ImageLoader.recovery(imageView);
    }

    public static void onImageDrawableUpdated(ImageView imageView, Drawable drawable) {
        if (imageView instanceof RecycleImageView) {
            GifHandler.onImageDrawableUpdated((RecycleImageView)imageView, drawable);
        }
        if (imageView == null) {
            return;
        }
        if (sResetDrawableToNulling && drawable == null) {
            return;
        }
        if (mSetupData.isDebug() && sDebugSwitch) {
            MLog.info(TAG, "ImageView onImageDrawableUpdated:%s", imageView);
        }
        if (mSetupData.isRecycleSwitch()) {
            if (drawable == null) {
                Object data = imageView.getTag(R.id.yy_image_data_id);
                if (data instanceof ImageData) {
                    ImageData imageData = (ImageData)data;
                    imageData.canRecycle = false;
                } else if (data instanceof ImageBitmapData) {
                    ImageBitmapData imageData = (ImageBitmapData)data;
                    imageData.canRecycle = false;
                }
                imageView.setTag(R.id.yy_recycled, (Object)false);
                if (mSetupData.isDebug() && sDebugSwitch) {
                    MLog.info(TAG, "ImageView onImageDrawableUpdated drawable == null:%s", imageView);
                }
            } else {
                Object data = imageView.getTag(R.id.yy_image_data_id);
                if (data instanceof ImageData) {
                    ImageData imageData = (ImageData)data;
                    imageData.canRecycle = true;
                } else if (data instanceof ImageBitmapData) {
                    ImageBitmapData imageData = (ImageBitmapData)data;
                    imageData.canRecycle = true;
                }
            }
        } else {
            imageView.setTag(R.id.yy_recycled, (Object)false);
        }
    }

    static {
        mSetupData = new ImageLoaderSetup();
        sIndex = new AtomicInteger(0);
        sResetDrawableToNulling = false;
        sMonitorList = new CopyOnWriteArrayList<IMonitor>();
    }

    public static enum ImgFormat {
        ORIGIN("origin"),
        WEBP("webp"),
        HEIF("heif"),
        RESIZE("resize");

        @NotNull
        private final String desc;

        private ImgFormat(String desc) {
            this.desc = desc;
        }

        @NotNull
        public final String getDesc() {
            return this.desc;
        }
    }

    public static interface ImageLoaderDelegate {
        public ImgFormat canUseFormat(@Nullable ImageView var1, @Nullable String var2, @NonNull ImgFormatInfo var3);

        public boolean isBusinessTarget(@Nullable String var1);

        public String getBackup(@Nullable String var1);

        public boolean fixEmptyUrl();

        public boolean canAnim();

        public void onImageRecycle();
    }

    public static interface IMonitor {
        public void onStart(int var1, boolean var2, @Nullable String var3, int var4, int var5);

        public void onSuccess(int var1, @Nullable String var2, int var3, boolean var4, @Nullable DataSource var5, @Nullable PerformanceData var6);

        public void onError(int var1, @Nullable String var2, Exception var3);

        default public void onHappenHttpError(String url) {
        }

        public void onClear(int var1);
    }

    public static interface ImageLoadListener
    extends BaseLoadListener {
        public void onResourceReady(Object var1, boolean var2, DataSource var3);
    }

    public static interface BitmapLoadListener
    extends BaseLoadListener {
        public void onResourceReady(Bitmap var1);
    }

    public static interface BaseLoadListener {
        public void onLoadFailed(Exception var1);
    }

    public static interface ISavePicListener {
        public void onFailed(Exception var1);

        public void onSuccess();
    }
}

