/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import com.yy.base.imageloader.ImageFormatTransformer$WhenMappings;
import com.yy.base.imageloader.ImgFormatInfo;
import com.yy.base.logger.MLog;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J(\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00062\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/yy/base/imageloader/ImageFormatTransformer;", "", "()V", "HEIF_MATCH_RULE", "Lkotlin/text/Regex;", "IMAGE_FORMAT_HEIF", "", "OSS_PARAM_MATCH_RULE", "OSS_PARAM_PART", "OSS_RESIZE_MATCH_RULE", "OSS_RESIZE_PART", "OSS_SIZE_RULE", "OSS_WEBP_MATCH_RULE", "OSS_WEBP_PART", "TAG", "URL_IMAGE_FORMAT", "getRealRequestUrl", "formatInfo", "Lcom/yy/base/imageloader/ImgFormatInfo;", "handleForHeifNew", "imgFormatInfo", "handleForOrigin", "handleForResize", "handleForWebp", "handleUrlForOss", "", "urlBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "resizePart", "webpPart", "removeDuplicatedOssParam", "url", "removeOssParam", "testUrl", "framework-base_debug"})
public final class ImageFormatTransformer {
    private static final String OSS_PARAM_MATCH_RULE = "?x-oss-process=image";
    private static final String OSS_PARAM_PART = "?x-oss-process=image";
    private static final String OSS_RESIZE_PART = "/resize,";
    private static final String OSS_SIZE_RULE = "(w_([0-9]+),h_([0-9]+))|(h_([0-9]+),w_([0-9]+))";
    private static final Regex OSS_RESIZE_MATCH_RULE;
    private static final Regex OSS_WEBP_MATCH_RULE;
    private static final String OSS_WEBP_PART = "/format,webp";
    private static final Regex HEIF_MATCH_RULE;
    private static final String URL_IMAGE_FORMAT = "h_format";
    private static final String IMAGE_FORMAT_HEIF = "&h_format=heif";
    private static final String TAG = "ImageFormatTransformer";
    public static final ImageFormatTransformer INSTANCE;

    @JvmStatic
    @Nullable
    public static final String testUrl(@Nullable String url) {
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        CharSequence charSequence2 = builder;
        Object object = OSS_RESIZE_MATCH_RULE;
        boolean bl3 = false;
        if (object.containsMatchIn(charSequence2)) {
            MLog.debug(TAG, "testUrl has resize match url", new Object[0]);
        }
        object = builder;
        Regex regex = OSS_RESIZE_MATCH_RULE;
        String string2 = "";
        boolean bl4 = false;
        String t = regex.replaceFirst((CharSequence)object, string2);
        MLog.debug(TAG, "test format url: " + t, new Object[0]);
        return builder.toString();
    }

    @JvmStatic
    @Nullable
    public static final String getRealRequestUrl(@NotNull ImgFormatInfo formatInfo) {
        Intrinsics.checkParameterIsNotNull((Object)formatInfo, (String)"formatInfo");
        String newUrl = formatInfo.getOriginUrl();
        CharSequence charSequence = newUrl;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return newUrl;
        }
        if (!StringsKt.startsWith$default((String)newUrl, (String)"http", (boolean)false, (int)2, null)) {
            return INSTANCE.removeOssParam(newUrl);
        }
        try {
            formatInfo.setOriginUrl(INSTANCE.removeDuplicatedOssParam(newUrl));
            switch (ImageFormatTransformer$WhenMappings.$EnumSwitchMapping$0[formatInfo.getFormat().ordinal()]) {
                case 1: 
                case 2: {
                    return INSTANCE.handleForWebp(formatInfo);
                }
                case 3: {
                    return INSTANCE.handleForResize(formatInfo);
                }
                case 4: {
                    return INSTANCE.handleForOrigin(formatInfo);
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, "getRealRequestUrl error", ex, new Object[0]);
            return newUrl;
        }
    }

    private final void handleUrlForOss(StringBuilder urlBuilder, String resizePart, String webpPart) {
        if (!StringsKt.contains$default((CharSequence)urlBuilder, (CharSequence)"?x-oss-process=image", (boolean)false, (int)2, null)) {
            urlBuilder.append("?x-oss-process=image");
        }
        CharSequence charSequence = urlBuilder;
        Regex regex = OSS_RESIZE_MATCH_RULE;
        boolean bl = false;
        if (!regex.containsMatchIn(charSequence)) {
            int index;
            charSequence = resizePart;
            boolean bl2 = false;
            bl = false;
            if (!(charSequence == null || charSequence.length() == 0) && (index = urlBuilder.indexOf("?x-oss-process=image")) >= 0) {
                urlBuilder.insert(index + "?x-oss-process=image".length(), resizePart);
            }
        }
        CharSequence charSequence2 = urlBuilder;
        regex = OSS_WEBP_MATCH_RULE;
        bl = false;
        if (!regex.containsMatchIn(charSequence2)) {
            charSequence2 = webpPart;
            boolean bl3 = false;
            bl = false;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                urlBuilder.append(webpPart);
            }
        }
    }

    private final String handleForHeifNew(ImgFormatInfo imgFormatInfo) {
        return this.handleForWebp(imgFormatInfo) + IMAGE_FORMAT_HEIF;
    }

    private final String handleForWebp(ImgFormatInfo imgFormatInfo) {
        String string2 = imgFormatInfo.getOriginUrl();
        if (string2 == null) {
            string2 = "";
        }
        String url = string2;
        StringBuilder urlBuilder = new StringBuilder(url);
        String resizePart = null;
        if (imgFormatInfo.getWidth() > 0 && imgFormatInfo.getHeight() > 0) {
            resizePart = "/resize,w_" + imgFormatInfo.getWidth() + ",h_" + imgFormatInfo.getHeight();
        }
        this.handleUrlForOss(urlBuilder, resizePart, OSS_WEBP_PART);
        String string3 = urlBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"urlBuilder.toString()");
        return string3;
    }

    private final String handleForOrigin(ImgFormatInfo imgFormatInfo) {
        String string2 = imgFormatInfo.getOriginUrl();
        if (string2 == null) {
            string2 = "";
        }
        String resultUrl = string2;
        CharSequence charSequence = resultUrl;
        Regex regex = HEIF_MATCH_RULE;
        String string3 = "";
        boolean bl = false;
        resultUrl = regex.replace(charSequence, string3);
        StringBuilder urlBuilder = new StringBuilder(resultUrl);
        try {
            int index = urlBuilder.indexOf("?x-oss-process=image");
            if (index >= 0) {
                urlBuilder.delete(index, urlBuilder.length());
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, "handleForOrigin error", ex, new Object[0]);
        }
        String string4 = urlBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"urlBuilder.toString()");
        return string4;
    }

    private final String handleForResize(ImgFormatInfo imgFormatInfo) {
        String string2 = imgFormatInfo.getOriginUrl();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder urlBuilder = new StringBuilder(string2);
        String resizePart = null;
        if (imgFormatInfo.getWidth() > 0 && imgFormatInfo.getHeight() > 0) {
            resizePart = "/resize,w_" + imgFormatInfo.getWidth() + ",h_" + imgFormatInfo.getHeight();
        }
        this.handleUrlForOss(urlBuilder, resizePart, null);
        String string3 = urlBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"urlBuilder.toString()");
        String resultUrl = string3;
        CharSequence charSequence = resultUrl;
        Regex regex = OSS_WEBP_MATCH_RULE;
        String string4 = "";
        boolean bl = false;
        resultUrl = regex.replace(charSequence, string4);
        return resultUrl;
    }

    private final String removeOssParam(String url) {
        if (StringsKt.startsWith$default((String)url, (String)"null", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"?x-oss-process=image", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"/?x-oss-process=image", (boolean)false, (int)2, null)) {
            return "";
        }
        int index = StringsKt.indexOf$default((CharSequence)url, (String)"?x-oss-process=image", (int)0, (boolean)false, (int)6, null);
        if (index > 0) {
            String string2 = url;
            int n = 0;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string4;
        }
        return url;
    }

    private final String removeDuplicatedOssParam(String url) {
        int startIndex;
        String newUrl = url;
        int lastIndex = StringsKt.lastIndexOf$default((CharSequence)url, (String)"?x-oss-process=image", (int)0, (boolean)false, (int)6, null);
        if (lastIndex > 0 && (startIndex = StringsKt.indexOf$default((CharSequence)url, (String)"?x-oss-process=image", (int)0, (boolean)false, (int)6, null)) != lastIndex && startIndex > 0) {
            String string2 = url;
            int n = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(lastIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String endOssString = string4;
            string2 = url;
            n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string5 = string2;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, startIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string7 = string6;
            newUrl = stringBuilder.append(string7).append(endOssString).toString();
        }
        return newUrl;
    }

    private ImageFormatTransformer() {
    }

    static {
        ImageFormatTransformer imageFormatTransformer;
        INSTANCE = imageFormatTransformer = new ImageFormatTransformer();
        String string2 = "/resize,([\\w,]*)((w_([0-9]+),h_([0-9]+))|(h_([0-9]+),w_([0-9]+)))";
        boolean bl = false;
        OSS_RESIZE_MATCH_RULE = new Regex(string2);
        string2 = OSS_WEBP_PART;
        bl = false;
        OSS_WEBP_MATCH_RULE = new Regex(string2);
        string2 = "_heif_([0-9]+)";
        bl = false;
        HEIF_MATCH_RULE = new Regex(string2);
    }
}

