/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.map.KvoHashEntrySet;
import com.yy.base.event.kvo.map.KvoHashKeySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class KvoHashMap<K, V>
implements Map<K, V> {
    private final HashMap<K, V> mHashMap;
    public final KvoSource source;
    public final String name;

    public KvoHashMap(KvoSource source, String name) {
        this.source = source;
        this.name = name;
        this.mHashMap = new HashMap();
    }

    public KvoHashMap(KvoSource source, String name, int initialCapacity) {
        this.source = source;
        this.name = name;
        this.mHashMap = new HashMap(initialCapacity);
    }

    public KvoHashMap(KvoSource source, String name, int initialCapacity, float loadFactor) {
        this.source = source;
        this.name = name;
        this.mHashMap = new HashMap(initialCapacity, loadFactor);
    }

    @Override
    public int size() {
        return this.mHashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.mHashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.mHashMap.containsValue(value);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        return this.mHashMap.get(key);
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V getOrDefault(@Nullable Object key, @Nullable V defaultValue) {
        return this.mHashMap.getOrDefault(key, defaultValue);
    }

    @Override
    @RequiresApi(api=24)
    public void forEach(@NonNull BiConsumer<? super K, ? super V> action) {
        this.mHashMap.forEach(action);
    }

    @Override
    public void clear() {
        this.mHashMap.clear();
        this.notifyChange();
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V oldValue = this.mHashMap.put(key, value);
        this.notifyChange();
        return oldValue;
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        V value = this.mHashMap.remove(key);
        this.notifyChange();
        return value;
    }

    @Override
    @RequiresApi(api=24)
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        boolean success = this.mHashMap.remove(key, value);
        this.notifyChange();
        return success;
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V replace(K key, V value) {
        V oldValue = this.mHashMap.replace(key, value);
        this.notifyChange();
        return oldValue;
    }

    @Override
    @RequiresApi(api=24)
    public boolean replace(K key, @Nullable V oldValue, V newValue) {
        boolean success = this.mHashMap.replace(key, oldValue, newValue);
        this.notifyChange();
        return success;
    }

    @Override
    @NonNull
    public Set<K> keySet() {
        return new KvoHashKeySet<K>(this.mHashMap.keySet(), this);
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return this.mHashMap.values();
    }

    @Override
    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new KvoHashEntrySet<K, V>(this.mHashMap.entrySet(), this);
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V merge(K key, @NonNull V value, @NonNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V result = this.mHashMap.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
        this.notifyChange();
        return result;
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends V> m) {
        this.mHashMap.putAll(m);
        this.notifyChange();
    }

    @Override
    @RequiresApi(api=24)
    public void replaceAll(@NonNull BiFunction<? super K, ? super V, ? extends V> function) {
        this.mHashMap.replaceAll(function);
        this.notifyChange();
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V putIfAbsent(K key, V value) {
        V oldValue = this.mHashMap.putIfAbsent(key, value);
        this.notifyChange();
        return oldValue;
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V computeIfAbsent(K key, @NonNull Function<? super K, ? extends V> mappingFunction) {
        V value = this.mHashMap.computeIfAbsent((K)key, mappingFunction);
        this.notifyChange();
        return value;
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V computeIfPresent(K key, @NonNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V value = this.mHashMap.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        this.notifyChange();
        return value;
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V compute(K key, @NonNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V value = this.mHashMap.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        this.notifyChange();
        return value;
    }

    void notifyChange() {
        KvoEventIntent kvoEventIntent = KvoEventIntent.build(this.source, this.name);
        kvoEventIntent.setOldValue(this);
        kvoEventIntent.setNewValue(this);
        this.source.notifyEvent(kvoEventIntent);
    }
}

