/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.yy.base.event.kvo.map.KvoHashKeyIterator;
import com.yy.base.event.kvo.map.KvoHashMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

class KvoHashKeySet<K>
extends AbstractSet<K> {
    private final Set<K> mSet;
    private final KvoHashMap<K, Object> mKvoHashMap;

    public KvoHashKeySet(Set<K> set, KvoHashMap kvoHashMap) {
        this.mKvoHashMap = kvoHashMap;
        this.mSet = set;
    }

    @Override
    public int size() {
        return this.mSet.size();
    }

    @Override
    public void clear() {
        this.mSet.clear();
        this.mKvoHashMap.notifyChange();
    }

    @Override
    @NonNull
    public Iterator<K> iterator() {
        return new KvoHashKeyIterator<K>(this.mSet.iterator(), this.mKvoHashMap);
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.mSet.contains(o);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        boolean result = this.mSet.remove(o);
        this.mKvoHashMap.notifyChange();
        return result;
    }

    @Override
    @RequiresApi(api=24)
    @NonNull
    public Spliterator<K> spliterator() {
        return this.mSet.spliterator();
    }

    @Override
    @RequiresApi(api=24)
    public void forEach(@NonNull Consumer<? super K> action) {
        this.mSet.forEach(action);
    }
}

