/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.yy.base.event.kvo.map.KvoHashEntryIterator;
import com.yy.base.event.kvo.map.KvoHashMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

class KvoHashEntrySet<K, V>
extends AbstractSet<Map.Entry<K, V>> {
    private final Set<Map.Entry<K, V>> mSet;
    private final KvoHashMap<K, V> mKvoHashMap;

    public KvoHashEntrySet(Set<Map.Entry<K, V>> set, KvoHashMap<K, V> kvoHashMap) {
        this.mKvoHashMap = kvoHashMap;
        this.mSet = set;
    }

    @Override
    public int size() {
        return this.mSet.size();
    }

    @Override
    public void clear() {
        this.mSet.clear();
        this.mKvoHashMap.notifyChange();
    }

    @Override
    @NonNull
    public Iterator<Map.Entry<K, V>> iterator() {
        return new KvoHashEntryIterator<Map.Entry<K, V>>(this.mSet.iterator(), this.mKvoHashMap);
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.mSet.contains(o);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        boolean result = this.mSet.remove(o);
        this.mKvoHashMap.notifyChange();
        return result;
    }

    @Override
    @RequiresApi(api=24)
    @NonNull
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return this.mSet.spliterator();
    }

    @Override
    @RequiresApi(api=24)
    public void forEach(@NonNull Consumer<? super Map.Entry<K, V>> action) {
        this.mSet.forEach(action);
    }
}

