/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.helper;

import androidx.annotation.NonNull;
import com.yy.base.event.core.EventAction;
import com.yy.base.event.core.helper.EventHelper;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.list.KvoList;
import com.yy.base.event.kvo.map.KvoHashMap;
import com.yy.base.logger.MLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class KvoHelper {
    public static final int KVO_EVENT_ACTION_FLAG_FORCE_SYNC = 65536;
    public static final int KVO_EVENT_ACTION_FLAG_FORCE_MAIN = 131072;
    private static ConcurrentHashMap<Class<?>, ConcurrentHashMap<Class<?>, ArrayList<KvoMethodNode>>> clazzToKvoMethods = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<? extends KvoSource>, HashMap<String, KvoField>> allKvoSourceFields = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ArrayList<KvoMethodNode> getKvoMethods(@NonNull KvoSource source, @NonNull Object receiverObj) {
        ArrayList<KvoMethodNode> methodList;
        Class<?> receiverClass = receiverObj.getClass();
        Class<?> sourceClass = source.getClass();
        ConcurrentHashMap<Class<Object>, ArrayList<KvoMethodNode>> kvoMethods = clazzToKvoMethods.get(receiverClass);
        if (kvoMethods == null) {
            Class<?> clazz = receiverClass;
            synchronized (clazz) {
                kvoMethods = clazzToKvoMethods.get(receiverClass);
                if (kvoMethods == null) {
                    kvoMethods = new ConcurrentHashMap();
                    clazzToKvoMethods.put(receiverClass, kvoMethods);
                }
            }
        }
        if ((methodList = kvoMethods.get(sourceClass)) != null) {
            return methodList;
        }
        Class<?> clazz = sourceClass;
        synchronized (clazz) {
            methodList = kvoMethods.get(sourceClass);
            if (methodList != null) {
                return methodList;
            }
            methodList = KvoHelper.getReceiverClassKvoMethodNodes(source, receiverClass, sourceClass);
            kvoMethods.put(sourceClass, methodList);
        }
        return methodList;
    }

    @NonNull
    private static ArrayList<KvoMethodNode> getReceiverClassKvoMethodNodes(@NonNull KvoSource source, @NonNull Class<?> receiverClass, @NonNull Class<?> sourceClass) {
        ArrayList<KvoMethodNode> methodList = new ArrayList<KvoMethodNode>();
        List<Method> methods = EventHelper.getExcludeSystemMethods(receiverClass);
        HashMap<String, Method> nameMethodMap = new HashMap<String, Method>();
        for (Method method : methods) {
            String annotationName;
            KvoField kvoField;
            KvoMethodAnnotation annotation = method.getAnnotation(KvoMethodAnnotation.class);
            if (annotation == null || !annotation.sourceClass().isAssignableFrom(sourceClass) || (kvoField = source.declaredKvoField(annotationName = annotation.name())) == null) continue;
            Method preMethod = (Method)nameMethodMap.get(annotationName);
            if (preMethod != null && preMethod.getName().equals(method.getName())) {
                MLog.debug("KvoEvent", "getKvoMethods find method override, subMethod: " + preMethod.getName() + ", superMethod: " + method.getName(), new Object[0]);
                continue;
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            KvoMethodNode node = new KvoMethodNode();
            node.method = method;
            node.methodAnnotation = annotation;
            methodList.add(node);
            nameMethodMap.put(annotationName, method);
        }
        return methodList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static HashMap<String, KvoField> kvoFieldsContainerFor(@NonNull Class<? extends KvoSource> clazz) {
        HashMap<String, KvoField> kvoFields = allKvoSourceFields.get(clazz);
        if (kvoFields != null) {
            return kvoFields;
        }
        Class<? extends KvoSource> clazz2 = clazz;
        synchronized (clazz2) {
            kvoFields = allKvoSourceFields.get(clazz);
            if (kvoFields != null) {
                return kvoFields;
            }
            kvoFields = KvoHelper.buildKvoFieldsMap(clazz);
            allKvoSourceFields.put(clazz, kvoFields);
        }
        return kvoFields;
    }

    private static HashMap<String, KvoField> buildKvoFieldsMap(@NonNull Class<? extends KvoSource> clazz) {
        HashMap<String, KvoField> kvoFields = new HashMap<String, KvoField>();
        List<Field> fields = EventHelper.getExcludeSystemFields(clazz);
        for (Field field : fields) {
            KvoFieldAnnotation annotation = field.getAnnotation(KvoFieldAnnotation.class);
            if (annotation == null) continue;
            KvoField preField = kvoFields.get(annotation.name());
            if (preField == null) {
                KvoField kvoField = new KvoField();
                kvoField.field = field;
                kvoField.fieldAnnotation = annotation;
                kvoField.eventAction = KvoHelper.buildKvoFieldEventAction(annotation.name(), field);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                kvoFields.put(annotation.name(), kvoField);
                continue;
            }
            MLog.warn("KvoEvent", "two field in sub class and superclass has the same annotation name in souceclass : " + clazz.getSimpleName() + "; we will only pick the field in subclass, field name : " + annotation.name() + "; superclass : " + field.getDeclaringClass().getSimpleName() + "; subclass : " + preField.field.getDeclaringClass().getSimpleName(), new Object[0]);
        }
        return kvoFields;
    }

    private static EventAction buildKvoFieldEventAction(@NonNull String key, @NonNull Field field) {
        Class<?> type = field.getType();
        int flag = 0;
        if (KvoList.class.isAssignableFrom(type)) {
            flag = 196608;
        } else if (KvoHashMap.class.isAssignableFrom(type)) {
            flag = 65536;
        }
        return new EventAction(key, flag);
    }

    public static class KvoField {
        public Field field;
        public KvoFieldAnnotation fieldAnnotation;
        public EventAction eventAction;
    }

    public static class KvoMethodNode {
        public Method method;
        public KvoMethodAnnotation methodAnnotation;
    }
}

