/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.core.EventAction;
import com.yy.base.event.core.EventDispatcher;
import com.yy.base.event.core.EventReceiverList;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoEventReceiverList;
import com.yy.base.event.kvo.helper.KvoHelper;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import java.lang.reflect.Field;
import java.util.HashMap;

public class KvoSource
extends EventDispatcher {
    private final transient HashMap<String, KvoHelper.KvoField> mKvoValues = KvoHelper.kvoFieldsContainerFor(this.getClass());

    public void notifyKvoEvent(@NonNull String key) {
        KvoHelper.KvoField kvoField = this.declaredKvoField(key);
        if (kvoField == null) {
            return;
        }
        try {
            Object currentValue = kvoField.field.get(this);
            KvoEventIntent kvoEventIntent = KvoEventIntent.build(this, key);
            kvoEventIntent.setOldValue(currentValue);
            kvoEventIntent.setNewValue(currentValue);
            this.notifyEvent(kvoEventIntent);
        }
        catch (IllegalAccessException e) {
            MLog.error((Object)"KvoEvent", "get field value failed : " + e.toString(), new Object[0]);
        }
    }

    @Override
    protected EventReceiverList buildEventReceiverList(EventAction eventAction) {
        return new KvoEventReceiverList(eventAction, this);
    }

    public KvoHelper.KvoField declaredKvoField(String key) {
        return this.mKvoValues.get(key);
    }

    public void setValue(@NonNull String key, @Nullable Object newValue) {
        block4: {
            Object oldValue = null;
            try {
                KvoHelper.KvoField kvoField = this.declaredKvoField(key);
                if (kvoField == null) {
                    return;
                }
                Field targetField = kvoField.field;
                oldValue = targetField.get(this);
                if (!(oldValue != null ? oldValue.equals(newValue) : newValue == null)) {
                    targetField.set(this, newValue);
                    KvoEventIntent kvoEventIntent = KvoEventIntent.build(this, key);
                    kvoEventIntent.setOldValue(oldValue);
                    kvoEventIntent.setNewValue(newValue);
                    this.notifyEvent(kvoEventIntent);
                }
            }
            catch (Exception e) {
                MLog.error((Object)"KvoEvent", "notify kvo event failed:", e, new Object[0]);
                if (!RuntimeContext.sIsDebuggable) break block4;
                boolean switchOn = SettingFlags.getBoolean("pageautoswitch", false);
                boolean switchOnVoice = SettingFlags.getBoolean("pageautovoiceswitch", false);
                if (switchOn || switchOnVoice) break block4;
                throw new RuntimeException("exception when setValue, key: " + key + ", oldValue" + (oldValue == null ? "null" : oldValue.toString()) + ", newValue" + newValue + ", error: " + e.toString(), e);
            }
        }
    }
}

