/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.env;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.SparseLongArray;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateFormatUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.memory.MemoryUtil;
import java.util.Calendar;
import java.util.Date;

public class RuntimeContext {
    public static final int PHONE_LOW = 1;
    public static final int PHONE_MIDDLE = 2;
    public static final int PHONE_HIGH = 3;
    public static boolean sIsMainProcess = false;
    public static boolean sIsActivityStarted = false;
    public static String sPackageName = null;
    public static String sCurProcessName = null;
    public static long sProcessStartConsumeTime = -1L;
    public static Context sApplicationContext;
    public static boolean sIsDebuggable;
    public static long sMainActivityStartTime;
    public static long sAppOncreateTime;
    public static long sAppOncreateEndTime;
    private static boolean sIsInGray;
    private static volatile long sAppLoginTime;
    public static boolean sIsModuleAfterEnvInit;
    public static String sAppid;
    public static String sCrashAppId;
    public static boolean s64SoInsteadOf32So;
    private static ChannelHeartItem sMainChannel;
    private static ChannelHeartItem sCoexistence;
    public static String sPreLoadGameId;
    public static String sFirstGameDeepLink;
    public static boolean sIsAppStarted;
    public static volatile boolean sIsAppStartFinished;
    public static volatile boolean sIsServicesInited;
    public static volatile boolean sIsAppStartFinishAfterOneSecond;
    public static volatile boolean sIsAppStartFinishAfterThreeSecond;
    public static volatile boolean sIsAppStartFinishAfterFiveSecond;
    public static volatile boolean sIsAppStartFinishAfterTenSecond;
    public static boolean sIsAppExisting;
    public static int sStartType;
    public static boolean sIsForeground;
    public static boolean sIsInitForeGrounded;
    public static int sPhoneType;
    public static boolean sPhoneSuperLow;
    public static boolean sIsAutoTesting;
    private static boolean sStartFlagsInited;
    private static boolean sIsStartAtFirstInstalled;
    private static boolean sIsStartAtCoverInstalled;
    private static String sLastVer;
    public static boolean sIsColdLaunch;
    public static boolean sIsCrashedInLastRun;
    private static int sRuntimes;
    private static int sTodayOpenTimes;
    private static long sForeRunTime;
    private static long sTodayForeRunTime;
    private static long sLastToForeTime;
    private static long sSwitchToBackgroundTime;
    private static String sLastAppVer;
    public static long sYesterdayForeRunTime;
    public static String sLastDebugVer;
    public static volatile boolean sCrashTestLiteAppRun;
    public static volatile boolean sCrashTestLiteAppRunEnd;
    public static volatile boolean sCrashTestMyAppRun;
    public static volatile boolean sCrashTestMyAppRunEnd;
    private static volatile String sCurPlayingGameName;
    public static long sStartAtFirstInstalledTime;
    public static String sCurWin;
    private static boolean sUseOldRoom;
    private static boolean sShowToast;
    public static String action;
    public static boolean sIsMoveTaskToBack;
    public static boolean sIsHagoApp;
    public static boolean sHappenLowMemWarn;
    public static boolean useStartOptimize;
    public static boolean openIpcPerfOpt;
    public static boolean closeFacebookFix;
    public static boolean isSplashShowing;
    private static boolean sShowAndroidLog;
    private static boolean sAdABTest;
    private static boolean sStartMonitorRemoveView;
    private static boolean sMonitorRemoveViewSwtich;
    public static final int TIME_RECORD_SPEAKING = 1;
    public static final int TIME_RECORD_ON_SEAT = 2;
    public static final int TIME_RECORD_ON_MIC = 3;
    private static boolean isHagoPartySdk;
    public static boolean sLimitTopWindow;
    public static Object vv;
    public static Object sv;

    public static int getPhoneType() {
        return sPhoneType;
    }

    public static boolean isPhoneSuperLow() {
        return sPhoneSuperLow;
    }

    public static boolean showAndroidLog() {
        return sIsDebuggable && sShowAndroidLog;
    }

    public static void recordAppLogin() {
        sAppLoginTime = SystemClock.uptimeMillis();
    }

    public static long getAppLoginTime() {
        return sAppLoginTime;
    }

    public static void resetAppStartedFlag() {
        sForeRunTime = 0L;
        sLastToForeTime = sMainActivityStartTime;
        sRuntimes = SettingFlags.getIntValue("runtimes", 0) + 1;
        sTodayOpenTimes = RuntimeContext.readTodayOpenTimes();
        sTodayForeRunTime = RuntimeContext.readTodayForegroundRunTime();
        SettingFlags.setIntValue("runtimes", sRuntimes);
        RuntimeContext.updateTodayOpenTimes();
    }

    private static int readTodayOpenTimes() {
        String times = SettingFlags.getStringValue("key_today_open_app_times", "");
        if (FP.empty(times)) {
            return 0;
        }
        MLog.info("RuntimeContext", " readTodayOpenTimes :%s", times);
        String[] strs = times.split(" ");
        if (strs.length != 2) {
            return 0;
        }
        Calendar today = Calendar.getInstance();
        String date = DateFormatUtils.dateToString(today.getTime(), "yyyy-MM-dd");
        if (!StringUtils.equalsIgnoreCase(strs[0], date)) {
            return 0;
        }
        int count = 0;
        try {
            count = Integer.valueOf(strs[1].trim());
        }
        catch (Exception e) {
            MLog.error((Object)"RuntimeContext", "readTodayOpenTimes ex: %s", e, new Object[0]);
        }
        MLog.info("RuntimeContext", "readTodayOpenTimes count: %s", count);
        return count;
    }

    private static long readTodayForegroundRunTime() {
        String times = SettingFlags.getStringValue("key_today_foreground_run_time", "");
        if (FP.empty(times)) {
            return 0L;
        }
        MLog.info("RuntimeContext", " readTodayForegroundRunTime :%s", times);
        String[] strs = times.split(" ");
        if (strs.length != 2) {
            return 0L;
        }
        Calendar today = Calendar.getInstance();
        String date = DateFormatUtils.dateToString(today.getTime(), "yyyy-MM-dd");
        long time = 0L;
        if (!StringUtils.equalsIgnoreCase(strs[0], date)) {
            Date lastDate = DateFormatUtils.stringtoDate(strs[0], "yyyy-MM-dd");
            boolean isYesterday = DateUtils.isToday((long)(lastDate.getTime() + 86400000L));
            if (isYesterday) {
                SettingFlags.setLongValue("key_yesterday_foreground_run_time", Long.parseLong(strs[1].trim()));
            }
        } else {
            try {
                time = Long.parseLong(strs[1].trim());
            }
            catch (Exception e) {
                MLog.error((Object)"RuntimeContext", "readTodayForegroundRunTime ex: %s", e, new Object[0]);
            }
        }
        MLog.info("RuntimeContext", "readTodayForegroundRunTime count: %s", time);
        sYesterdayForeRunTime = SettingFlags.getLongValue("key_yesterday_foreground_run_time", 0L);
        MLog.info("RuntimeContext", "readYesterdayForegroundRunTime: %s", sYesterdayForeRunTime);
        return time;
    }

    private static void updateTodayOpenTimes() {
        Calendar today = Calendar.getInstance();
        String date = DateFormatUtils.dateToString(today.getTime(), "yyyy-MM-dd");
        sTodayOpenTimes = RuntimeContext.getTodayOpenTimes() + 1;
        String result = date + " " + sTodayOpenTimes;
        MLog.info("RuntimeContext", "updateTodayOpenTimes %s", result);
        SettingFlags.setStringValue("key_today_open_app_times", result);
    }

    private static void updateTodayForegroundRunTime() {
        Calendar today = Calendar.getInstance();
        String date = DateFormatUtils.dateToString(today.getTime(), "yyyy-MM-dd");
        sTodayForeRunTime = RuntimeContext.getTodayForegroundRunTime() + RuntimeContext.getForeGroundRunTime();
        String result = date + " " + sTodayForeRunTime;
        MLog.info("RuntimeContext", "updateTodayForegroundRunTime %s", result);
        SettingFlags.setStringValue("key_today_foreground_run_time", result);
    }

    public static void onForeGroundChanged(boolean fore) {
        if (fore) {
            sLastToForeTime = SystemClock.uptimeMillis();
            sSwitchToBackgroundTime = 0L;
            SettingFlags.setLongValue("key_last_foreground_time", System.currentTimeMillis());
        } else {
            if (sLastToForeTime > 0L) {
                long timeNow = SystemClock.uptimeMillis();
                sForeRunTime += timeNow - sLastToForeTime;
                SettingFlags.setLongValue("key_last_foreground_run_time", timeNow - sLastToForeTime);
                sTodayForeRunTime += timeNow - sLastToForeTime;
            }
            sSwitchToBackgroundTime = SystemClock.elapsedRealtime();
            sLastToForeTime = -1L;
            RuntimeContext.updateTodayForegroundRunTime();
        }
    }

    public static long getLastForeGroundRunTime() {
        return SettingFlags.getLongValue("key_last_foreground_run_time", -1L);
    }

    public static long getSwtichToBackgroundTime() {
        return sSwitchToBackgroundTime;
    }

    public static long getForeGroundRunTime() {
        if (sIsForeground && sLastToForeTime > 0L) {
            return sForeRunTime + (SystemClock.uptimeMillis() - sLastToForeTime);
        }
        return sForeRunTime;
    }

    public static int getRunTimes() {
        return sRuntimes;
    }

    public static int getTodayOpenTimes() {
        if (sTodayOpenTimes == -1) {
            sTodayOpenTimes = RuntimeContext.readTodayOpenTimes();
        }
        return sTodayOpenTimes;
    }

    public static long getTodayForegroundRunTime() {
        if (sIsForeground && sLastToForeTime > 0L) {
            return sTodayForeRunTime + (SystemClock.uptimeMillis() - sLastToForeTime);
        }
        return sTodayForeRunTime;
    }

    private static void initStartFlags() {
        if (!sStartFlagsInited) {
            String localVer = VersionUtil.getLocalName(sApplicationContext);
            String verDebug = "";
            if (sIsDebuggable) {
                sLastDebugVer = SettingFlags.getStringValue("appversiondebug", "");
                VersionUtil.Ver ver = VersionUtil.getLocalVer(sApplicationContext);
                verDebug = ver.aboutDisplayName(sApplicationContext);
                SettingFlags.setStringValue("appversiondebug", verDebug);
                final String verDebugNow = ver.toString();
                YYTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        MLog.info("RuntimeContext", " lastver Debug:%s now ver:%s", sLastDebugVer, verDebugNow);
                    }
                }, 5000L);
            }
            String verSaved = null;
            if (StringUtils.isNotEmpty(localVer)) {
                verSaved = SettingFlags.getStringValue("appversion", null);
                if (StringUtils.isEmpty(verSaved)) {
                    sIsStartAtFirstInstalled = true;
                    sIsStartAtCoverInstalled = false;
                } else {
                    sIsStartAtFirstInstalled = false;
                    sIsStartAtCoverInstalled = !StringUtils.equals(localVer, verSaved);
                }
                if (!StringUtils.equals(localVer, verSaved)) {
                    SettingFlags.setStringValue("lastappversion", verSaved);
                    SettingFlags.setStringValue("appversion", localVer);
                }
                sLastVer = localVer;
            }
            final String fVerSaved = verSaved;
            YYTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MLog.info("RuntimeContext", " lastver:%s sIsStartAtFirstInstalled %d sIsStartAtCoverInstalled %d", fVerSaved != null ? fVerSaved : "", sIsStartAtFirstInstalled ? 1 : 0, sIsStartAtCoverInstalled ? 1 : 0);
                }
            }, 5000L);
            if (sIsStartAtFirstInstalled || sIsStartAtCoverInstalled) {
                sStartAtFirstInstalledTime = System.currentTimeMillis();
                SettingFlags.setLongValue("install_time", System.currentTimeMillis());
            }
            if (sIsStartAtFirstInstalled) {
                SettingFlags.setLongValue("key_first_install_time", System.currentTimeMillis());
            }
            sStartFlagsInited = true;
        }
    }

    public static boolean isStartAtFirstInstalled() {
        RuntimeContext.initStartFlags();
        return sIsStartAtFirstInstalled;
    }

    public static boolean isStartAtCoverInstalled() {
        RuntimeContext.initStartFlags();
        return sIsStartAtCoverInstalled;
    }

    public static String getLastVer() {
        return sLastVer != null ? sLastVer : "";
    }

    public static boolean isNewInstalled() {
        RuntimeContext.initStartFlags();
        String lastVersion = SettingFlags.getStringValue("lastappversion");
        return TextUtils.isEmpty((CharSequence)lastVersion);
    }

    public static void onAppExit() {
        sStartFlagsInited = false;
        sIsStartAtFirstInstalled = false;
        sIsStartAtCoverInstalled = false;
        sIsColdLaunch = false;
        sMainActivityStartTime = -1L;
        sIsAppStarted = false;
        sStartType = -1;
        sIsAppStartFinished = false;
        sIsServicesInited = false;
        sIsAppStartFinishAfterTenSecond = false;
        sIsAppStartFinishAfterFiveSecond = false;
        sIsAppStartFinishAfterThreeSecond = false;
        sIsAppStartFinishAfterOneSecond = false;
    }

    public static boolean isLocalBuild() {
        return FP.eq("origin/hago-sdk-nt_release_maint", "unknown");
    }

    public static boolean isReleaseBuild() {
        return !"origin/hago-sdk-nt_release_maint".contains("SNAPSHOT");
    }

    public static void resetCrashedInLastRunFlag() {
        if (sIsCrashedInLastRun) {
            SettingFlags.setBoolean("crashinlastrun", false);
        }
    }

    public static void onCrash(String crashId, boolean isNativeCrash) {
        SettingFlags.setBoolean("crashinlastrun", true);
        if (StringUtils.isNotEmpty(sCurPlayingGameName)) {
            SettingFlags.setStringValue("gameincrash", sCurPlayingGameName);
        }
        if (StringUtils.isNotEmpty(RuntimeContext.getChannelId())) {
            SettingFlags.setStringValue("roomincrash", RuntimeContext.getChannelId());
        }
        MLog.error((Object)"RuntimeContext", "game:%s, room:%s, crashid %s isNative %d", sCurPlayingGameName == null ? "" : sCurPlayingGameName, RuntimeContext.getChannelId() == null ? "" : RuntimeContext.getChannelId(), crashId, isNativeCrash ? 1 : 0);
        sIsCrashedInLastRun = true;
    }

    static void initCrashedInLastRunFlag() {
        sIsCrashedInLastRun = SettingFlags.getBoolean("crashinlastrun", false);
    }

    public static long readInstallTime() {
        return SettingFlags.getLongValue("install_time", 0L);
    }

    public static void onGameStarted(String gameName) {
        sCurPlayingGameName = gameName;
        if (sIsDebuggable) {
            MLog.info("RuntimeContext", " onGameStarted:%s", gameName);
        }
        MemoryUtil.logForMemoryDetail("onGameStarted" + gameName);
    }

    public static String getCurPlayingGame() {
        return sCurPlayingGameName;
    }

    public static void onGameStoped() {
        sCurPlayingGameName = null;
        if (sIsDebuggable) {
            MLog.info("RuntimeContext", " onGameStoped", new Object[0]);
        }
        MemoryUtil.logForMemoryDetail("onGameStoped");
    }

    public static String getLastAppVersion() {
        if (TextUtils.isEmpty((CharSequence)sLastAppVer)) {
            RuntimeContext.initStartFlags();
            String verStr = SettingFlags.getStringValue("lastappversion");
            if (StringUtils.isNotEmpty(verStr)) {
                VersionUtil.Ver ver = null;
                try {
                    ver = VersionUtil.getVerFromStr(verStr);
                }
                catch (Exception e) {
                    ver = null;
                }
                if (ver != null) {
                    sLastAppVer = ver.getVersionCodeWithoutSnapshot();
                }
            }
        }
        return sLastAppVer != null ? sLastAppVer : "";
    }

    public static synchronized String getVoiceRoomId() {
        return sMainChannel != null ? RuntimeContext.sMainChannel.voiceRoomId : "";
    }

    public static String getChannelId() {
        return RuntimeContext.getVoiceRoomId();
    }

    public static ChannelHeartItem getCurMainChannel() {
        return sMainChannel;
    }

    public static ChannelHeartItem getCoexistenceChannel() {
        return sCoexistence;
    }

    public static synchronized void setChannel(ChannelHeartItem channel) {
        if (channel == null) {
            sMainChannel = null;
            MLog.info("ChannelHeartItem_Main", "set to null", new Object[0]);
        } else {
            sMainChannel = channel;
            sMainChannel.logSelf("ChannelHeartItem_Main");
        }
    }

    public static synchronized void setCoexistenceChannel(ChannelHeartItem channel) {
        if (channel == null) {
            sCoexistence = null;
            MLog.info("ChannelHeartItem_Coexistence", "set to null", new Object[0]);
        } else {
            sCoexistence = channel;
            sCoexistence.logSelf("ChannelHeartItem_Coexistence");
        }
    }

    private static ChannelHeartItem getChannelItem(String channelId) {
        if (StringUtils.isEmpty(channelId)) {
            return null;
        }
        if (sMainChannel != null && StringUtils.equal(channelId, RuntimeContext.sMainChannel.voiceRoomId)) {
            return sMainChannel;
        }
        if (sCoexistence != null && StringUtils.equal(channelId, RuntimeContext.sCoexistence.voiceRoomId)) {
            return sCoexistence;
        }
        return null;
    }

    public static synchronized void setChannelPluginId(String channelId, String id2) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.channelPluginId = id2;
        }
    }

    public static synchronized String getChannelPluginId() {
        return sMainChannel != null ? RuntimeContext.sMainChannel.channelPluginId : "";
    }

    public static synchronized void setVoiceRoomInMic(String channelId, boolean sVoiceRoomInMic) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.voiceRoomInMic = sVoiceRoomInMic;
        }
    }

    public static synchronized void setSeatIndex(String channelId, int seatIndex) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.seatIndex = seatIndex;
        }
    }

    public static synchronized void startRecord(String channelId, int recordKey) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.startRecord(recordKey);
        }
    }

    public static synchronized void stopRecord(String channelId, int recordKey) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.stopRecord(recordKey);
        }
    }

    public static synchronized void setPlayingBackgroundMusic(String channelId, boolean isPlaying) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.isPlayingBackgroundMusic = isPlaying;
        }
    }

    public static synchronized boolean isChannelOpenVideo() {
        return sMainChannel != null ? RuntimeContext.sMainChannel.channelOpenVideo : false;
    }

    public static synchronized void setChannelOpenVideo(String channelId, boolean channelOpenVideo) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.channelOpenVideo = channelOpenVideo;
        }
    }

    public static void setSameCityChannel(String channelId, boolean sameCityChannel) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.sameCityChannel = sameCityChannel;
        }
    }

    public static void setPkType(String channelId, int pkType) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.pkType = pkType;
        }
    }

    public static void setChannelType(String channelId, int channelType) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.channelType = channelType;
        }
    }

    public static void setLinkMicInfo(String channelId, int linkMicType, long linkMicId, int linkMicUidType) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.linkMicType = linkMicType;
            channelHeartItem.linkMicId = linkMicId;
            channelHeartItem.linkMicUidType = linkMicUidType;
        }
    }

    public static void setShowAnchor(String channelId, String uid) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.showAnchor = uid;
        }
    }

    public static void setShowType(String channelId, String type) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.showType = type;
        }
    }

    public static void setTeamUpType(String channelId, int teamUpType) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.teamUpType = teamUpType;
        }
    }

    public static boolean isInGray() {
        return sIsDebuggable || sIsInGray || SystemUtils.isShowEnvSetting();
    }

    public static void setInGrayFlag(boolean flag) {
        sIsInGray = flag;
    }

    public static boolean useOldRoom() {
        return sUseOldRoom;
    }

    public static boolean openVideoLiveOpt() {
        return true;
    }

    public static void setUseOldRoom(boolean flag) {
        sUseOldRoom = flag;
    }

    public static void setShowToast(boolean flag) {
        sShowToast = flag;
    }

    public static boolean isShowToast() {
        return sShowToast;
    }

    public static void setChannelTagId(String channelId, String tagId) {
        ChannelHeartItem channelHeartItem = RuntimeContext.getChannelItem(channelId);
        if (channelHeartItem != null) {
            channelHeartItem.channelTagId = tagId;
        }
    }

    public static boolean isAdABTest() {
        return sAdABTest;
    }

    public static void setAdABTest(boolean adABTest) {
        sAdABTest = adABTest;
    }

    public static void setHagoPartySdk(boolean isParty) {
        if (SystemUtils.isShowEnvSetting()) {
            isHagoPartySdk = isParty;
        }
    }

    public static boolean isHagoPartySdk() {
        return isHagoPartySdk;
    }

    public static boolean isEnableExperiment() {
        return !RuntimeContext.isHagoPartySdk();
    }

    public static void setMonitorRemoveViewSwtich(boolean flag) {
        sMonitorRemoveViewSwtich = flag;
    }

    public static void setStartMonitorRemoveView(boolean flag) {
        if (sMonitorRemoveViewSwtich) {
            sStartMonitorRemoveView = flag;
        }
    }

    public static boolean getStartMonitorRemoveViewFlag() {
        return sStartMonitorRemoveView;
    }

    static {
        sIsDebuggable = false;
        sMainActivityStartTime = -1L;
        sAppOncreateTime = -1L;
        sAppOncreateEndTime = -1L;
        sIsInGray = false;
        sAppLoginTime = 0L;
        sIsModuleAfterEnvInit = false;
        s64SoInsteadOf32So = false;
        sPreLoadGameId = "";
        sFirstGameDeepLink = "";
        sIsAppStarted = false;
        sIsAppStartFinished = false;
        sIsServicesInited = false;
        sIsAppStartFinishAfterOneSecond = false;
        sIsAppStartFinishAfterThreeSecond = false;
        sIsAppStartFinishAfterFiveSecond = false;
        sIsAppStartFinishAfterTenSecond = false;
        sIsAppExisting = false;
        sStartType = -1;
        sIsForeground = true;
        sIsInitForeGrounded = false;
        sPhoneType = 1;
        sPhoneSuperLow = false;
        sIsAutoTesting = false;
        sStartFlagsInited = false;
        sIsStartAtFirstInstalled = false;
        sIsStartAtCoverInstalled = false;
        sIsColdLaunch = true;
        sIsCrashedInLastRun = false;
        sRuntimes = 0;
        sTodayOpenTimes = -1;
        sForeRunTime = 0L;
        sTodayForeRunTime = 0L;
        sLastToForeTime = 0L;
        sSwitchToBackgroundTime = 0L;
        sLastAppVer = "";
        sYesterdayForeRunTime = 0L;
        sLastDebugVer = "";
        sCrashTestLiteAppRun = false;
        sCrashTestLiteAppRunEnd = false;
        sCrashTestMyAppRun = false;
        sCrashTestMyAppRunEnd = false;
        sStartAtFirstInstalledTime = 0L;
        sCurWin = "";
        sUseOldRoom = false;
        sShowToast = true;
        sIsMoveTaskToBack = false;
        sIsHagoApp = true;
        sHappenLowMemWarn = false;
        useStartOptimize = false;
        openIpcPerfOpt = true;
        closeFacebookFix = true;
        isSplashShowing = false;
        sShowAndroidLog = false;
        sAdABTest = false;
        sStartMonitorRemoveView = false;
        sMonitorRemoveViewSwtich = true;
        isHagoPartySdk = true;
        sLimitTopWindow = false;
        vv = null;
        sv = null;
    }

    public static class ChannelHeartItem {
        protected String voiceRoomId = "";
        protected String lastVoiceRoomJoinSession = "";
        protected String channelPluginId = "";
        protected String channelTagId = "";
        protected String recommendToken = "";
        protected boolean voiceRoomInMic = false;
        protected boolean channelOpenVideo = false;
        protected boolean sameCityChannel = false;
        protected String subType;
        protected int pkType = 0;
        protected int linkMicType = 0;
        protected int linkMicUidType = 0;
        protected long linkMicId = 0L;
        protected int channelType = 0;
        protected int seatIndex = -1;
        private SparseLongArray recordTime = new SparseLongArray();
        private SparseLongArray recordStartTime = new SparseLongArray();
        private boolean isPlayingBackgroundMusic = false;
        private String showAnchor = "";
        private String showType = "";
        private int teamUpType = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy(ChannelHeartItem itemToCopy) {
            this.voiceRoomId = itemToCopy.voiceRoomId;
            this.lastVoiceRoomJoinSession = itemToCopy.lastVoiceRoomJoinSession;
            this.channelPluginId = itemToCopy.channelPluginId;
            this.channelTagId = itemToCopy.channelTagId;
            this.recommendToken = itemToCopy.recommendToken;
            this.voiceRoomInMic = itemToCopy.voiceRoomInMic;
            this.channelOpenVideo = itemToCopy.channelOpenVideo;
            this.sameCityChannel = itemToCopy.sameCityChannel;
            this.subType = itemToCopy.subType;
            this.pkType = itemToCopy.pkType;
            this.linkMicType = itemToCopy.linkMicType;
            this.linkMicUidType = itemToCopy.linkMicUidType;
            this.linkMicId = itemToCopy.linkMicId;
            this.channelType = itemToCopy.channelType;
            this.seatIndex = itemToCopy.seatIndex;
            ChannelHeartItem channelHeartItem = itemToCopy;
            synchronized (channelHeartItem) {
                this.recordTime = itemToCopy.recordTime.clone();
                this.recordStartTime = itemToCopy.recordStartTime.clone();
            }
            this.isPlayingBackgroundMusic = itemToCopy.isPlayingBackgroundMusic;
            this.showAnchor = itemToCopy.showAnchor;
            this.showType = itemToCopy.showType;
            this.teamUpType = itemToCopy.teamUpType;
        }

        public void logSelf(String tag) {
            if (sIsDebuggable) {
                MLog.info(tag, "cid:%s,joinSession:%s,pluginId:%s,tagId:%s,token:%s,inMic:%d,openVideo:%d,sameCityChannel:%d,subType:%s,pkType:%d,linkMicType:%d,linkMicUidType:%d,linkMicId:%d,seatIndex:%d,showAnchor:%s,showType:%s", this.voiceRoomId, this.lastVoiceRoomJoinSession, this.channelPluginId, this.channelTagId, this.recommendToken, this.voiceRoomInMic ? 1 : 0, this.channelOpenVideo ? 1 : 0, this.sameCityChannel ? 1 : 0, this.subType, this.pkType, this.linkMicType, this.linkMicUidType, this.linkMicId, this.seatIndex, this.showAnchor, this.showType);
            } else {
                MLog.info(tag, "cid:%s,joinSession:%s,pluginId:%s,tagId:%s,inMic:%d,openVideo:%d,sameCityChannel:%d,subType:%s,pkType:%d,linkMicType:%d,linkMicUidType:%d,linkMicId:%d,seatIndex:%d", this.voiceRoomId, this.lastVoiceRoomJoinSession, this.channelPluginId, this.channelTagId, this.voiceRoomInMic ? 1 : 0, this.channelOpenVideo ? 1 : 0, this.sameCityChannel ? 1 : 0, this.subType, this.pkType, this.linkMicType, this.linkMicUidType, this.linkMicId, this.seatIndex);
            }
        }

        public String getRoomId() {
            return this.voiceRoomId;
        }

        public String getSubType() {
            return this.subType;
        }

        public String getChannelTagId() {
            return this.channelTagId;
        }

        public String getRecommendToken() {
            return this.recommendToken;
        }

        public boolean isSameCityChannel() {
            return this.sameCityChannel;
        }

        public boolean isChannelOpenVideo() {
            return this.channelOpenVideo;
        }

        public boolean isVoiceRoomInMic() {
            return this.voiceRoomInMic;
        }

        public String getLastVoiceRoomJoinSession() {
            return this.lastVoiceRoomJoinSession;
        }

        public String getChannelPluginId() {
            return this.channelPluginId;
        }

        public int getPkType() {
            return this.pkType;
        }

        public int getLinkMicType() {
            return this.linkMicType;
        }

        public int getLinkMicUidType() {
            return this.linkMicUidType;
        }

        public int getChannelType() {
            return this.channelType;
        }

        public long getLinkMicId() {
            return this.linkMicId;
        }

        public int getSeatIndex() {
            return this.seatIndex;
        }

        public synchronized long consumeRecordTime(int recordKey) {
            long preStartTime = this.recordStartTime.get(recordKey, 0L);
            if (preStartTime == 0L) {
                return this.stopRecord(recordKey, true);
            }
            return this.startRecord(recordKey, true);
        }

        public synchronized void startRecord(int recordKey) {
            this.startRecord(recordKey, false);
        }

        public synchronized void stopRecord(int recordKey) {
            this.stopRecord(recordKey, false);
        }

        private long startRecord(int recordKey, boolean consume) {
            long preStartTime = this.recordStartTime.get(recordKey, 0L);
            long nextStartTime = SystemClock.elapsedRealtime();
            long accumulateTime = preStartTime == 0L ? 0L : nextStartTime - preStartTime;
            this.recordStartTime.put(recordKey, nextStartTime);
            long preSpeakingTime = this.recordTime.get(recordKey, 0L);
            long nextSpeakingTime = consume ? 0L : preSpeakingTime + accumulateTime;
            this.recordTime.put(recordKey, nextSpeakingTime);
            return accumulateTime + preSpeakingTime;
        }

        private long stopRecord(int recordKey, boolean consume) {
            long preStartTime = this.recordStartTime.get(recordKey, 0L);
            long currentTime = SystemClock.elapsedRealtime();
            long accumulateTime = preStartTime == 0L ? 0L : currentTime - preStartTime;
            this.recordStartTime.put(recordKey, 0L);
            long preSpeakingTime = this.recordTime.get(recordKey, 0L);
            long nextSpeakingTime = consume ? 0L : preSpeakingTime + accumulateTime;
            this.recordTime.put(recordKey, nextSpeakingTime);
            return accumulateTime + preSpeakingTime;
        }

        public boolean isPlayingBackgroundMusic() {
            return this.isPlayingBackgroundMusic;
        }

        public String getShowAnchor() {
            return this.showAnchor;
        }

        public String getShowType() {
            return this.showType;
        }

        public int getTeamUpType() {
            return this.teamUpType;
        }

        public String toString() {
            return "";
        }
    }
}

