/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.cache.lru;

import androidx.annotation.NonNull;
import java.util.concurrent.atomic.AtomicInteger;

public class LruNode<K, V> {
    public final K key;
    public final V value;
    public LruNode<K, V> pre;
    public LruNode<K, V> next;
    public final int size;
    public final AtomicInteger visitCount = new AtomicInteger(1);
    public boolean isColdNode = false;

    public LruNode(K key, V value, int size) {
        this.key = key;
        this.value = value;
        this.size = size;
    }

    public void updateVisitCount(int newCount) {
        this.visitCount.set(newCount);
    }

    public void increaseVisitCount() {
        int nextFlag;
        int current;
        while ((current = this.visitCount.get()) >= 0 && !this.visitCount.compareAndSet(current, nextFlag = current + 1)) {
        }
    }

    @NonNull
    public String toString() {
        return "LruNode@" + this.hashCode() + "[key:" + this.key + ", value:" + this.value + ", visitCount:" + this.visitCount.get() + ", size:" + this.size + ", isColdNode:" + this.isColdNode + "]";
    }
}

