/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.cache.lru;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.cache.lru.LruNode;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HotEndLruCache<K, V> {
    private static final int HOT_COLD_BOUNDARY = 2;
    private int mCurSize = 0;
    private int mMaxSize = 0;
    private int mHotSize = 0;
    private int mMaxHotSize = 0;
    private final HashMap<K, LruNode<K, V>> mLocationMap = new HashMap(100);
    private LruNode<K, V> mHotHead = null;
    private LruNode<K, V> mColdHead = null;
    private final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();

    public HotEndLruCache(int maxSize, float hotPercent) {
        this.resize(maxSize, hotPercent);
    }

    public void resize(int maxSize, float hotPercent) {
        if (maxSize < 2 || hotPercent < 0.0f || hotPercent >= 1.0f) {
            throw new RuntimeException("HotEndLruCache size parameters error");
        }
        this.mLock.writeLock().lock();
        try {
            this.mMaxSize = maxSize;
            this.mMaxHotSize = Math.min(maxSize - 1, Math.max(1, (int)((float)maxSize * hotPercent)));
            if (this.mCurSize > this.mMaxSize) {
                this.doTrimTo(this.mMaxSize);
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    @Nullable
    public V get(@NonNull K key) {
        this.mLock.readLock().lock();
        LruNode<K, V> node = this.mLocationMap.get(key);
        if (node != null) {
            node.increaseVisitCount();
        }
        this.mLock.readLock().unlock();
        return node == null ? null : (V)node.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(@NonNull K newKey, @NonNull V newValue) {
        LruNode<K, V> newNode = new LruNode<K, V>(newKey, newValue, this.getSize(newValue));
        if (newNode.size > this.mMaxSize) {
            return false;
        }
        this.mLock.writeLock().lock();
        try {
            LruNode<K, V> oldNode = this.mLocationMap.put(newKey, newNode);
            if (oldNode != null) {
                int lastVisitCount = oldNode.visitCount.get();
                this.removeNode(oldNode);
                newNode.updateVisitCount(lastVisitCount + 1);
            }
            boolean trimmed = false;
            if (oldNode == null) {
                trimmed = this.doTrimTo(this.mMaxSize - newNode.size);
            }
            if (this.mHotHead != null && this.mColdHead != null && trimmed) {
                this.insertBefore(newNode, this.mColdHead);
                this.mColdHead = newNode;
                newNode.isColdNode = true;
                this.mCurSize += newNode.size;
            } else {
                if (this.mHotHead != null) {
                    this.insertBefore(newNode, this.mHotHead);
                } else {
                    newNode.pre = newNode;
                    newNode.next = newNode.pre;
                }
                boolean isDoubleHead = this.mColdHead == this.mHotHead;
                this.mHotHead = newNode;
                this.mHotSize += newNode.size;
                this.mCurSize += newNode.size;
                if (this.mColdHead == null) {
                    if (this.mCurSize > this.mMaxHotSize) {
                        this.setNewColdHead(this.mHotHead.pre);
                    }
                } else if (this.mHotSize > this.mMaxHotSize) {
                    if (isDoubleHead && this.mColdHead.pre != this.mColdHead) {
                        this.mHotSize -= this.mColdHead.size;
                        this.mColdHead.isColdNode = true;
                    }
                    this.setNewColdHead(this.mColdHead.pre);
                }
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
        return true;
    }

    protected int getSize(@NonNull V value) {
        return 1;
    }

    public boolean trimTo(int targetSize) {
        this.mLock.writeLock().lock();
        try {
            boolean bl = this.doTrimTo(targetSize);
            return bl;
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    private boolean doTrimTo(int targetSize) {
        LruNode removed = null;
        while (this.mCurSize > targetSize) {
            LruNode coldTail;
            while (true) {
                coldTail = this.mHotHead.pre;
                if (coldTail.visitCount.get() < 2) break;
                coldTail.updateVisitCount(1);
                this.setNewHotHead(coldTail);
                while (this.mHotSize > this.mMaxHotSize && this.setNewColdHead(this.mColdHead.pre)) {
                }
            }
            removed = coldTail;
            this.mLocationMap.remove(removed.key);
            this.removeNode(removed);
        }
        return removed != null;
    }

    private void insertBefore(@NonNull LruNode<K, V> newNode, @NonNull LruNode<K, V> existNode) {
        newNode.next = existNode;
        newNode.pre = existNode.pre;
        existNode.pre.next = newNode;
        existNode.pre = newNode;
    }

    @Nullable
    public final V remove(@NonNull K key) {
        LruNode<K, V> node;
        this.mLock.writeLock().lock();
        try {
            node = this.mLocationMap.remove(key);
            if (node != null) {
                node.updateVisitCount(-1);
                if (node.pre != null) {
                    this.removeNode(node);
                }
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
        if (node == null) {
            return null;
        }
        return node.value;
    }

    private void removeNode(@NonNull LruNode<K, V> node) {
        if (node.next == node) {
            this.setNewHotHead(null);
            this.setNewColdHead(null);
        } else {
            node.next.pre = node.pre;
            node.pre.next = node.next;
            if (this.mHotHead == node) {
                this.setNewHotHead(node.next);
            }
            if (this.mColdHead == node) {
                this.setNewColdHead(node.next);
            }
        }
        this.mCurSize -= node.size;
        if (!node.isColdNode) {
            this.mHotSize -= node.size;
        }
    }

    private void setNewHotHead(@Nullable LruNode<K, V> node) {
        if (node != null) {
            if (node.isColdNode) {
                this.mHotSize += node.size;
            }
            node.isColdNode = false;
        }
        this.mHotHead = node;
    }

    private boolean setNewColdHead(@Nullable LruNode<K, V> node) {
        this.mColdHead = node;
        if (node == null || this.mHotHead == node) {
            return false;
        }
        if (!node.isColdNode) {
            this.mHotSize -= node.size;
        }
        node.isColdNode = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int traverseTrim(int maxCount, @NonNull TraverseCallback<K, V> callback) {
        int count;
        this.mLock.writeLock().lock();
        try {
            if (this.mHotHead == null) {
                int n = 0;
                return n;
            }
            LruNode node = this.mHotHead.pre;
            for (count = 0; count < maxCount; ++count) {
                LruNode pre;
                if (!callback.onTraverse(node.key, node.value)) {
                    node.updateVisitCount(1);
                    this.setNewHotHead(node);
                    while (this.mHotSize > this.mMaxHotSize && this.setNewColdHead(this.mColdHead.pre)) {
                    }
                }
                if ((pre = node.pre) == node) {
                    break;
                }
                node = pre;
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
        return count;
    }

    public void clear() {
        this.mLock.writeLock().lock();
        this.mLocationMap.clear();
        this.setNewHotHead(null);
        this.setNewColdHead(null);
        this.mCurSize = 0;
        this.mHotSize = 0;
        this.mLock.writeLock().unlock();
    }

    public final int size() {
        return this.mCurSize;
    }

    public final int maxSize() {
        return this.mMaxSize;
    }

    public final int maxHotSize() {
        return this.mMaxHotSize;
    }

    public String toString() {
        return "HotEndLruCache{mCurSize=" + this.mCurSize + ", mMaxSize=" + this.mMaxSize + ", mHotSize=" + this.mHotSize + ", mMaxHotSize=" + this.mMaxHotSize + ", mHotHead=" + this.mHotHead + ", mColdHead=" + this.mColdHead + '}';
    }

    public static interface TraverseCallback<K, V> {
        public boolean onTraverse(@NonNull K var1, @NonNull V var2);
    }
}

