/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.util.Preconditions;
import com.yy.base.logger.MLog;

public final class MemorySizeCalculator {
    private static final String TAG = "MemorySizeCalculator";
    @VisibleForTesting
    static final int BYTES_PER_ARGB_8888_PIXEL = 4;
    private static final int LOW_MEMORY_BYTE_ARRAY_POOL_DIVISOR = 2;
    private final int bitmapPoolSize;
    private final int memoryCacheSize;
    private final Context context;
    private final int arrayPoolSize;

    MemorySizeCalculator(Builder builder) {
        this.context = builder.context;
        this.arrayPoolSize = MemorySizeCalculator.isLowMemoryDevice(builder.activityManager) ? builder.arrayPoolSizeBytes / 2 : builder.arrayPoolSizeBytes;
        int maxSize = MemorySizeCalculator.getMaxSize(builder.activityManager, builder.maxSizeMultiplier, builder.lowMemoryMaxSizeMultiplier);
        int widthPixels = builder.screenDimensions.getWidthPixels();
        int heightPixels = builder.screenDimensions.getHeightPixels();
        int screenSize = widthPixels * heightPixels * 4;
        int targetBitmapPoolSize = Math.round((float)screenSize * builder.bitmapPoolScreens);
        int targetMemoryCacheSize = Math.round((float)screenSize * builder.memoryCacheScreens);
        int availableSize = maxSize - this.arrayPoolSize;
        if (targetMemoryCacheSize + targetBitmapPoolSize <= availableSize) {
            this.memoryCacheSize = targetMemoryCacheSize;
            this.bitmapPoolSize = targetBitmapPoolSize;
        } else {
            float part = (float)availableSize / (builder.bitmapPoolScreens + builder.memoryCacheScreens);
            this.memoryCacheSize = Math.round(part * builder.memoryCacheScreens);
            this.bitmapPoolSize = Math.round(part * builder.bitmapPoolScreens);
        }
        MLog.debug(TAG, "Calculation complete, Calculated memory cache size: " + this.toMb(this.memoryCacheSize) + ", pool size: " + this.toMb(this.bitmapPoolSize) + ", byte array size: " + this.toMb(this.arrayPoolSize) + ", memory class limited? " + (targetMemoryCacheSize + targetBitmapPoolSize > maxSize) + ", max size: " + this.toMb(maxSize) + ", memoryClass: " + builder.activityManager.getMemoryClass() + ", isLowMemoryDevice: " + MemorySizeCalculator.isLowMemoryDevice(builder.activityManager), new Object[0]);
    }

    public int getMemoryCacheSize() {
        return this.memoryCacheSize;
    }

    public int getBitmapPoolSize() {
        return this.bitmapPoolSize;
    }

    public int getArrayPoolSizeInBytes() {
        return this.arrayPoolSize;
    }

    private static int getMaxSize(ActivityManager activityManager, float maxSizeMultiplier, float lowMemoryMaxSizeMultiplier) {
        int memoryClassBytes = activityManager.getMemoryClass() * 1024 * 1024;
        boolean isLowMemoryDevice = MemorySizeCalculator.isLowMemoryDevice(activityManager);
        return Math.round((float)memoryClassBytes * (isLowMemoryDevice ? lowMemoryMaxSizeMultiplier : maxSizeMultiplier));
    }

    private String toMb(int bytes) {
        return Formatter.formatFileSize((Context)this.context, (long)bytes);
    }

    @TargetApi(value=19)
    static boolean isLowMemoryDevice(ActivityManager activityManager) {
        if (Build.VERSION.SDK_INT >= 19) {
            return activityManager.isLowRamDevice();
        }
        return true;
    }

    private static final class DisplayMetricsScreenDimensions
    implements ScreenDimensions {
        private final DisplayMetrics displayMetrics;

        DisplayMetricsScreenDimensions(DisplayMetrics displayMetrics) {
            this.displayMetrics = displayMetrics;
        }

        @Override
        public int getWidthPixels() {
            return this.displayMetrics.widthPixels;
        }

        @Override
        public int getHeightPixels() {
            return this.displayMetrics.heightPixels;
        }
    }

    public static final class Builder {
        @VisibleForTesting
        static final int MEMORY_CACHE_TARGET_SCREENS = 2;
        static final int BITMAP_POOL_TARGET_SCREENS = Build.VERSION.SDK_INT < 26 ? 4 : 1;
        static final float MAX_SIZE_MULTIPLIER = 0.4f;
        static final float LOW_MEMORY_MAX_SIZE_MULTIPLIER = 0.33f;
        static final int ARRAY_POOL_SIZE_BYTES = 0x400000;
        final Context context;
        ActivityManager activityManager;
        ScreenDimensions screenDimensions;
        float memoryCacheScreens = 2.0f;
        float bitmapPoolScreens = BITMAP_POOL_TARGET_SCREENS;
        float maxSizeMultiplier = 0.4f;
        float lowMemoryMaxSizeMultiplier = 0.33f;
        int arrayPoolSizeBytes = 0x400000;

        public Builder(Context context) {
            this.context = context;
            this.activityManager = (ActivityManager)context.getSystemService("activity");
            this.screenDimensions = new DisplayMetricsScreenDimensions(context.getResources().getDisplayMetrics());
            if (Build.VERSION.SDK_INT >= 26 && MemorySizeCalculator.isLowMemoryDevice(this.activityManager)) {
                this.bitmapPoolScreens = 0.0f;
            }
        }

        public Builder setMemoryCacheScreens(float memoryCacheScreens) {
            Preconditions.checkArgument(memoryCacheScreens >= 0.0f, "Memory cache screens must be greater than or equal to 0");
            this.memoryCacheScreens = memoryCacheScreens;
            return this;
        }

        public Builder setBitmapPoolScreens(float bitmapPoolScreens) {
            Preconditions.checkArgument(bitmapPoolScreens >= 0.0f, "Bitmap pool screens must be greater than or equal to 0");
            this.bitmapPoolScreens = bitmapPoolScreens;
            return this;
        }

        public Builder setMaxSizeMultiplier(float maxSizeMultiplier) {
            Preconditions.checkArgument(maxSizeMultiplier >= 0.0f && maxSizeMultiplier <= 1.0f, "Size multiplier must be between 0 and 1");
            this.maxSizeMultiplier = maxSizeMultiplier;
            return this;
        }

        public Builder setLowMemoryMaxSizeMultiplier(float lowMemoryMaxSizeMultiplier) {
            Preconditions.checkArgument(lowMemoryMaxSizeMultiplier >= 0.0f && lowMemoryMaxSizeMultiplier <= 1.0f, "Low memory max size multiplier must be between 0 and 1");
            this.lowMemoryMaxSizeMultiplier = lowMemoryMaxSizeMultiplier;
            return this;
        }

        public Builder setArrayPoolSize(int arrayPoolSizeBytes) {
            this.arrayPoolSizeBytes = arrayPoolSizeBytes;
            return this;
        }

        @VisibleForTesting
        Builder setActivityManager(ActivityManager activityManager) {
            this.activityManager = activityManager;
            return this;
        }

        @VisibleForTesting
        Builder setScreenDimensions(ScreenDimensions screenDimensions) {
            this.screenDimensions = screenDimensions;
            return this;
        }

        public MemorySizeCalculator build() {
            return new MemorySizeCalculator(this);
        }
    }

    static interface ScreenDimensions {
        public int getWidthPixels();

        public int getHeightPixels();
    }
}

