/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.util.LruCache;
import com.yy.DontProguardClass;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import java.util.HashMap;

@DontProguardClass
public class LruResourceCache
extends LruCache<Key, Resource<?>>
implements MemoryCache {
    private MemoryCache.ResourceRemovedListener listener;
    private HashMap<Resource<?>, Integer> itemSizes;
    private int lruMemItemSizeOpt = -1;

    public LruResourceCache(long size) {
        super(size);
    }

    private boolean isItemSizeOptSwitchOn() {
        if (this.lruMemItemSizeOpt == -1 && SettingFlags.hasInited()) {
            this.lruMemItemSizeOpt = SettingFlags.getIntValue("lru_mem_item_size_opt", 0);
            if (SystemUtils.isShowEnvSetting()) {
                this.lruMemItemSizeOpt = 1;
            }
        }
        return this.lruMemItemSizeOpt == 1;
    }

    @Override
    public void setResourceRemovedListener(@NonNull MemoryCache.ResourceRemovedListener listener) {
        this.listener = listener;
    }

    @Override
    protected void onItemEvicted(@NonNull Key key, @Nullable Resource<?> item) {
        if (this.listener != null && item != null) {
            this.listener.onResourceRemoved(item);
        }
        if (this.itemSizes != null && item != null) {
            this.itemSizes.remove(item);
        }
    }

    @Override
    @Nullable
    public synchronized Resource<?> remove(@NonNull Key key) {
        Resource result = (Resource)super.remove(key);
        if (result != null && this.itemSizes != null) {
            this.itemSizes.remove(result);
        }
        return result;
    }

    @Override
    @Nullable
    public void clearMemory() {
        super.clearMemory();
        if (this.itemSizes != null) {
            this.itemSizes.clear();
        }
    }

    @Override
    protected int getSize(@Nullable Resource<?> item) {
        Integer itemSize;
        if (item == null) {
            return super.getSize(null);
        }
        int size = -1;
        if (this.isItemSizeOptSwitchOn() && this.itemSizes != null && (itemSize = this.itemSizes.get(item)) != null) {
            size = itemSize;
        }
        if (size <= 0) {
            size = item.getSize();
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info("LruResourceCache", "item:%s, get size:%d!", item, size);
            }
            if (size > 0 && this.isItemSizeOptSwitchOn()) {
                if (this.itemSizes == null) {
                    this.itemSizes = new HashMap();
                }
                this.itemSizes.put(item, size);
            }
        } else if (SystemUtils.isShowEnvSetting()) {
            int newSize = item.getSize();
            if (newSize != size) {
                MLog.error((Object)"LruResourceCache", "item:%s, oldSize:%d, newSize:%d!", item, size, newSize);
            } else {
                MLog.info("LruResourceCache", "item:%s, size:%d use cache!", item, size);
            }
        }
        return size;
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void trimMemory(int level) {
        if (level >= 40) {
            this.clearMemory();
        } else if (level >= 20 || level == 15) {
            if (this.getCurrentSize() > 0L && SettingFlags.hasInited() && SettingFlags.getIntValue("lru_clear_opt", 1) == 1) {
                this.trimToSize(this.getCurrentSize() / 2L);
            } else {
                this.trimToSize(this.getMaxSize() / 2L);
            }
        }
    }
}

