/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hago.xlog;

import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.hago.xlog.IKLog;
import java.util.Locale;

public class BaseLog
implements IKLog {
    private boolean enable = RuntimeContext.isLocalBuild();

    @Override
    public void logV(String tag, String log, Object ... args) {
        if (!this.enable) {
            return;
        }
        Log.v((String)tag, (String)this.getLog(log, null, args));
    }

    @Override
    public void logI(String tag, String log, Object ... args) {
        if (!this.enable) {
            return;
        }
        Log.i((String)tag, (String)this.getLog(log, null, args));
    }

    @Override
    public void logD(String tag, String log, Object ... args) {
        if (!this.enable) {
            return;
        }
        Log.d((String)tag, (String)this.getLog(log, null, args));
    }

    @Override
    public void logW(String tag, String log, Object ... args) {
        if (!this.enable) {
            return;
        }
        Log.w((String)tag, (String)this.getLog(log, null, args));
    }

    @Override
    public void logE(String tag, String log, Object ... args) {
        if (!this.enable) {
            return;
        }
        Log.e((String)tag, (String)this.getLog(log, null, args));
    }

    @Override
    public void logE(String tag, String format, Throwable t, Object ... args) {
        if (!this.enable) {
            return;
        }
        Log.e((String)tag, (String)this.getLog(format, t, args));
    }

    private String getLog(String format, Throwable t, Object ... args) {
        String log;
        String string2 = log = args == null || args.length == 0 ? format : this.format(format, args);
        if (log == null) {
            log = "";
        }
        if (t != null) {
            log = log + " Exception occurs at " + Log.getStackTraceString((Throwable)t);
        }
        return log;
    }

    public String format(String messageFormat, Object ... args) {
        try {
            if (messageFormat == null) {
                return "";
            }
            return args == null || args.length == 0 ? messageFormat : this.formatWitUSLocal(messageFormat, args);
        }
        catch (Exception e) {
            return messageFormat;
        }
    }

    private String formatWitUSLocal(String format, Object ... args) {
        try {
            return String.format(Locale.US, format, args);
        }
        catch (Exception e) {
            return "";
        }
    }
}

