/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils.xml;

import android.app.ActivityManager;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SystemServiceUtils;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;

public class CommonUtils {
    private static long lastClickTime;
    private static HashMap<String, SimpleDateFormat> mSimpleDateFormatCache;
    private static int sTotalMemory;

    public static boolean isCurrentMainThread() {
        return Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
    }

    public static boolean isFastClick(long timeThreshold) {
        long time = System.currentTimeMillis();
        if (time - lastClickTime < timeThreshold) {
            return true;
        }
        lastClickTime = time;
        return false;
    }

    public static void setGLSurfaceViewThreadName(String name) {
        if (name == null) {
            return;
        }
        try {
            Thread currentThread = Thread.currentThread();
            String threadName = currentThread.getName();
            if (threadName != null && threadName.startsWith("GLThread ")) {
                currentThread.setName(name);
            }
        }
        catch (Throwable e) {
            Log.e((String)"CommonUtils", (String)"Empty Catch on setGLSurfaceViewThreadName", (Throwable)e);
        }
    }

    public static SimpleDateFormat getSimpleDateFormat(String format) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            SimpleDateFormat sdf = mSimpleDateFormatCache.get(format);
            if (sdf == null) {
                sdf = new SimpleDateFormat(format);
                mSimpleDateFormatCache.put(format, sdf);
            }
            return sdf;
        }
        return new SimpleDateFormat(format);
    }

    public static SimpleDateFormat getSimpleDateFormatWithUS(String format) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            SimpleDateFormat sdf = mSimpleDateFormatCache.get(format + Locale.US);
            if (sdf == null) {
                sdf = new SimpleDateFormat(format, Locale.US);
                mSimpleDateFormatCache.put(format + Locale.US, sdf);
            }
            return sdf;
        }
        return new SimpleDateFormat(format, Locale.US);
    }

    public static int getAvailMemory() {
        int availMem = 0;
        try {
            ActivityManager.MemoryInfo mem = new ActivityManager.MemoryInfo();
            SystemServiceUtils.getActivityManager(RuntimeContext.sApplicationContext).getMemoryInfo(mem);
            availMem = (int)(mem.availMem / 1024L);
        }
        catch (Throwable e) {
            MLog.error((Object)"CommonUtils", "getTotalMemory()" + e.toString(), new Object[0]);
        }
        return availMem;
    }

    public static int getTotalMemory() {
        if (sTotalMemory > 0 && RuntimeContext.openIpcPerfOpt) {
            return sTotalMemory;
        }
        try {
            ActivityManager.MemoryInfo mem = new ActivityManager.MemoryInfo();
            SystemServiceUtils.getActivityManager(RuntimeContext.sApplicationContext).getMemoryInfo(mem);
            sTotalMemory = Build.VERSION.SDK_INT < 16 ? 1024 : (int)(mem.totalMem >>> 20);
        }
        catch (Throwable e) {
            MLog.error((Object)"CommonUtils", "getTotalMemory()" + e.toString(), new Object[0]);
        }
        return sTotalMemory;
    }

    static {
        mSimpleDateFormatCache = new HashMap();
        sTotalMemory = -1;
    }
}

