/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils.json;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.utils.IOUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.OnJsonParseMonitor;
import com.yy.base.yyprotocol.Int64;
import com.yy.base.yyprotocol.Uint16;
import com.yy.base.yyprotocol.Uint32;
import com.yy.base.yyprotocol.Uint64;
import com.yy.base.yyprotocol.Uint8;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonParser {
    private static final String TAG = "JsonParser";
    private static OnJsonParseMonitor mOnJsonParseMonitor;
    private static Gson gson;

    public static Gson getGson() {
        return gson;
    }

    public static void setOnJsonParseMonitor(OnJsonParseMonitor onJsonParseMonitor) {
        mOnJsonParseMonitor = onJsonParseMonitor;
    }

    private static void parseType(String parseType, Object classO) {
        if (mOnJsonParseMonitor != null) {
            if (SystemUtils.isShowEnvSetting()) {
                mOnJsonParseMonitor.onParse(parseType + (classO != null ? classO.toString() : ""));
            } else {
                mOnJsonParseMonitor.onParse(parseType);
            }
        }
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add("DataParse_Json:%s,%s", parseType, classO != null ? classO.toString() : "");
        }
    }

    public static JSONObject obtainJSONObject(String json) throws JSONException {
        return new MyJSONObject(json == null ? "" : json);
    }

    public static JSONObject obtainJSONObject() {
        return new MyJSONObject();
    }

    public JSONObject obtainJSONObject(JSONTokener readFrom) throws JSONException {
        if (readFrom == null) {
            return JsonParser.obtainJSONObject();
        }
        return new MyJSONObject(readFrom);
    }

    public static <T> T parseJsonObject(String json, Class<T> clz) {
        try {
            JsonParser.parseType("parseJsonObject", clz);
            return (T)gson.fromJson(json, clz);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "parse json: " + json + " fail", e, new Object[0]);
            return null;
        }
    }

    public static <T> T parseJsonObject(JsonElement json, Class<T> clz) {
        JsonParser.parseType("parseJsonObject", clz);
        return (T)gson.fromJson(json, clz);
    }

    @Nullable
    public static <T> T parseJsonObject(String string2, Type type) {
        try {
            JsonParser.parseType("parseJsonObject", type);
            return (T)gson.fromJson(string2, type);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "[fromJson_type] fail", e, new Object[0]);
            return null;
        }
    }

    public static <T> T[] parseJsonArray(String json, Class<T> clz) {
        JsonParser.parseType("parseJsonArray", clz);
        Object[] result = (Object[])gson.fromJson(json, new TypeToken<T[]>(){}.getType());
        return result;
    }

    public static <V> Map<String, V> parseJsonMap(String json, Class<V> valueType) {
        JsonParser.parseType("parseJsonMap", valueType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject jsonObject = new JSONObject(json);
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = jsonObject.opt(key);
                if (valueType.isInstance(value)) {
                    map.put(key, value);
                    continue;
                }
                MLog.error((Object)TAG, "parseJsonMap value is not %s, value: %s", valueType, value);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "parseConfig exception, msg:" + e.getMessage(), new Object[0]);
        }
        return map;
    }

    public static String toJson(Object obj) {
        try {
            JsonParser.parseType("toJson", obj);
            return gson.toJson(obj);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "toJson %s", e, obj);
            return "{}";
        }
    }

    public static String toJson(Object obj, Type typeOfSrc) {
        try {
            JsonParser.parseType("toJson", typeOfSrc);
            return gson.toJson(obj, typeOfSrc);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "Throwable : %s", e, new Object[0]);
            return "{}";
        }
    }

    public static <T> List<T> parseJsonList(String json, Class<T> clz) throws Exception {
        JsonParser.parseType("parseJsonList", clz);
        ArrayList<Object> data = new ArrayList<Object>();
        if (!TextUtils.isEmpty((CharSequence)json)) {
            com.google.gson.JsonParser parser = new com.google.gson.JsonParser();
            JsonElement element = parser.parse(json);
            JsonArray array = element.getAsJsonArray();
            for (JsonElement jo : array) {
                data.add(gson.fromJson(jo, clz));
            }
        }
        return data;
    }

    public static <T> List<T> parseJsonList(JsonArray array, Class<T> clz) throws Exception {
        JsonParser.parseType("parseJsonList", clz);
        ArrayList<T> data = new ArrayList<T>();
        for (JsonElement jo : array) {
            data.add(JsonParser.parseJsonObject(jo, clz));
        }
        return data;
    }

    public static <T> T parseJsonTye(String json, Type type) {
        JsonParser.parseType("parseJsonTye", type);
        return (T)gson.fromJson(json, type);
    }

    public static <T> T parseJsonStream(InputStream inputStream, Type type) {
        JsonParser.parseType("parseJsonStream", type);
        JsonReader jsonReader = null;
        try {
            jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
            return (T)gson.fromJson(jsonReader, type);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static <T> T parseJsonFile(String path, Type type) {
        Object object;
        FileReader reader = null;
        try {
            JsonParser.parseType("parseJsonFile", type);
            reader = new FileReader(path);
            Object result = gson.fromJson((Reader)reader, type);
            try {
                ((Reader)reader).close();
            }
            catch (Exception e) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception e2) {
                    MLog.error(TAG, e);
                }
            }
            object = result;
        }
        catch (Exception e) {
            try {
                MLog.error((Object)TAG, "parseJsonFile error", e, new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(reader);
                throw throwable;
            }
            IOUtils.safeClose(reader);
            return null;
        }
        IOUtils.safeClose(reader);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJsonFile(String path, Object obj, Type type) {
        JsonParser.parseType("writeJsonFile", type);
        FileWriter writer = null;
        JsonWriter jsonWriter = null;
        try {
            File file = YYFileUtils.createNewFile(path, false);
            writer = new FileWriter(file);
            jsonWriter = gson.newJsonWriter((Writer)writer);
            gson.toJson(obj, type, jsonWriter);
            jsonWriter.flush();
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            try {
                MLog.error((Object)TAG, "writeJsonFile error", e, new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(writer);
                IOUtils.safeClose(jsonWriter);
                throw throwable;
            }
            IOUtils.safeClose(writer);
            IOUtils.safeClose((Closeable)jsonWriter);
        }
        IOUtils.safeClose(writer);
        IOUtils.safeClose((Closeable)jsonWriter);
    }

    public static String getValueFromKey(String json, String key) {
        try {
            com.google.gson.JsonParser parser = new com.google.gson.JsonParser();
            JsonElement element = parser.parse(json);
            return JsonParser.jsonTree(element, key);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "getValueFromKey error:%s", e, new Object[0]);
            return "";
        }
    }

    private static String jsonTree(JsonElement element, String key) {
        JsonArray jsonArray;
        String result = "";
        if (element.isJsonNull()) {
            return "";
        }
        if (element.isJsonPrimitive()) {
            return "";
        }
        if (element.isJsonArray() && (jsonArray = element.getAsJsonArray()) != null) {
            JsonElement e;
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext() && !StringUtils.isNotEmpty(result = JsonParser.jsonTree(e = (JsonElement)iterator.next(), key))) {
            }
        }
        if (element.isJsonObject()) {
            Set set = element.getAsJsonObject().entrySet();
            for (Map.Entry en : set) {
                if (((String)en.getKey()).equalsIgnoreCase(key)) {
                    result = ((JsonElement)en.getValue()).toString();
                    return result;
                }
                result = JsonParser.jsonTree((JsonElement)en.getValue(), key);
                if (!StringUtils.isNotEmpty(result)) continue;
                break;
            }
        }
        return result;
    }

    static {
        gson = new GsonBuilder().registerTypeAdapter(Int64.class, (Object)new NumberTypeAdapter()).registerTypeAdapter(Uint8.class, (Object)new NumberTypeAdapter()).registerTypeAdapter(Uint16.class, (Object)new NumberTypeAdapter()).registerTypeAdapter(Uint32.class, (Object)new NumberTypeAdapter()).registerTypeAdapter(Uint64.class, (Object)new NumberTypeAdapter()).setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return f.getName().contains("imSession") || f.getName().contains("_kvoSourceTagList");
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz == Field.class || clazz == Method.class;
            }
        }}).disableHtmlEscaping().excludeFieldsWithModifiers(new int[]{128, 8}).serializeSpecialFloatingPointValues().create();
    }

    private static class NumberTypeAdapter
    implements JsonSerializer<Number> {
        private NumberTypeAdapter() {
        }

        public JsonElement serialize(Number src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }
    }

    private static class MyJSONObject
    extends JSONObject {
        public MyJSONObject() {
        }

        public MyJSONObject(String data) throws JSONException {
            super(data);
            if (SystemUtils.isShowEnvSetting() && StringUtils.isNotEmpty(data)) {
                PerfActionLog.add("DataParse_newJSONObject:%s", data);
            }
            if (mOnJsonParseMonitor != null) {
                if (SystemUtils.isShowEnvSetting()) {
                    mOnJsonParseMonitor.onParse("MyJSONObject " + data);
                } else {
                    mOnJsonParseMonitor.onParse("MyJSONObject");
                }
            }
        }

        public MyJSONObject(JSONTokener readFrom) throws JSONException {
            super(readFrom);
        }

        public String toString() {
            if (SystemUtils.isShowEnvSetting()) {
                long timeStart = SystemClock.uptimeMillis();
                String str = super.toString();
                int consume = (int)(SystemClock.uptimeMillis() - timeStart);
                if (consume > 50) {
                    PerfActionLog.add("DataParse_JSON:%d, Data:%s", consume, str);
                } else {
                    PerfActionLog.add("DataParse_JSON:%d, Data:%s", consume, str.substring(0, str.length() > 100 ? 100 : str.length()));
                }
                if (mOnJsonParseMonitor != null) {
                    if (SystemUtils.isShowEnvSetting()) {
                        mOnJsonParseMonitor.onParse("JsonToString  " + str);
                    } else {
                        mOnJsonParseMonitor.onParse("JsonToString");
                    }
                }
                return str;
            }
            return super.toString();
        }
    }
}

