/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ExifInterfaceCompat;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class YYImageUtils {
    private static final String TAG = "YYImageUtils";
    private static final int screenWidth = ResolutionUtils.getScreenWidth();
    private static final int screenHeight = ResolutionUtils.getScreenHeight();
    public static final int THUMBNAIL_SMALL_SIZE = 75;
    public static final int THUMBNAIL_MIDDLE_SIZE = 75;
    public static final int THUMBNAIL_LARGE_SIZE = 75;
    public static final int SCREEN_W_DP = ResolutionUtils.px2Dip(screenWidth);
    public static final int SCREEN_H_DP = ResolutionUtils.px2Dip(screenHeight);
    public static final int SCREEN_HALF_DP = SCREEN_W_DP / 2;
    public static final int IMAGE_COMPRESS_RATE = 75;
    public static final int IMAGE_SCALE_WIDTH = 800;
    public static final int IMAGE_SCALE_HEIGHT = 800;
    private static int sCanUseWebP = -1;
    private static Bitmap sDefaultMalePhoto = null;
    private static Bitmap sDefaultMalePhotoOffline = null;
    private static Bitmap sDefaultFemalePhotoOffline = null;
    private static Bitmap sDefaultMalePhotoBitmap = null;
    private static Bitmap sDefaultFemalePhotoBitmap = null;
    private static final String SCHEME_CONTENT = "content";

    public static Bitmap decodeFile(String filePath) {
        return YYImageUtils.decodeFile(filePath, null);
    }

    public static String getThumbnailPostfix(int size) {
        return YYImageUtils.getThumbnailPostfix(size, true);
    }

    public static boolean isHttpRequest(String url) {
        return StringUtils.isNotEmpty(url) && url.startsWith("http");
    }

    public static String getThumbnailPostfixHalfScreen() {
        int size = ResolutionUtils.getScreenWidth() / 2;
        return YYImageUtils.getThumbnailPostfixPx(size, size, true);
    }

    public static String getThumbSmall() {
        return YYImageUtils.getThumbnailPostfix(75);
    }

    public static String getThumbnailPostfix(int size, boolean useWebp) {
        size = ScreenUtils.getInstance().dip2px(size);
        return YYImageUtils.getThumbnailPostfixPx(size, size, useWebp);
    }

    public static String getThumb(int wDp, int hDp) {
        return YYImageUtils.getThumbnailPostfixPx(ScreenUtils.getInstance().dip2px(wDp), ScreenUtils.getInstance().dip2px(hDp), true);
    }

    public static String getThumb(@Nullable View view, boolean useFullScreen, String originUrl) {
        if (view != null && originUrl != null && !originUrl.isEmpty() && YYImageUtils.canAppendResize(originUrl)) {
            int w = 0;
            if (view.getLayoutParams() != null) {
                w = view.getLayoutParams().width;
            }
            if (w <= 0 && (w = view.getWidth()) <= 0) {
                w = view.getMeasuredWidth();
            }
            if (w <= 0) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.warn(TAG, Log.getStackTraceString((Throwable)new RuntimeException("\u56fe\u7247\u52a0\u8f7d\u8fdd\u89c4 getThumb w <= 0, " + originUrl)), new Object[0]);
                }
                return "";
            }
            if (w >= screenWidth) {
                w = screenWidth;
                if (RuntimeContext.sIsDebuggable && !useFullScreen) {
                    MLog.warn(TAG, Log.getStackTraceString((Throwable)new RuntimeException("\u56fe\u7247\u52a0\u8f7d\u8fdd\u89c4 getThumb too large, " + originUrl)), new Object[0]);
                }
            }
            if (!useFullScreen && w > screenWidth - 1) {
                w = screenWidth / 2;
            }
            int h = 0;
            if (view.getLayoutParams() != null) {
                h = view.getLayoutParams().height;
            }
            if (h <= 0 && (h = view.getHeight()) <= 0) {
                h = view.getMeasuredHeight();
            }
            if (h <= 0) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.warn(TAG, Log.getStackTraceString((Throwable)new RuntimeException("\u56fe\u7247\u52a0\u8f7d\u8fdd\u89c4 getThumb h <= 0, " + originUrl)), new Object[0]);
                }
                return "";
            }
            if (h >= screenHeight - 1) {
                h = screenHeight;
                if (RuntimeContext.sIsDebuggable && !useFullScreen) {
                    MLog.warn(TAG, Log.getStackTraceString((Throwable)new RuntimeException("\u56fe\u7247\u52a0\u8f7d\u8fdd\u89c4 getThumb too large, " + originUrl)), new Object[0]);
                }
            }
            if (!useFullScreen && h > screenHeight - 1) {
                h = screenHeight / 2;
            }
            return w > 0 && h > 0 ? YYImageUtils.getThumbnailPostfixPx(w, h, true) : "";
        }
        return "";
    }

    public static boolean canUseWebp() {
        if (RuntimeContext.sIsMainProcess && sCanUseWebP == -1) {
            boolean realUseWebp = SettingFlags.getBoolean("usewebp", true);
            if (realUseWebp) {
                realUseWebp = !SystemUtils.isSamSung() || !SystemUtils.isAndroid9();
            }
            sCanUseWebP = realUseWebp ? 1 : 0;
        }
        return sCanUseWebP == 1;
    }

    public static void resetUseWebpFlag() {
        sCanUseWebP = -1;
    }

    public static String getThumbnailPostfixPxForCircle(int width, int height, boolean useWebp, int circleSize) {
        boolean realUseWebp;
        boolean bl = realUseWebp = useWebp && YYImageUtils.canUseWebp();
        if (realUseWebp) {
            if (width > 0 && height > 0) {
                return "?x-oss-process=image/resize,w_" + width + ",h_" + height + "/circle,r_" + circleSize + "/format,webp";
            }
            return "?x-oss-process=image/circle,r_" + circleSize + "/format,webp";
        }
        if (width > 0 && height > 0) {
            if (useWebp && circleSize > 0) {
                return "?x-oss-process=image/resize,w_" + width + ",h_" + height + "/circle,r_" + circleSize + "/format,png";
            }
            return "?x-oss-process=image/resize,w_" + width + ",h_" + height + "/circle,r_" + circleSize;
        }
        return "";
    }

    @NonNull
    public static String getMinimumPostfixPx(int width, int height, boolean useWebp) {
        boolean realUseWebp;
        int w = 35;
        int h = 35;
        int temp = (int)((double)width * 0.06);
        if (temp > w) {
            w = temp;
        }
        if ((temp = (int)((double)height * 0.06)) > h) {
            h = temp;
        }
        boolean bl = realUseWebp = useWebp && YYImageUtils.canUseWebp();
        if (realUseWebp) {
            return "?x-oss-process=image/resize,w_" + w + ",h_" + h + "/quality,Q_20/format,webp";
        }
        return "?x-oss-process=image/resize,w_" + w + ",h_" + h + "/quality,Q_20";
    }

    @NotNull
    public static String getSnapUrl(String url, int width, int height) {
        String originUrl = url;
        return originUrl + YYImageUtils.getMinimumPostfixPx(width, height, true);
    }

    public static String getCropPostfix(int startX, int startY, int width, int height) {
        return "?x-oss-process=image/crop,x_" + startX + ",y_" + startY + ",w_" + width + ",h_" + height;
    }

    @NonNull
    public static String getThumbnailPostfixPx(int width, int height, boolean useWebp) {
        boolean realUseWebp;
        boolean bl = realUseWebp = useWebp && YYImageUtils.canUseWebp();
        if (realUseWebp) {
            if (width > 0 && height > 0) {
                return "?x-oss-process=image/resize,w_" + width + ",h_" + height + "/format,webp";
            }
            return "?x-oss-process=image/format,webp";
        }
        if (width > 0 && height > 0) {
            return "?x-oss-process=image/resize,w_" + width + ",h_" + height;
        }
        return "";
    }

    public static String getCropThumbnailPostfix(int size) {
        return "?x-oss-process=image/resize,m_fill,w_" + size + ",h_" + size + "/format,webp";
    }

    @NonNull
    public static String getCircleThumbnailPostfix(int size) {
        size = ScreenUtils.getInstance().dip2px(size);
        return YYImageUtils.getThumbnailPostfixPxForCircle(size, size, true, size);
    }

    public static Bitmap decodeByWidth(String filePath, int desiredWidth) {
        try {
            return YYImageUtils.decodeFileOrThrow(filePath, desiredWidth, 0);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Bitmap decodeBySize(String filePath, int size) {
        Rect rect = YYImageUtils.decodeBmpSize(filePath);
        if (rect.width() > rect.height()) {
            return YYImageUtils.decodeByWidth(filePath, size);
        }
        return YYImageUtils.decodeByHeight(filePath, size);
    }

    public static Rect decodeBmpSize(String filePath) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        YYImageUtils.decodeFile(filePath, opts);
        return new Rect(0, 0, opts.outWidth, opts.outHeight);
    }

    public static Rect decodeBmpSizeBy(String filePath, int desiredWidth, int desiredHeight) {
        BitmapFactory.Options opts = YYImageUtils.getProperOptions(filePath, desiredWidth, desiredHeight, false);
        if (opts == null) {
            return null;
        }
        return new Rect(0, 0, opts.outWidth, opts.outHeight);
    }

    public static Bitmap decodeByHeight(String filePath, int desiredHeight) {
        try {
            return YYImageUtils.decodeFileOrThrow(filePath, 0, desiredHeight);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Bitmap decodeByWidthOrThrow(String filePath, int desiredWidth) {
        return YYImageUtils.decodeFileOrThrow(filePath, desiredWidth, 0);
    }

    public static Bitmap decodeByHeightOrThrow(String filePath, int desiredHeight) {
        return YYImageUtils.decodeFileOrThrow(filePath, 0, desiredHeight);
    }

    public static Bitmap decodeFile(String filePath, int desiredWidth, int desiredHeight) {
        try {
            return YYImageUtils.decodeFileOrThrow(filePath, desiredWidth, desiredHeight);
        }
        catch (Throwable e) {
            MLog.warn(TAG, "fail to decode %s, %s", filePath, e.toString());
            return null;
        }
    }

    public static Bitmap decodeResource(Context context, int resId, int desiredWidth, int desiredHeight) {
        if (desiredWidth <= 0 && desiredHeight <= 0) {
            return YYImageUtils.decodeResource(context, resId);
        }
        try {
            return YYImageUtils.decodeResOrThrow(context, resId, desiredWidth, desiredHeight, true);
        }
        catch (Throwable e) {
            MLog.error(TAG, e);
            return null;
        }
    }

    public static Bitmap decodeResource(Context context, int resId) {
        try {
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
        }
        catch (OutOfMemoryError e) {
            MLog.error(TAG, e);
            return null;
        }
    }

    public static Bitmap decodeFileOrThrow(String filePath, int desiredWidth, int desiredHeight) {
        return YYImageUtils.decodeFileOrThrow(filePath, desiredWidth, desiredHeight, true);
    }

    public static Bitmap decodeFileOrThrow(String filePath, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        BitmapFactory.Options opts = YYImageUtils.getProperOptions(filePath, desiredWidth, desiredHeight, isMemoryPrior);
        if (opts == null) {
            return null;
        }
        opts.inJustDecodeBounds = false;
        return YYImageUtils.decodeFile(filePath, opts);
    }

    public static BitmapFactory.Options getProperOptions(byte[] data, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
        if (opts.outWidth <= 0 || opts.outHeight <= 0) {
            return null;
        }
        int sampleSize = YYImageUtils.calSampleSize(desiredWidth, desiredHeight, isMemoryPrior, opts);
        if (desiredHeight > 0 || desiredWidth > 0) {
            do {
                opts.inSampleSize = sampleSize++;
                BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            } while (desiredWidth > 0 && opts.outWidth > desiredWidth || desiredHeight > 0 && opts.outHeight > desiredHeight);
        }
        return opts;
    }

    private static BitmapFactory.Options getProperOptions(String filePath, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        YYImageUtils.decodeFile(filePath, opts);
        if (opts.outWidth <= 0 || opts.outHeight <= 0) {
            return null;
        }
        int sampleSize = YYImageUtils.calSampleSize(desiredWidth, desiredHeight, isMemoryPrior, opts);
        if (desiredHeight > 0 || desiredWidth > 0) {
            do {
                opts.inSampleSize = sampleSize++;
                YYImageUtils.decodeFile(filePath, opts);
            } while (desiredWidth > 0 && opts.outWidth > desiredWidth || desiredHeight > 0 && opts.outHeight > desiredHeight);
        }
        return opts;
    }

    public static Bitmap decodeResOrThrow(Context context, int drawableId, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        Resources res = context.getResources();
        BitmapFactory.decodeResource((Resources)res, (int)drawableId, (BitmapFactory.Options)opts);
        if (opts.outWidth <= 0 || opts.outHeight <= 0) {
            return null;
        }
        int sampleSize = YYImageUtils.calSampleSize(desiredWidth, desiredHeight, isMemoryPrior, opts);
        opts.inJustDecodeBounds = false;
        opts.inSampleSize = sampleSize;
        return BitmapFactory.decodeResource((Resources)res, (int)drawableId, (BitmapFactory.Options)opts);
    }

    private static int calSampleSize(int desiredWidth, int desiredHeight, boolean isMemoryPrior, BitmapFactory.Options opts) {
        int sampleSize;
        if (desiredWidth == 0 && desiredHeight == 0) {
            sampleSize = 1;
        } else if (desiredHeight == 0) {
            sampleSize = (opts.outWidth + desiredWidth - 1) / desiredWidth;
        } else if (desiredWidth == 0) {
            sampleSize = (opts.outHeight + desiredHeight - 1) / desiredHeight;
        } else {
            int horRatio = (opts.outWidth + desiredWidth - 1) / desiredWidth;
            int verRatio = (opts.outHeight + desiredHeight - 1) / desiredHeight;
            sampleSize = isMemoryPrior ? Math.max(horRatio, verRatio) : Math.min(horRatio, verRatio);
        }
        return sampleSize;
    }

    public static Bitmap decodeFile(String filePath, BitmapFactory.Options opt) {
        Bitmap bmp;
        block7: {
            if (StringUtils.isEmpty(filePath)) {
                return null;
            }
            bmp = null;
            try {
                if (YYFileUtils.isContentUri(filePath)) {
                    try {
                        ContentResolver contentResolver = RuntimeContext.sApplicationContext.getContentResolver();
                        ParcelFileDescriptor pfd = contentResolver.openFileDescriptor(Uri.parse((String)filePath), "r");
                        if (pfd != null) {
                            bmp = BitmapFactory.decodeFileDescriptor((FileDescriptor)pfd.getFileDescriptor(), null, (BitmapFactory.Options)opt);
                        }
                        break block7;
                    }
                    catch (FileNotFoundException e) {
                        MLog.error((Object)"ImImageUploader", "openFileDescriptor error: ", e, new Object[0]);
                    }
                    break block7;
                }
                bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opt);
            }
            catch (OutOfMemoryError err) {
                MLog.error((Object)TAG, "oom: " + filePath, new Object[0]);
                bmp = null;
            }
        }
        return bmp;
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, int maxBorderLength, boolean recycle) {
        float ratio;
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int newHeight = 0;
        int newWidth = 0;
        if (width > height) {
            ratio = (float)height / (float)width;
            newWidth = maxBorderLength;
            newHeight = (int)((float)newWidth * ratio);
        } else if (height > width) {
            ratio = (float)width / (float)height;
            newHeight = maxBorderLength;
            newWidth = (int)((float)newHeight * ratio);
        } else {
            newWidth = maxBorderLength;
            newHeight = maxBorderLength;
        }
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        try {
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            if (recycle && !bitmap.isRecycled() && bitmap != resizedBitmap) {
                bitmap.recycle();
            }
            return resizedBitmap;
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)TAG, "lcy resizeBitmap OOM %s", e, new Object[0]);
            return null;
        }
    }

    public static boolean resizeAndRotateImage(String imageFile, String newFileName, int maxWidth, int maxHeight, Matrix matrix) {
        return YYImageUtils.resizeAndRotateImage(imageFile, newFileName, maxWidth, maxHeight, matrix, 75);
    }

    public static int calInSampleSize(BitmapFactory.Options options, int destWidth, int destHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > destWidth || width > destHeight) {
            int widthRatio;
            int heightRatio = (int)Math.floor((float)height / (float)destHeight);
            inSampleSize = Math.min(heightRatio, widthRatio = (int)Math.floor((float)width / (float)destWidth));
            if (inSampleSize <= 0) {
                inSampleSize = 1;
            }
            while (ImageUtil.isBitmapOverSize(inSampleSize, width, height)) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    public static boolean resizeImage(String imageFile, String newFileName, int destWidth, int destHeight, Matrix matrix, int quality) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        YYImageUtils.decodeFile(imageFile, options);
        int originWidth = options.outWidth;
        int originHeight = options.outHeight;
        if (originWidth <= 0 || originHeight <= 0) {
            MLog.error((Object)TAG, "bitmap width or height is zero", new Object[0]);
            return false;
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = YYImageUtils.calInSampleSize(options, destWidth, destHeight);
        Bitmap bitmap = null;
        try {
            bitmap = YYImageUtils.decodeFile(imageFile, options);
            int decodedWidth = bitmap.getWidth();
            int decodedHeight = bitmap.getHeight();
            if (matrix == null) {
                matrix = new Matrix();
            }
            matrix.setScale((float)destWidth / (float)decodedWidth, (float)destHeight / (float)decodedHeight);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)decodedWidth, (int)decodedHeight, (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)TAG, "Empty Catch on resizeImage", e, new Object[0]);
        }
        if (bitmap != null) {
            try {
                YYFileUtils out = YYFileUtils.openFile(newFileName);
                out.write(bitmap, quality);
                out.close();
                return true;
            }
            catch (Exception e) {
                MLog.error(TAG, e);
            }
        }
        return false;
    }

    public static boolean resizeAndRotateImage(String imageFile, String newFileName, int maxWidth, int maxHeight, Matrix matrix, int quality) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        YYImageUtils.decodeFile(imageFile, options);
        int originWidth = options.outWidth;
        int originHeight = options.outHeight;
        if (originWidth <= 0 || originHeight <= 0) {
            MLog.error((Object)TAG, "bitmap width or height is zero", new Object[0]);
            return false;
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, maxWidth, maxHeight);
        float factor = options.inSampleSize;
        Bitmap bitmap = null;
        try {
            bitmap = YYImageUtils.decodeFile(imageFile, options);
            int decodedWidth = bitmap.getWidth();
            int decodedHeight = bitmap.getHeight();
            int actualWidth = (int)((float)originWidth / factor);
            int actualHeight = (int)((float)originHeight / factor);
            if (matrix == null) {
                matrix = new Matrix();
            }
            matrix.setScale((float)actualWidth / (float)decodedWidth, (float)actualHeight / (float)decodedHeight);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)decodedWidth, (int)decodedHeight, (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)TAG, "Empty Catch on resizeAndRotateImage", e, new Object[0]);
        }
        if (bitmap != null) {
            try {
                YYFileUtils out = YYFileUtils.openFile(newFileName);
                out.write(bitmap, quality);
                out.close();
                return true;
            }
            catch (Exception e) {
                MLog.error(TAG, e);
            }
        }
        return false;
    }

    public static int getRotate(String filepath) {
        try {
            ExifInterface exif = new ExifInterface(filepath);
            return exif.getAttributeInt("Orientation", 1);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getAngleFromRotateEnum(int rotate) {
        switch (rotate) {
            case 3: {
                return 180;
            }
            case 6: {
                return 90;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    public static Bitmap rotateAndResizeImage(Bitmap inBitmap, int maxWidth, int maxHeight, int rotate) {
        boolean needRotate;
        int imgWidth = inBitmap.getWidth();
        int imgHeight = inBitmap.getHeight();
        boolean needResize = imgWidth > maxWidth || imgHeight > maxHeight;
        boolean bl = needRotate = YYImageUtils.getAngleFromRotateEnum(rotate) != 0;
        if (needResize || needRotate) {
            Matrix matrix = new Matrix();
            if (needResize) {
                float scale = Math.min((float)maxWidth / (float)imgWidth, (float)maxHeight / (float)imgHeight);
                matrix.postScale(scale, scale);
            }
            if (needRotate) {
                matrix.postRotate((float)YYImageUtils.getAngleFromRotateEnum(rotate));
            }
            try {
                Bitmap resultBitmap = Bitmap.createBitmap((Bitmap)inBitmap, (int)0, (int)0, (int)imgWidth, (int)imgHeight, (Matrix)matrix, (boolean)true);
                return resultBitmap;
            }
            catch (OutOfMemoryError e) {
                MLog.error((Object)TAG, "Empty Catch on rotateAndResizeImage", e, new Object[0]);
            }
        }
        return inBitmap;
    }

    public static Bitmap decodeImageFromStream(InputStream queryStream, InputStream decodeStream) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)queryStream, null, (BitmapFactory.Options)options);
        if (options.outWidth <= 0 || options.outHeight <= 0) {
            MLog.error((Object)TAG, "bitmap width or height is zero", new Object[0]);
            return null;
        }
        options.inJustDecodeBounds = false;
        int widthScale = options.outWidth / 800;
        int heightScale = options.outHeight / 800;
        options.inSampleSize = Math.max(widthScale, heightScale);
        options.inScaled = false;
        try {
            return BitmapFactory.decodeStream((InputStream)decodeStream, null, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)TAG, "decodeImageFromStream error, OOM", new Object[0]);
            return null;
        }
    }

    public static boolean saveBitmapToFile(Bitmap bitmap, String filename) throws Exception {
        boolean isSuccess = false;
        if (bitmap != null && filename != null) {
            YYFileUtils out = YYFileUtils.openFile(filename, false);
            isSuccess = out.write(bitmap, 75);
            out.close();
        }
        return isSuccess;
    }

    public static boolean isImage(InputStream queryStream) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeStream((InputStream)queryStream, null, (BitmapFactory.Options)options);
            return options.outWidth > 0 && options.outHeight > 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isImage(File file) {
        if (file == null) {
            return false;
        }
        return YYImageUtils.isImage(file.getPath());
    }

    public static boolean isImage(String imageFile) {
        Cursor cursor;
        if (StringUtils.isEmpty(imageFile)) {
            return false;
        }
        if (SdkVersionUtils.hasScopedStorage() && (cursor = RuntimeContext.sApplicationContext.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{imageFile}, null)) != null && cursor.moveToFirst()) {
            cursor.close();
            return true;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        try {
            YYImageUtils.decodeFile(imageFile, options);
            return options.outWidth > 0 && options.outHeight > 0;
        }
        catch (Throwable e) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose(TAG, "%d isn't image file", imageFile);
            }
            return false;
        }
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float roundPx) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -1;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-1);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -1;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-1);
        canvas.drawRoundRect(rectF, (float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static boolean isNotDefaultPortrait(Bitmap image) {
        return image != sDefaultFemalePhotoBitmap && image != sDefaultMalePhotoBitmap && image != sDefaultMalePhotoOffline && image != sDefaultFemalePhotoOffline && image != sDefaultMalePhoto && image != sDefaultMalePhotoOffline;
    }

    public static Bitmap getGrayBmp(Bitmap image) {
        if (image != null) {
            try {
                Bitmap grayscalBitmap = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
                Canvas canvas = new Canvas(grayscalBitmap);
                Paint paint = new Paint();
                ColorMatrix matrix = new ColorMatrix();
                matrix.setSaturation(0.0f);
                ColorMatrixColorFilter filter = new ColorMatrixColorFilter(matrix);
                paint.setColorFilter((ColorFilter)filter);
                canvas.drawBitmap(image, 0.0f, 0.0f, paint);
                return grayscalBitmap;
            }
            catch (Exception e) {
                MLog.error(TAG, e);
            }
            catch (OutOfMemoryError e) {
                MLog.error(TAG, e);
            }
        }
        return null;
    }

    public static Bitmap createClipBitmap(Bitmap bmp, Rect photoRect) {
        Bitmap portrait;
        block5: {
            portrait = null;
            try {
                if (bmp != null) {
                    int bmpWidth = bmp.getWidth();
                    int bmpHeight = bmp.getHeight();
                    if (bmpWidth > 0 && bmpHeight > 0) {
                        photoRect.right = Math.min(photoRect.right, bmpWidth);
                        photoRect.bottom = Math.min(photoRect.bottom, bmpHeight);
                        portrait = Bitmap.createBitmap((Bitmap)bmp, (int)photoRect.left, (int)photoRect.top, (int)photoRect.width(), (int)photoRect.height());
                        if (bmp != portrait && !bmp.isRecycled()) {
                            bmp.recycle();
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (MLog.isLogLevelAboveDebug()) break block5;
                MLog.debug(TAG, "createClipBitmap error" + e, new Object[0]);
            }
        }
        return portrait;
    }

    public static boolean renameFile(String oriPath, String newPath) {
        File file = new File(oriPath);
        File newFile = new File(newPath);
        return file.renameTo(newFile);
    }

    public static Bitmap decodeResource(Context context, int resId, BitmapFactory.Options opt) {
        try {
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)opt);
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)TAG, "decodeResource error", e, new Object[0]);
            return null;
        }
    }

    public static Bitmap createBlended(Bitmap src) {
        if (src == null) {
            throw new IllegalArgumentException("Given src is null.");
        }
        Bitmap target = Bitmap.createBitmap((int)src.getWidth(), (int)src.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(target);
        c.drawBitmap(src, 0.0f, 0.0f, null);
        c.drawColor(-1895825408);
        return target;
    }

    public static Bitmap resize(Bitmap oriBitmap, int targetWidth, int targetHeight) {
        if (oriBitmap == null) {
            return null;
        }
        int width = oriBitmap.getWidth();
        int height = oriBitmap.getHeight();
        float scaleWidth = (float)targetWidth / (float)width;
        float scaleHeight = (float)targetHeight / (float)height;
        float scale = Math.min(scaleWidth, scaleHeight);
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        try {
            return Bitmap.createBitmap((Bitmap)oriBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)TAG, "resizeBitmap OOM %s", e, new Object[0]);
            return null;
        }
    }

    public static Bitmap resize(Bitmap oriBitmap, float scale) {
        if (oriBitmap == null) {
            return null;
        }
        int width = oriBitmap.getWidth();
        int height = oriBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        try {
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)oriBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            oriBitmap.recycle();
            return resizedBitmap;
        }
        catch (OutOfMemoryError e) {
            oriBitmap.recycle();
            MLog.error((Object)TAG, "resizeBitmap OOM %s", e, new Object[0]);
            return null;
        }
    }

    public static int getCameraPhotoOrientation(String imagePath) {
        int rotate = 0;
        try {
            File imageFile = new File(imagePath);
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                    break;
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "getCameraPhotoOrientation error", e, new Object[0]);
        }
        return rotate;
    }

    public static Bitmap fixPictureOrientation(String path, boolean replaceSrcFile, ImageConfig imageConfig, int quality) {
        Bitmap bitmap = ImageUtil.decodeSampledBitmapFile(path, imageConfig, true);
        if (replaceSrcFile) {
            try {
                String extension = YYFileUtils.getFileExtension(path);
                Bitmap.CompressFormat format = Bitmap.CompressFormat.JPEG;
                if (extension != null && extension.equalsIgnoreCase(".png")) {
                    format = Bitmap.CompressFormat.PNG;
                }
                YYFileUtils.saveBitmap(bitmap, path, format, quality);
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, "fixPictureOrientation saveBitmap error! " + throwable, new Object[0]);
            }
        }
        return bitmap;
    }

    public static int getPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "getPictureDegree error!" + throwable, new Object[0]);
        }
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "getPictureDegree path:" + path + ", degree = " + degree, new Object[0]);
        }
        return degree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageSuffix(Uri uri) {
        InputStream inputStream = null;
        try {
            inputStream = RuntimeContext.sApplicationContext.getContentResolver().openInputStream(uri);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            String string2 = options.outMimeType.replace("image/", ".");
            return string2;
        }
        catch (Exception e) {
            String string3 = ".jpg";
            return string3;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean canAppendResize(String url) {
        return url != null && url.startsWith("http") && !url.contains("resize,") && !url.contains(".svga") && !url.contains("format,");
    }

    public static Point getBitmapSize(ContentResolver resolver, Uri uri) {
        Point imageSize = YYImageUtils.getBitmapBound(resolver, uri);
        int w = imageSize.x;
        int h = imageSize.y;
        if (YYImageUtils.shouldRotate(resolver, uri)) {
            w = imageSize.y;
            h = imageSize.x;
        }
        return new Point(w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getBitmapBound(ContentResolver resolver, Uri uri) {
        InputStream is = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            is = resolver.openInputStream(uri);
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            int width = options.outWidth;
            int height = options.outHeight;
            Point point = new Point(width, height);
            return point;
        }
        catch (FileNotFoundException e) {
            MLog.error((Object)TAG, "getBitmapBound error", e, new Object[0]);
            Point point = new Point(0, 0);
            return point;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPath(ContentResolver resolver, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (SCHEME_CONTENT.equals(uri.getScheme())) {
            try (Cursor cursor = null;){
                cursor = resolver.query(uri, new String[]{"_data"}, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) {
                    String string2 = null;
                    return string2;
                }
                String string3 = cursor.getString(cursor.getColumnIndex("_data"));
                return string3;
            }
        }
        return uri.getPath();
    }

    private static boolean shouldRotate(ContentResolver resolver, Uri uri) {
        ExifInterface exif;
        try {
            exif = ExifInterfaceCompat.newInstance(YYImageUtils.getPath(resolver, uri));
        }
        catch (Exception e) {
            MLog.warn(TAG, "could not read exif info of the image: " + uri, new Object[0]);
            return false;
        }
        int orientation = exif.getAttributeInt("Orientation", -1);
        return orientation == 6 || orientation == 8;
    }

    public static Uri getImageContentUri(Context context, File imageFile) {
        String filePath = imageFile.getAbsolutePath();
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{filePath}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            cursor.close();
            return Uri.withAppendedPath((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (String)("" + id2));
        }
        if (imageFile.exists()) {
            if (SdkVersionUtils.hasScopedStorage()) {
                ContentResolver resolver = context.getContentResolver();
                Uri picCollection = MediaStore.Images.Media.getContentUri((String)"external_primary");
                ContentValues picDetail = new ContentValues();
                picDetail.put("_display_name", imageFile.getName());
                picDetail.put("mime_type", "image/jpg");
                picDetail.put("relative_path", "DCIM/" + UUID.randomUUID().toString());
                picDetail.put("is_pending", Integer.valueOf(1));
                Uri finaluri = resolver.insert(picCollection, picDetail);
                picDetail.clear();
                picDetail.put("is_pending", Integer.valueOf(0));
                resolver.update(picCollection, picDetail, null, null);
                return finaluri;
            }
            ContentValues values = new ContentValues();
            values.put("_data", filePath);
            return context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        return null;
    }
}

