/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Build;
import android.text.Html;
import android.text.InputFilter;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.PluralsRes;
import androidx.annotation.StringRes;
import androidx.collection.SparseArrayCompat;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.IOUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class StringUtils {
    static final String TAG = "StringUtils";
    public static final int EMPTY = 0;
    public static final int ONLY_EMOJI = 1;
    public static final int ONLY_TEXT = 2;
    public static final int BOTH_EMOJI_TEXT = 3;
    private static final char UNICODE_SURROGATE_START_CHAR = '\ud800';
    private static final char UNICODE_SURROGATE_END_CHAR = '\udfff';
    private static HashMap<String, DecimalFormat> mDecimalFormatCache = new HashMap();
    private static HashMap<String, DecimalFormat> mDecimalFormatUSCache = new HashMap();
    private static final double ONE_BILLION = 1.0E9;
    private static final double ONE_MILLION = 1000000.0;
    private static final double ONE_THOUSAND = 1000.0;
    private static SparseArrayCompat<NumberFormat> sNumberFormatUSCache = new SparseArrayCompat();

    public static boolean isNotEmpty(String[] aTexts) {
        return !StringUtils.isEmpty(aTexts);
    }

    public static boolean isEmpty(String[] aTexts) {
        return aTexts == null || aTexts.length == 0;
    }

    public static boolean isEmpty(String aText) {
        return aText == null || aText.trim().length() == 0;
    }

    public static boolean isEmpty(StringBuffer aStringBuffer) {
        return aStringBuffer == null || aStringBuffer.length() == 0;
    }

    public static boolean isNotEmpty(String aText) {
        return !StringUtils.isEmpty(aText);
    }

    public static boolean isNumeric(String text) {
        if (StringUtils.isEmpty(text)) {
            return false;
        }
        int size = text.length();
        for (int i = 0; i < size; ++i) {
            char chr = text.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static String merge(CharSequence ... mText) {
        if (mText != null) {
            int length = mText.length;
            StringBuilder mStringBuilder = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                if (mText[i] == null || mText[i].length() <= 0 || mText[i].toString().equals("null")) continue;
                mStringBuilder.append(mText[i]);
            }
            return mStringBuilder.toString();
        }
        return null;
    }

    public static int parseInt(String aValue, int aDefault) {
        if (aValue == null || aValue.length() == 0) {
            return aDefault;
        }
        int result = aDefault;
        boolean isHex = false;
        isHex = aValue.startsWith("0x");
        if (isHex) {
            aValue = aValue.substring(2);
        }
        try {
            result = !isHex ? Integer.parseInt(aValue) : (int)Long.parseLong(aValue, 16);
        }
        catch (Exception ex) {
            MLog.error(TAG, ex);
        }
        return result;
    }

    public static int parseInt(String aValue) {
        return StringUtils.parseInt(aValue, 0);
    }

    public static long parseLong(String aValue, long aDefault) {
        if (aValue == null || aValue.length() == 0) {
            return aDefault;
        }
        long result = aDefault;
        boolean isHex = false;
        isHex = aValue.startsWith("0x");
        if (isHex) {
            aValue = aValue.substring(2);
        }
        try {
            result = !isHex ? Long.parseLong(aValue) : Long.parseLong(aValue, 16);
        }
        catch (Exception ex) {
            MLog.error(TAG, ex);
        }
        return result;
    }

    public static boolean isHtmlText(String message) {
        try {
            return message.matches(".*<([^>]*)>.*");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long parseLong(String aValue) {
        return StringUtils.parseLong(aValue, 0L);
    }

    public static double parseDouble(String aValue, double aDefault) {
        if (aValue == null || aValue.length() == 0) {
            return aDefault;
        }
        double result = aDefault;
        try {
            result = Double.parseDouble(aValue);
        }
        catch (Exception ex) {
            MLog.error(TAG, ex);
        }
        return result;
    }

    public static double parseDouble(String aValue) {
        return StringUtils.parseDouble(aValue, 0.0);
    }

    public static String[] split(String original, String regex) {
        return StringUtils.split(original, regex, true);
    }

    public static String[] split(String aOriginal, String aRegex, boolean aCanNull) {
        if (StringUtils.isEmpty(aOriginal)) {
            return new String[0];
        }
        if (aRegex == null || aRegex.length() == 0) {
            return new String[]{aOriginal};
        }
        String[] sTarget = null;
        int sTargetLength = 0;
        int sLength = aOriginal.length();
        int sStartIndex = 0;
        int sEndIndex = 0;
        sEndIndex = aOriginal.indexOf(aRegex, 0);
        while (sEndIndex != -1 && sEndIndex < sLength) {
            sTargetLength += aCanNull || sStartIndex != sEndIndex ? 1 : 0;
            sStartIndex = sEndIndex += sEndIndex >= 0 ? aRegex.length() : 0;
            sEndIndex = aOriginal.indexOf(aRegex, sEndIndex);
        }
        sTarget = new String[sTargetLength += aCanNull || sStartIndex != sLength ? 1 : 0];
        int sIndex = 0;
        sIndex = 0;
        sEndIndex = aOriginal.indexOf(aRegex, 0);
        sStartIndex = 0;
        while (sEndIndex != -1 && sEndIndex < sLength) {
            if (aCanNull || sStartIndex != sEndIndex) {
                sTarget[sIndex] = aOriginal.substring(sStartIndex, sEndIndex);
                ++sIndex;
            }
            sStartIndex = sEndIndex += sEndIndex >= 0 ? aRegex.length() : 0;
            sEndIndex = aOriginal.indexOf(aRegex, sEndIndex);
        }
        if (aCanNull || sStartIndex != sLength) {
            sTarget[sTargetLength - 1] = aOriginal.substring(sStartIndex);
        }
        return sTarget;
    }

    public static String clipFileName(String str, int max, char splt) {
        int charNums = str.length();
        if (charNums < max) {
            return str;
        }
        int spltIndex = str.lastIndexOf(splt);
        if (spltIndex == -1) {
            spltIndex = charNums;
        }
        int needMinusNums = charNums - max;
        String strSuffix = str.substring(spltIndex, charNums);
        int needMinusEndIndex = spltIndex - needMinusNums;
        String strPreffix = null;
        if (needMinusEndIndex < 0) {
            str = str.substring(0, max);
        } else {
            strPreffix = str.substring(0, needMinusEndIndex);
            str = strPreffix + strSuffix;
        }
        return str;
    }

    public static String[] splitAndTrim(String value, String expr) {
        value = value.replace(" ", "");
        return value.split(expr);
    }

    public static String generateRandomString() {
        long currentTime = System.currentTimeMillis();
        String timeStr = Long.toHexString(currentTime);
        int randomNum = (int)(Math.random() * 1000000.0);
        String randomStr = Integer.toHexString(randomNum);
        return (timeStr + randomStr).toUpperCase(Locale.ENGLISH);
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String aOriginalStr, String anotherStr) {
        return aOriginalStr != null && anotherStr != null && aOriginalStr.length() == anotherStr.length() && aOriginalStr.equalsIgnoreCase(anotherStr);
    }

    public static boolean startsWithIgnoreCase(String aOriginalStr, String aPrefixStr) {
        return aOriginalStr == null && aPrefixStr == null || aOriginalStr != null && aPrefixStr != null && aOriginalStr.toLowerCase().startsWith(aPrefixStr.toLowerCase());
    }

    public static boolean endsWithIgnoreCase(String aOriginalStr, String aPrefixStr) {
        return aOriginalStr == null && aPrefixStr == null || aOriginalStr != null && aPrefixStr != null && aOriginalStr.toLowerCase().endsWith(aPrefixStr.toLowerCase());
    }

    public static int indexOfIgnoreCase(String aOriginalStr, String aStr, int aFromIndex) {
        if (aOriginalStr == null || aStr == null) {
            return -1;
        }
        int aTextLength = aOriginalStr.length();
        int sOtherTextLength = aStr.length();
        int sMax = aTextLength - sOtherTextLength;
        if (aFromIndex >= aTextLength) {
            if (aTextLength == 0 && aFromIndex == 0 && sOtherTextLength == 0) {
                return 0;
            }
            return -1;
        }
        if (aFromIndex < 0) {
            aFromIndex = 0;
        }
        if (sOtherTextLength == 0) {
            return aFromIndex;
        }
        char aFirst = Character.toLowerCase(aStr.charAt(0));
        int i = aFromIndex;
        block0: while (true) {
            if (i <= sMax && Character.toLowerCase(aOriginalStr.charAt(i)) != aFirst) {
                ++i;
                continue;
            }
            if (i > sMax) {
                return -1;
            }
            int j = i + 1;
            int end = j + sOtherTextLength - 1;
            int k = 1;
            while (j < end) {
                char c2;
                char c1;
                if ((c1 = Character.toLowerCase(aOriginalStr.charAt(j++))) == (c2 = Character.toLowerCase(aStr.charAt(k++)))) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static String join(List<String> list, String seperator) {
        if (null == seperator) {
            return "";
        }
        if (null == list || list.isEmpty()) {
            return "";
        }
        int listSize = list.size();
        StringBuilder sb = new StringBuilder();
        if (listSize > 0) {
            sb.append(list.get(0));
            for (int i = 1; i < listSize; ++i) {
                sb.append(seperator);
                sb.append(list.get(i));
            }
        }
        return sb.toString();
    }

    public static List<String> unJoin(String str, String seperator) {
        if (StringUtils.isEmpty(str) || null == seperator) {
            return new ArrayList<String>();
        }
        String[] result = str.split(seperator);
        if (null == result) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>(result.length);
        for (String item : result) {
            list.add(item);
        }
        return list;
    }

    public static String replaceNBSPSpace(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return str.replace('\u00a0', ' ');
    }

    public static String toEmpty(String text) {
        return text == null ? "" : text;
    }

    public static final byte[] createUTFByte(String text) {
        return StringUtils.createStringByte(text, "UTF-8");
    }

    public static final byte[] createStringByte(String sText, String sCharset) {
        if (sText == null) {
            return null;
        }
        try {
            sCharset = StringUtils.isEmpty(sCharset) ? "UTF-8" : sCharset;
            return sText.getBytes(sCharset);
        }
        catch (Exception e) {
            try {
                return sText.getBytes(sCharset.toLowerCase(Locale.ENGLISH));
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return sText.getBytes();
            }
        }
    }

    @Deprecated
    public static final String utf8ByteToString(byte[] body) {
        if (body == null) {
            return "";
        }
        return StringUtils.utf8ByteToString(body, 0, body.length);
    }

    public static final String byteToStringUtf8(byte[] body) {
        try {
            return new String(body, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            MLog.error((Object)TAG, "byteToStringUtf8", e, new Object[0]);
            return "";
        }
    }

    @Deprecated
    public static final String utf8ByteToString(byte[] aData, int aOffset) {
        if (aData == null || aData.length == 0 || aOffset < 0 || aOffset >= aData.length) {
            return "";
        }
        int utflen = IOUtils.readShort(aData, aOffset);
        return StringUtils.utf8ByteToString(aData, aOffset + 2, utflen);
    }

    @Deprecated
    public static final String utf8ByteToString(byte[] aData, int aOffset, int aLength) {
        if (aData == null || aOffset < 0 || aLength <= 0) {
            return "";
        }
        StringBuffer sStringBuffer = new StringBuffer(aLength >> 1);
        StringUtils.utf8ByteToString(aData, aOffset, aLength, sStringBuffer);
        return new String(sStringBuffer);
    }

    @Deprecated
    public static final int utf8ByteToString(byte[] bytes, int aReadOffset, int aReadSize, StringBuffer aBuffer) {
        if (bytes == null || bytes.length == 0 || aBuffer == null || aReadOffset < 0 || aReadSize <= 0) {
            return 0;
        }
        int index = aReadOffset;
        aReadSize += aReadOffset;
        block5: while (index < aReadSize) {
            int i = bytes[index] & 0xFF;
            switch (i >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++index;
                    aBuffer.append((char)i);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((index += 2) > aReadSize) {
                        return aBuffer.length();
                    }
                    byte byte0 = bytes[index - 1];
                    if ((byte0 & 0xC0) != 128) {
                        return aBuffer.length();
                    }
                    aBuffer.append((char)((i & 0x1F) << 6 | byte0 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((index += 3) > aReadSize) {
                        return aBuffer.length();
                    }
                    byte byte1 = bytes[index - 2];
                    byte byte2 = bytes[index - 1];
                    if ((byte1 & 0xC0) != 128 || (byte2 & 0xC0) != 128) {
                        return aBuffer.length();
                    }
                    aBuffer.append((char)((i & 0xF) << 12 | (byte1 & 0x3F) << 6 | (byte2 & 0x3F) << 0));
                    continue block5;
                }
            }
            return aBuffer.length();
        }
        return aBuffer.length();
    }

    public static boolean parseBoolean(String value, boolean aDefault) {
        if (value == null) {
            return aDefault;
        }
        return "1".endsWith(value) || "true".equalsIgnoreCase(value);
    }

    public static boolean parseBoolean(String value) {
        return StringUtils.parseBoolean(value, false);
    }

    public static byte[] getStringBytes(String value, String encoding) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        if (StringUtils.isEmpty(encoding)) {
            return value.getBytes();
        }
        byte[] data = null;
        try {
            data = value.getBytes(encoding);
        }
        catch (Throwable e) {
            MLog.error(TAG, e);
        }
        return data;
    }

    public static String replaceAll(String srcString, String matchingString, String replacement, boolean supportReplacementEmpty) {
        boolean flag = StringUtils.isEmpty(replacement);
        if (supportReplacementEmpty) {
            if (replacement == null) {
                replacement = "";
            }
            flag = false;
        }
        if (StringUtils.isEmpty(srcString) || StringUtils.isEmpty(matchingString) || flag) {
            return null;
        }
        StringBuffer sResult = new StringBuffer();
        int sIndex = 0;
        int sMaxIndex = srcString.length() - 1;
        while ((sIndex = srcString.indexOf(matchingString)) != -1) {
            String sPreStr = srcString.substring(0, sIndex);
            sResult.append(sPreStr).append(replacement);
            srcString = sIndex < sMaxIndex ? srcString.substring(sIndex + matchingString.length()) : "";
        }
        sResult.append(srcString);
        return sResult.toString();
    }

    public static String replaceAll(String srcString, String matchingString, String replacement) {
        return StringUtils.replaceAll(srcString, matchingString, replacement, false);
    }

    public static boolean containsChinese(String str) {
        try {
            Pattern p = Pattern.compile("[\\u4e00-\\u9fa5]");
            Matcher m = p.matcher(str);
            if (m.find()) {
                return true;
            }
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
        return false;
    }

    public static boolean isMakeUpWithNum(String str) {
        try {
            Pattern p = Pattern.compile("^[\\d-\\.]{2,}$");
            Matcher m = p.matcher(str);
            if (m.find()) {
                return true;
            }
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
        return false;
    }

    @NonNull
    public static String ensureNotNull(String aText) {
        if (aText == null) {
            return "";
        }
        return aText;
    }

    @NonNull
    public static String notNull(String str) {
        return StringUtils.ensureNotNull(str);
    }

    public static int compareVersion(String left, String right) {
        if (left == null && right == null || StringUtils.isEmpty(left) && StringUtils.isEmpty(right)) {
            return 0;
        }
        if (right == null || StringUtils.isEmpty(right)) {
            return 1;
        }
        if (left == null || StringUtils.isEmpty(left)) {
            return -1;
        }
        String[] leftArray = StringUtils.split(left, ".");
        String[] rightArray = StringUtils.split(right, ".");
        int compareStep = Math.min(leftArray.length, rightArray.length);
        for (int i = 0; i < compareStep; ++i) {
            int rightInt;
            int leftInt = StringUtils.parseInt(leftArray[i]);
            if (leftInt == (rightInt = StringUtils.parseInt(rightArray[i]))) continue;
            return leftInt - rightInt;
        }
        int compareResult = leftArray.length - rightArray.length;
        return compareResult;
    }

    public static void trime(List l) {
        if (l == null || l.size() <= 0) {
            return;
        }
        for (int i = 0; i < l.size(); ++i) {
            if (l.get(i) != null) continue;
            l.remove(i);
            --i;
        }
    }

    public static String getStringAndReplaceFromXML(String source, String ... args) {
        if (source != null) {
            for (int i = 0; i < args.length; ++i) {
                source = source.replace("[spstr" + (i + 1) + "]", args[i] + "");
            }
        }
        return source;
    }

    public static CharSequence getTextAndReplaceFromXML(String source, CharSequence ... args) {
        if (source != null && args.length > 0) {
            SpannableStringBuilder sb = new SpannableStringBuilder((CharSequence)source);
            for (int i = 0; i < args.length; ++i) {
                String searchKey = "[spstr" + (i + 1) + "]";
                int offset = sb.toString().indexOf(searchKey);
                sb.replace(offset, offset + searchKey.length(), args[i]);
            }
            return sb;
        }
        return source;
    }

    public static String getStringAndReplaceFromXML(String source, int ... args) {
        if (source != null) {
            for (int i = 0; i < args.length; ++i) {
                source = source.replace("[spstr" + (i + 1) + "]", args[i] + "");
            }
        }
        return source;
    }

    public static boolean startWithIgnoreCase(String oriString, String startString) {
        if (oriString == null || startString == null) {
            return false;
        }
        int length = startString.length();
        if (length > oriString.length()) {
            return false;
        }
        return startString.equalsIgnoreCase(oriString.substring(0, length));
    }

    public static String inputStream2String(InputStream is) {
        if (is == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuffer buffer = new StringBuffer();
        String line = "";
        try {
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
        try {
            in.close();
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
        return buffer.toString();
    }

    public static boolean isAscii(char c) {
        return c / 128 == 0;
    }

    public static CharSequence truncateStringMiddle(CharSequence string2, int length) {
        if (string2 == null) {
            return null;
        }
        if (string2.length() <= length) {
            return string2;
        }
        int uch = 0;
        int uct = 0;
        int ach = 0;
        int act = 0;
        int l = 0;
        int i = 0;
        int j = string2.length() - 1;
        while (i++ <= j--) {
            if (StringUtils.isAscii(string2.charAt(i))) {
                ++ach;
                ++l;
            } else {
                ++uch;
                l += 2;
            }
            if (i == j) break;
            if (StringUtils.isAscii(string2.charAt(j))) {
                ++act;
                ++l;
            } else {
                ++uct;
                l += 2;
            }
            if (l <= length) continue;
            return string2.subSequence(0, uch + ach - 3) + "..." + string2.subSequence(string2.length() - uct - act, string2.length());
        }
        return string2;
    }

    public static String subString(String text, int length) {
        int textLength = text.length();
        int byteLength = 0;
        StringBuffer stringBuffer = new StringBuffer();
        String substring = null;
        for (int i = 0; i < textLength && byteLength < length - 1; ++i) {
            substring = text.substring(i, i + 1);
            byteLength = substring.getBytes().length == 1 ? ++byteLength : (byteLength += 2);
            stringBuffer.append(substring);
        }
        return stringBuffer.toString();
    }

    public static String subString(String src, String from, String to) {
        if (StringUtils.isEmpty(src)) {
            return src;
        }
        int fromIndex = src.indexOf(from);
        if (fromIndex == -1) {
            return src;
        }
        fromIndex += from.length();
        if (StringUtils.isEmpty(to)) {
            return src.substring(fromIndex);
        }
        int toIndex = src.indexOf(to, fromIndex);
        if (toIndex == -1 || toIndex <= fromIndex) {
            return src.substring(fromIndex);
        }
        return src.substring(fromIndex, toIndex);
    }

    public static int getBytesLength(String str) {
        int nLength = 0;
        byte[] bytesGBK = null;
        try {
            bytesGBK = str.getBytes("GBK");
            nLength = bytesGBK.length;
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
        return nLength;
    }

    public static String getPrefixString(String originalString, int prefixMaxLength) {
        if (originalString == null || prefixMaxLength < 0 || originalString.length() <= prefixMaxLength) {
            return originalString;
        }
        return originalString.substring(0, prefixMaxLength);
    }

    public static boolean isStringObject(Object object) {
        return object != null && object instanceof String;
    }

    public static String getBodyContentFromXHTML2(String xhtml2) {
        String bodyContent = null;
        if (xhtml2 == null) {
            return bodyContent;
        }
        String bodyStartTag = "<body>";
        String bodyEndTag = "</body>";
        int pos1 = xhtml2.indexOf(bodyStartTag);
        int pos2 = xhtml2.indexOf(bodyEndTag);
        if (pos1 > 0 && pos2 > 0 && pos2 > pos1) {
            bodyContent = new String(xhtml2.substring(pos1 + bodyStartTag.length(), pos2).trim());
        } else if (pos1 > 0 && pos2 == -1) {
            bodyContent = new String(xhtml2.substring(pos1 + bodyStartTag.length()).trim());
        } else if (pos1 == -1 && pos2 > 0) {
            bodyContent = new String(xhtml2.substring(0, pos2).trim());
        }
        return bodyContent;
    }

    public static String trim(String originalString) {
        if (originalString == null) {
            return null;
        }
        return originalString.trim();
    }

    public static String subString(String src, String preString) {
        String result = src;
        if (StringUtils.isNotEmpty(src) && StringUtils.isNotEmpty(preString) && src.length() > preString.length() && src.indexOf(preString) > -1) {
            result = src.substring(preString.length());
        }
        return result;
    }

    public static String removeSurrogateChars(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return string2;
        }
        int length = string2.length();
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            if (c >= '\ud800' && c <= '\udfff') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean containsSurrogateChar(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return false;
        }
        int length = string2.length();
        boolean hasSurrogateChar = false;
        for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            if ('\ud800' > c || c > '\udfff') continue;
            hasSurrogateChar = true;
            break;
        }
        return hasSurrogateChar;
    }

    public static boolean containsSpecialCharacters(String str) {
        String limitEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern pattern = Pattern.compile(limitEx);
        Matcher m = pattern.matcher(str);
        return m.find();
    }

    public static String filterSpecificChar(String str) throws Exception {
        String regEx = "[`~!@#$%^&*()+=|{}':;',//[//].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static String cutOff(String text, int length) {
        if (text != null && text.length() > length) {
            text = text.substring(0, length);
        }
        return text;
    }

    public static String urlEncodeKeepAscii(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        if (length == 0) {
            return "";
        }
        StringBuilder asciiString = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c < '\u0000' || c > '\u007f') {
                try {
                    String hexRaw = StringUtils.formatWitUSLocal("%x", new BigInteger(1, value.substring(i, i + 1).getBytes("UTF-8")));
                    char[] hexRawArr = hexRaw.toCharArray();
                    String sep = "%";
                    for (int j = 0; j < hexRawArr.length; ++j) {
                        asciiString.append("%").append(hexRawArr[j]).append(hexRawArr[++j]);
                    }
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            asciiString.append(c);
        }
        return asciiString.toString();
    }

    public static SpannableString getHighlightText(String text, String keyword, int color) {
        if (FP.empty(text)) {
            text = "";
        }
        SpannableString s = new SpannableString((CharSequence)text);
        try {
            Pattern p = Pattern.compile(keyword, 2);
            Matcher m = p.matcher((CharSequence)s);
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                s.setSpan((Object)new ForegroundColorSpan(color), start, end, 33);
            }
            return s;
        }
        catch (PatternSyntaxException e) {
            MLog.info("xxf-kaede", "\u5305\u542b\u7279\u6b8a\u5b57\u7b26", new Object[0]);
            return s;
        }
    }

    public static SpannableString getHighlightText(String text, String keyword) {
        return StringUtils.getHighlightText(text, keyword, Color.parseColor((String)"#fac200"));
    }

    public static boolean isAllDigits(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static int safeParseInt(String str, int defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        int value = defaultValue;
        try {
            value = Integer.valueOf(str);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "safeParseInt " + str, e, new Object[0]);
        }
        return value;
    }

    public static int safeParseInt(String str) {
        return StringUtils.safeParseInt(str, 0);
    }

    public static long safeParseLong(String str) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        long value = 0L;
        try {
            value = Long.valueOf(str);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "safeParseLong " + str, e, new Object[0]);
        }
        return value;
    }

    public static float safeParseFloat(String str) {
        if (str == null || str.length() == 0) {
            return 0.0f;
        }
        float value = 0.0f;
        try {
            value = Float.valueOf(str).floatValue();
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "safeParseFloat " + str, e, new Object[0]);
        }
        return value;
    }

    public static double safeParseDouble(String str) {
        if (str == null || str.length() == 0) {
            return 0.0;
        }
        double value = 0.0;
        try {
            value = Double.valueOf(str);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "safeParseDouble " + str, e, new Object[0]);
        }
        return value;
    }

    public static boolean safeParseBoolean(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        boolean value = false;
        try {
            value = Boolean.valueOf(str);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "safeParseLong " + str, e, new Object[0]);
        }
        return value;
    }

    public static String getTextPolished(String text, int length, String suffix) {
        if (text.length() <= length) {
            return text;
        }
        return text.substring(0, length - 1) + suffix;
    }

    @Nullable
    public static Bitmap decodeBase64Pic(String picBase64) {
        Bitmap bitmap = null;
        try {
            byte[] picBinary = Base64.decode((String)picBase64, (int)0);
            bitmap = BitmapFactory.decodeByteArray((byte[])picBinary, (int)0, (int)picBinary.length);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"printStackTrace", (Throwable)e);
        }
        return bitmap;
    }

    public static boolean equal(String s1, String s2) {
        return StringUtils.equal(s1, s2, false);
    }

    public static boolean equal(String s1, String s2, boolean ignoreCase) {
        if (s1 != null && s2 != null) {
            if (ignoreCase) {
                return s1.equalsIgnoreCase(s2);
            }
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    public static boolean equal(Integer one, Integer two) {
        if (one == null || two == null) {
            return false;
        }
        return one.equals(two);
    }

    public static DecimalFormat getDecimalFormat(String format) {
        if (!YYTaskExecutor.isMainThread()) {
            return new DecimalFormat(format);
        }
        DecimalFormat df = mDecimalFormatCache.get(format);
        if (df == null) {
            df = new DecimalFormat(format);
            mDecimalFormatCache.put(format, df);
        }
        return df;
    }

    public static DecimalFormat getDecimalFormatWithUSLocal(String format) {
        if (!YYTaskExecutor.isMainThread()) {
            return new DecimalFormat(format, new DecimalFormatSymbols(Locale.US));
        }
        DecimalFormat df = mDecimalFormatUSCache.get(format);
        if (df == null) {
            df = new DecimalFormat(format, new DecimalFormatSymbols(Locale.US));
            mDecimalFormatUSCache.put(format, df);
        }
        return df;
    }

    public static NumberFormat getNumberFormatWithUSLocal(int value) {
        if (!YYTaskExecutor.isMainThread()) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(value);
            numberFormat.setGroupingUsed(true);
            return numberFormat;
        }
        NumberFormat numberFormat = (NumberFormat)sNumberFormatUSCache.get(value);
        if (numberFormat == null) {
            numberFormat = NumberFormat.getNumberInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(value);
            numberFormat.setGroupingUsed(true);
            sNumberFormatUSCache.put(value, (Object)numberFormat);
        }
        return numberFormat;
    }

    public static String getFormatedNumber(long num, int digits) {
        NumberFormat numberFormat = StringUtils.getNumberFormatWithUSLocal(digits);
        if ((double)num >= 1.0E9) {
            String format = numberFormat.format((double)num / 1.0E9);
            if (LanguageUtils.isIndonesian()) {
                return StringUtils.formatWitUSLocal("%sM", format);
            }
            return StringUtils.formatWitUSLocal("%sB", format);
        }
        if ((double)num >= 1000000.0) {
            String format = numberFormat.format((double)num / 1000000.0);
            if (LanguageUtils.isIndonesian()) {
                return StringUtils.formatWitUSLocal("%sJT", format);
            }
            return StringUtils.formatWitUSLocal("%sM", format);
        }
        if ((double)num >= 1000.0) {
            String format = numberFormat.format((double)num / 1000.0);
            if (LanguageUtils.isIndonesian()) {
                return StringUtils.formatWitUSLocal("%sRB", format);
            }
            return StringUtils.formatWitUSLocal("%sK", format);
        }
        return numberFormat.format(num);
    }

    public static String format(String format, Object ... args) {
        try {
            return String.format(Locale.getDefault(), format, args);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "string format", e, new Object[0]);
            return "";
        }
    }

    public static String formatWitUSLocal(String format, Object ... args) {
        try {
            return String.format(Locale.US, format, args);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "string format " + format, e, new Object[0]);
            return "";
        }
    }

    public static String clearWhite(Context context, String text) {
        boolean hasWhite = false;
        boolean isAllWhite = true;
        if (text != null) {
            char[] chars = text.toCharArray();
            StringBuilder builder = new StringBuilder();
            for (char c : chars) {
                if (!("%".equals(String.valueOf(c)) || Character.isWhitespace(c) && !StringUtils.containSpace(String.valueOf(c)))) {
                    hasWhite = false;
                    builder.append(c);
                    continue;
                }
                hasWhite = true;
            }
            for (char c : chars) {
                if (Character.isWhitespace(c)) continue;
                isAllWhite = false;
                break;
            }
            if (isAllWhite) {
                ToastUtils.showToast(context, ResourceUtils.getString(R.string.toast_nick_all_white), 0);
                return "";
            }
            if (hasWhite) {
                ToastUtils.showToast(context, ResourceUtils.getString(R.string.toast_nick_edit), 0);
            }
            return builder.toString();
        }
        return "";
    }

    public static boolean containSpace(CharSequence input) {
        return Pattern.compile("\\s+").matcher(input).find();
    }

    public static InputFilter getInputFilter(final int maxLength) {
        return new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                int dindex = 0;
                int count = 0;
                while (count <= maxLength && dindex < dest.length()) {
                    char c;
                    if ((c = dest.charAt(dindex++)) < '\u0080') {
                        ++count;
                        continue;
                    }
                    count += 2;
                }
                if (count > maxLength) {
                    return dest.subSequence(0, dindex - 1);
                }
                int sindex = 0;
                while (count <= maxLength && sindex < source.length()) {
                    char c;
                    if ((c = source.charAt(sindex++)) < '\u0080') {
                        ++count;
                        continue;
                    }
                    count += 2;
                }
                if (count > maxLength) {
                    --sindex;
                }
                return source.subSequence(0, sindex);
            }
        };
    }

    public static String getQuantityString(int count, @PluralsRes int resId) {
        Resources res = RuntimeContext.sApplicationContext.getResources();
        String quantityString = "";
        try {
            quantityString = res.getQuantityString(resId, count, new Object[]{count});
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
        return quantityString;
    }

    public static boolean isEmojiCharacter(char codePoint) {
        return !(codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff');
    }

    public static int containEmoji(String str) {
        int textCount = 0;
        int emojiCount = 0;
        if (!TextUtils.isEmpty((CharSequence)str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (StringUtils.isEmojiCharacter(str.charAt(i))) {
                    ++emojiCount;
                    continue;
                }
                ++textCount;
            }
            if (textCount > 0 && emojiCount > 0) {
                return 3;
            }
            if (textCount > 0 && emojiCount == 0) {
                return 2;
            }
            if (textCount == 0 && emojiCount > 0) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static Spanned getHtmlText(@StringRes int stringResId, Object ... objects) {
        Spanned text = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)ResourceUtils.getString(stringResId, objects), (int)0) : Html.fromHtml((String)ResourceUtils.getString(stringResId, objects));
        return text;
    }

    public static Spanned fromHtml(String srcText) {
        Spanned text = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)srcText, (int)63) : Html.fromHtml((String)srcText);
        return text;
    }

    public static String toHtml(Spanned src) {
        String text = Build.VERSION.SDK_INT >= 24 ? Html.toHtml((Spanned)src, (int)63) : Html.toHtml((Spanned)src);
        return text;
    }

    public static InputFilter enterFilter() {
        return new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                int i;
                MLog.info(StringUtils.TAG, "source:%s, start:%d, end:%d", source, start, end);
                for (i = start; i < end && source.charAt(i) != '\n'; ++i) {
                }
                if (i == end) {
                    return null;
                }
                if (end - start == 1) {
                    return "";
                }
                SpannableStringBuilder filtered = new SpannableStringBuilder(source, start, end);
                i -= start;
                for (int j = (end -= start) - 1; j >= i; --j) {
                    if (source.charAt(j) != '\n') continue;
                    filtered.delete(j, j + 1);
                }
                return filtered;
            }
        };
    }

    public static String capitalize(String str) {
        if (!FP.empty(str)) {
            char[] chars = str.toLowerCase().toCharArray();
            boolean isFound = false;
            for (int i = 0; i < chars.length; ++i) {
                if (!isFound && Character.isLetter(chars[i])) {
                    chars[i] = Character.toUpperCase(chars[i]);
                    isFound = true;
                    continue;
                }
                if (!Character.isWhitespace(chars[i])) continue;
                isFound = false;
            }
            return String.valueOf(chars);
        }
        return str;
    }

    public static int getStringLength(String str) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        return str.codePointCount(0, str.length());
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    public static boolean isHighSurrogate(String ch, int index) {
        if (StringUtils.isNotEmpty(ch) && index < ch.length()) {
            return Character.isHighSurrogate(ch.charAt(index));
        }
        return false;
    }

    public static String combineStr(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object.toString());
        }
        return sb.toString();
    }

    public static String safeCombineStr(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object == null ? "" : object.toString());
        }
        return sb.toString();
    }
}

